/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"available", "balance", "currency", "pending", "reserved"})
public class Balance {
    public static final String JSON_PROPERTY_AVAILABLE = "available";
    private Long available;
    public static final String JSON_PROPERTY_BALANCE = "balance";
    private Long balance;
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private String currency;
    public static final String JSON_PROPERTY_PENDING = "pending";
    private Long pending;
    public static final String JSON_PROPERTY_RESERVED = "reserved";
    private Long reserved;

    public Balance available(Long available) {
        this.available = available;
        return this;
    }

    @ApiModelProperty(required=true, value="The remaining amount available for spending.")
    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAvailable() {
        return this.available;
    }

    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAvailable(Long available) {
        this.available = available;
    }

    public Balance balance(Long balance) {
        this.balance = balance;
        return this;
    }

    @ApiModelProperty(required=true, value="The total amount in the balance.")
    @JsonProperty(value="balance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getBalance() {
        return this.balance;
    }

    @JsonProperty(value="balance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalance(Long balance) {
        this.balance = balance;
    }

    public Balance currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(required=true, value="The three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes) of the balance.")
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Balance pending(Long pending) {
        this.pending = pending;
        return this;
    }

    @ApiModelProperty(value="The amount pending to be paid out but not yet available in the balance.")
    @JsonProperty(value="pending")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getPending() {
        return this.pending;
    }

    @JsonProperty(value="pending")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPending(Long pending) {
        this.pending = pending;
    }

    public Balance reserved(Long reserved) {
        this.reserved = reserved;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount reserved for payments that have been authorised, but have not been captured yet.")
    @JsonProperty(value="reserved")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getReserved() {
        return this.reserved;
    }

    @JsonProperty(value="reserved")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReserved(Long reserved) {
        this.reserved = reserved;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Balance balance = (Balance)o;
        return Objects.equals(this.available, balance.available) && Objects.equals(this.balance, balance.balance) && Objects.equals(this.currency, balance.currency) && Objects.equals(this.pending, balance.pending) && Objects.equals(this.reserved, balance.reserved);
    }

    public int hashCode() {
        return Objects.hash(this.available, this.balance, this.currency, this.pending, this.reserved);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Balance {\n");
        sb.append("    available: ").append(this.toIndentedString(this.available)).append("\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    pending: ").append(this.toIndentedString(this.pending)).append("\n");
        sb.append("    reserved: ").append(this.toIndentedString(this.reserved)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Balance fromJson(String jsonString) throws JsonProcessingException {
        return (Balance)JSON.getMapper().readValue(jsonString, Balance.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

