/*
 * Configuration webhooks
 *
 * The version of the OpenAPI document: 1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.configurationwebhooks;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * PersonalData
 */
@JsonPropertyOrder({
  PersonalData.JSON_PROPERTY_DATE_OF_BIRTH,
  PersonalData.JSON_PROPERTY_ID_NUMBER,
  PersonalData.JSON_PROPERTY_NATIONALITY
})

public class PersonalData {
  public static final String JSON_PROPERTY_DATE_OF_BIRTH = "dateOfBirth";
  private String dateOfBirth;

  public static final String JSON_PROPERTY_ID_NUMBER = "idNumber";
  private String idNumber;

  public static final String JSON_PROPERTY_NATIONALITY = "nationality";
  private String nationality;

  public PersonalData() { 
  }

  public PersonalData dateOfBirth(String dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
    return this;
  }

   /**
   * The date of birth of the person. The date should be in ISO-8601 format yyyy-mm-dd (e.g. 2000-01-31).
   * @return dateOfBirth
  **/
  @ApiModelProperty(value = "The date of birth of the person. The date should be in ISO-8601 format yyyy-mm-dd (e.g. 2000-01-31).")
  @JsonProperty(JSON_PROPERTY_DATE_OF_BIRTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDateOfBirth() {
    return dateOfBirth;
  }


  @JsonProperty(JSON_PROPERTY_DATE_OF_BIRTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDateOfBirth(String dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
  }


  public PersonalData idNumber(String idNumber) {
    this.idNumber = idNumber;
    return this;
  }

   /**
   * An ID number of the person.
   * @return idNumber
  **/
  @ApiModelProperty(value = "An ID number of the person.")
  @JsonProperty(JSON_PROPERTY_ID_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIdNumber() {
    return idNumber;
  }


  @JsonProperty(JSON_PROPERTY_ID_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdNumber(String idNumber) {
    this.idNumber = idNumber;
  }


  public PersonalData nationality(String nationality) {
    this.nationality = nationality;
    return this;
  }

   /**
   * The nationality of the person represented by a two-character country code. &gt;The permitted country codes are defined in ISO-3166-1 alpha-2 (e.g. &#39;NL&#39;).
   * @return nationality
  **/
  @ApiModelProperty(value = "The nationality of the person represented by a two-character country code. >The permitted country codes are defined in ISO-3166-1 alpha-2 (e.g. 'NL').")
  @JsonProperty(JSON_PROPERTY_NATIONALITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNationality() {
    return nationality;
  }


  @JsonProperty(JSON_PROPERTY_NATIONALITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNationality(String nationality) {
    this.nationality = nationality;
  }


  /**
   * Return true if this PersonalData object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PersonalData personalData = (PersonalData) o;
    return Objects.equals(this.dateOfBirth, personalData.dateOfBirth) &&
        Objects.equals(this.idNumber, personalData.idNumber) &&
        Objects.equals(this.nationality, personalData.nationality);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dateOfBirth, idNumber, nationality);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PersonalData {\n");
    sb.append("    dateOfBirth: ").append(toIndentedString(dateOfBirth)).append("\n");
    sb.append("    idNumber: ").append(toIndentedString(idNumber)).append("\n");
    sb.append("    nationality: ").append(toIndentedString(nationality)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of PersonalData given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PersonalData
   * @throws JsonProcessingException if the JSON string is invalid with respect to PersonalData
   */
  public static PersonalData fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PersonalData.class);
  }
/**
  * Convert an instance of PersonalData to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

