/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.balanceplatform;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.balanceplatform.GrantOffer;
import com.adyen.model.balanceplatform.GrantOffers;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class GrantOffersApi
extends Service {
    protected String baseURL = this.createBaseURL("https://balanceplatform-api-test.adyen.com/bcl/v2");

    public GrantOffersApi(Client client) {
        super(client);
    }

    public GrantOffers getAllAvailableGrantOffers(String accountHolderId) throws ApiException, IOException {
        return this.getAllAvailableGrantOffers(accountHolderId, null);
    }

    public GrantOffers getAllAvailableGrantOffers(String accountHolderId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (accountHolderId != null) {
            queryParams.put("accountHolderId", accountHolderId);
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/grantOffers", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, null, queryParams);
        return GrantOffers.fromJson(jsonResult);
    }

    public GrantOffer getGrantOffer(String grantOfferId) throws ApiException, IOException {
        return this.getGrantOffer(grantOfferId, null);
    }

    public GrantOffer getGrantOffer(String grantOfferId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (grantOfferId == null) {
            throw new IllegalArgumentException("Please provide the grantOfferId path parameter");
        }
        pathParams.put("grantOfferId", grantOfferId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/grantOffers/{grantOfferId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return GrantOffer.fromJson(jsonResult);
    }
}

