/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transferwebhooks;

import com.adyen.model.transferwebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"accountNumber", "clearingNumber", "type"})
public class SELocalAccountIdentification {
    public static final String JSON_PROPERTY_ACCOUNT_NUMBER = "accountNumber";
    private String accountNumber;
    public static final String JSON_PROPERTY_CLEARING_NUMBER = "clearingNumber";
    private String clearingNumber;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type = TypeEnum.SELOCAL;

    public SELocalAccountIdentification accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The 7- to 10-digit bank account number ([Bankkontonummer](https://sv.wikipedia.org/wiki/Bankkonto)), without the clearing number, separators, or whitespace.")
    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountNumber() {
        return this.accountNumber;
    }

    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public SELocalAccountIdentification clearingNumber(String clearingNumber) {
        this.clearingNumber = clearingNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The 4- to 5-digit clearing number ([Clearingnummer](https://sv.wikipedia.org/wiki/Clearingnummer)), without separators or whitespace.")
    @JsonProperty(value="clearingNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClearingNumber() {
        return this.clearingNumber;
    }

    @JsonProperty(value="clearingNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClearingNumber(String clearingNumber) {
        this.clearingNumber = clearingNumber;
    }

    public SELocalAccountIdentification type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="**seLocal**")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SELocalAccountIdentification seLocalAccountIdentification = (SELocalAccountIdentification)o;
        return Objects.equals(this.accountNumber, seLocalAccountIdentification.accountNumber) && Objects.equals(this.clearingNumber, seLocalAccountIdentification.clearingNumber) && Objects.equals((Object)this.type, (Object)seLocalAccountIdentification.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountNumber, this.clearingNumber, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SELocalAccountIdentification {\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    clearingNumber: ").append(this.toIndentedString(this.clearingNumber)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static SELocalAccountIdentification fromJson(String jsonString) throws JsonProcessingException {
        return (SELocalAccountIdentification)JSON.getMapper().readValue(jsonString, SELocalAccountIdentification.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        SELOCAL("seLocal");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

