/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"accountNumber", "accountSuffix", "bankCode", "type"})
public class NZLocalAccountIdentification {
    public static final String JSON_PROPERTY_ACCOUNT_NUMBER = "accountNumber";
    private String accountNumber;
    public static final String JSON_PROPERTY_ACCOUNT_SUFFIX = "accountSuffix";
    private String accountSuffix;
    public static final String JSON_PROPERTY_BANK_CODE = "bankCode";
    private String bankCode;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type = TypeEnum.NZLOCAL;

    public NZLocalAccountIdentification accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The 7-digit bank account number, without separators or whitespace.")
    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountNumber() {
        return this.accountNumber;
    }

    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public NZLocalAccountIdentification accountSuffix(String accountSuffix) {
        this.accountSuffix = accountSuffix;
        return this;
    }

    @ApiModelProperty(required=true, value="The 2- to 3-digit account suffix, without separators or whitespace.")
    @JsonProperty(value="accountSuffix")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountSuffix() {
        return this.accountSuffix;
    }

    @JsonProperty(value="accountSuffix")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountSuffix(String accountSuffix) {
        this.accountSuffix = accountSuffix;
    }

    public NZLocalAccountIdentification bankCode(String bankCode) {
        this.bankCode = bankCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The 6-digit bank code including the 2-digit bank code and 4-digit branch code, without separators or whitespace.")
    @JsonProperty(value="bankCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankCode() {
        return this.bankCode;
    }

    @JsonProperty(value="bankCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public NZLocalAccountIdentification type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="**nzLocal**")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NZLocalAccountIdentification nzLocalAccountIdentification = (NZLocalAccountIdentification)o;
        return Objects.equals(this.accountNumber, nzLocalAccountIdentification.accountNumber) && Objects.equals(this.accountSuffix, nzLocalAccountIdentification.accountSuffix) && Objects.equals(this.bankCode, nzLocalAccountIdentification.bankCode) && Objects.equals((Object)this.type, (Object)nzLocalAccountIdentification.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountNumber, this.accountSuffix, this.bankCode, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NZLocalAccountIdentification {\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    accountSuffix: ").append(this.toIndentedString(this.accountSuffix)).append("\n");
        sb.append("    bankCode: ").append(this.toIndentedString(this.bankCode)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static NZLocalAccountIdentification fromJson(String jsonString) throws JsonProcessingException {
        return (NZLocalAccountIdentification)JSON.getMapper().readValue(jsonString, NZLocalAccountIdentification.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        NZLOCAL("nzLocal");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

