/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service;

import com.adyen.ApiKeyAuthenticatedService;
import com.adyen.Client;
import com.adyen.model.terminal.TerminalAPIRequest;
import com.adyen.model.terminal.TerminalAPIResponse;
import com.adyen.model.terminal.TerminalAPISecuredRequest;
import com.adyen.model.terminal.TerminalAPISecuredResponse;
import com.adyen.model.terminal.security.SaleToPOISecuredMessage;
import com.adyen.model.terminal.security.SecurityKey;
import com.adyen.service.resource.terminal.local.LocalRequest;
import com.adyen.terminal.security.NexoCrypto;
import com.adyen.terminal.security.exception.NexoCryptoException;
import com.adyen.terminal.serialization.TerminalAPIGsonBuilder;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

public class TerminalLocalAPI
extends ApiKeyAuthenticatedService {
    private final LocalRequest localRequest = new LocalRequest(this);
    private final NexoCrypto nexoCrypto;
    private final Gson terminalApiGson;

    public TerminalLocalAPI(Client client, SecurityKey securityKey) throws NexoCryptoException {
        super(client);
        this.nexoCrypto = new NexoCrypto(securityKey);
        this.terminalApiGson = TerminalAPIGsonBuilder.create();
    }

    public TerminalAPIResponse request(TerminalAPIRequest terminalAPIRequest) throws Exception {
        String jsonRequest = this.terminalApiGson.toJson((Object)terminalAPIRequest);
        SaleToPOISecuredMessage saleToPOISecuredRequest = this.nexoCrypto.encrypt(jsonRequest, terminalAPIRequest.getSaleToPOIRequest().getMessageHeader());
        TerminalAPISecuredRequest securedPaymentRequest = new TerminalAPISecuredRequest();
        securedPaymentRequest.setSaleToPOIRequest(saleToPOISecuredRequest);
        String jsonEncryptedRequest = this.terminalApiGson.toJson((Object)securedPaymentRequest);
        String jsonResponse = this.localRequest.request(jsonEncryptedRequest);
        if (jsonResponse == null || jsonResponse.isEmpty()) {
            return null;
        }
        TerminalAPISecuredResponse securedPaymentResponse = (TerminalAPISecuredResponse)this.terminalApiGson.fromJson(jsonResponse, new TypeToken<TerminalAPISecuredResponse>(){}.getType());
        SaleToPOISecuredMessage saleToPOISecuredResponse = securedPaymentResponse.getSaleToPOIResponse();
        String jsonDecryptedResponse = this.nexoCrypto.decrypt(saleToPOISecuredResponse);
        return (TerminalAPIResponse)this.terminalApiGson.fromJson(jsonDecryptedResponse, new TypeToken<TerminalAPIResponse>(){}.getType());
    }
}

