/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.Authentication;
import com.adyen.model.balanceplatform.CardConfiguration;
import com.adyen.model.balanceplatform.DeliveryContact;
import com.adyen.model.balanceplatform.Expiry;
import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"authentication", "bin", "brand", "brandVariant", "cardholderName", "configuration", "cvc", "deliveryContact", "expiration", "formFactor", "lastFour", "number"})
public class Card {
    public static final String JSON_PROPERTY_AUTHENTICATION = "authentication";
    private Authentication authentication;
    public static final String JSON_PROPERTY_BIN = "bin";
    private String bin;
    public static final String JSON_PROPERTY_BRAND = "brand";
    private String brand;
    public static final String JSON_PROPERTY_BRAND_VARIANT = "brandVariant";
    private String brandVariant;
    public static final String JSON_PROPERTY_CARDHOLDER_NAME = "cardholderName";
    private String cardholderName;
    public static final String JSON_PROPERTY_CONFIGURATION = "configuration";
    private CardConfiguration configuration;
    public static final String JSON_PROPERTY_CVC = "cvc";
    private String cvc;
    public static final String JSON_PROPERTY_DELIVERY_CONTACT = "deliveryContact";
    private DeliveryContact deliveryContact;
    public static final String JSON_PROPERTY_EXPIRATION = "expiration";
    private Expiry expiration;
    public static final String JSON_PROPERTY_FORM_FACTOR = "formFactor";
    private FormFactorEnum formFactor;
    public static final String JSON_PROPERTY_LAST_FOUR = "lastFour";
    private String lastFour;
    public static final String JSON_PROPERTY_NUMBER = "number";
    private String number;

    public Card authentication(Authentication authentication) {
        this.authentication = authentication;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="authentication")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Authentication getAuthentication() {
        return this.authentication;
    }

    @JsonProperty(value="authentication")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public Card bin(String bin) {
        this.bin = bin;
        return this;
    }

    @ApiModelProperty(value="The bank identification number (BIN) of the card number.")
    @JsonProperty(value="bin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBin() {
        return this.bin;
    }

    @JsonProperty(value="bin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBin(String bin) {
        this.bin = bin;
    }

    public Card brand(String brand) {
        this.brand = brand;
        return this;
    }

    @ApiModelProperty(required=true, value="The brand of the physical or the virtual card. Possible values: **visa**, **mc**.")
    @JsonProperty(value="brand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBrand() {
        return this.brand;
    }

    @JsonProperty(value="brand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBrand(String brand) {
        this.brand = brand;
    }

    public Card brandVariant(String brandVariant) {
        this.brandVariant = brandVariant;
        return this;
    }

    @ApiModelProperty(required=true, value="The brand variant of the physical or the virtual card. >Contact your Adyen Implementation Manager to get the values that are relevant to your integration. Examples: **visadebit**, **mcprepaid**.")
    @JsonProperty(value="brandVariant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBrandVariant() {
        return this.brandVariant;
    }

    @JsonProperty(value="brandVariant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBrandVariant(String brandVariant) {
        this.brandVariant = brandVariant;
    }

    public Card cardholderName(String cardholderName) {
        this.cardholderName = cardholderName;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the cardholder.  Maximum length: 26 characters.")
    @JsonProperty(value="cardholderName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCardholderName() {
        return this.cardholderName;
    }

    @JsonProperty(value="cardholderName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCardholderName(String cardholderName) {
        this.cardholderName = cardholderName;
    }

    public Card configuration(CardConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="configuration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CardConfiguration getConfiguration() {
        return this.configuration;
    }

    @JsonProperty(value="configuration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConfiguration(CardConfiguration configuration) {
        this.configuration = configuration;
    }

    public Card cvc(String cvc) {
        this.cvc = cvc;
        return this;
    }

    @ApiModelProperty(value="The CVC2 value of the card. > The CVC2 is not sent by default. This is only returned in the `POST` response for single-use virtual cards.")
    @JsonProperty(value="cvc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCvc() {
        return this.cvc;
    }

    @JsonProperty(value="cvc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCvc(String cvc) {
        this.cvc = cvc;
    }

    public Card deliveryContact(DeliveryContact deliveryContact) {
        this.deliveryContact = deliveryContact;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="deliveryContact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DeliveryContact getDeliveryContact() {
        return this.deliveryContact;
    }

    @JsonProperty(value="deliveryContact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryContact(DeliveryContact deliveryContact) {
        this.deliveryContact = deliveryContact;
    }

    public Card expiration(Expiry expiration) {
        this.expiration = expiration;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="expiration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Expiry getExpiration() {
        return this.expiration;
    }

    @JsonProperty(value="expiration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiration(Expiry expiration) {
        this.expiration = expiration;
    }

    public Card formFactor(FormFactorEnum formFactor) {
        this.formFactor = formFactor;
        return this;
    }

    @ApiModelProperty(required=true, value="The form factor of the card. Possible values: **virtual**, **physical**.")
    @JsonProperty(value="formFactor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FormFactorEnum getFormFactor() {
        return this.formFactor;
    }

    @JsonProperty(value="formFactor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormFactor(FormFactorEnum formFactor) {
        this.formFactor = formFactor;
    }

    public Card lastFour(String lastFour) {
        this.lastFour = lastFour;
        return this;
    }

    @ApiModelProperty(value="Last last four digits of the card number.")
    @JsonProperty(value="lastFour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastFour() {
        return this.lastFour;
    }

    @JsonProperty(value="lastFour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastFour(String lastFour) {
        this.lastFour = lastFour;
    }

    public Card number(String number) {
        this.number = number;
        return this;
    }

    @ApiModelProperty(required=true, value="The primary account number (PAN) of the card. > The PAN is masked by default and returned only for single-use virtual cards.")
    @JsonProperty(value="number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNumber() {
        return this.number;
    }

    @JsonProperty(value="number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumber(String number) {
        this.number = number;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Card card = (Card)o;
        return Objects.equals(this.authentication, card.authentication) && Objects.equals(this.bin, card.bin) && Objects.equals(this.brand, card.brand) && Objects.equals(this.brandVariant, card.brandVariant) && Objects.equals(this.cardholderName, card.cardholderName) && Objects.equals(this.configuration, card.configuration) && Objects.equals(this.cvc, card.cvc) && Objects.equals(this.deliveryContact, card.deliveryContact) && Objects.equals(this.expiration, card.expiration) && Objects.equals((Object)this.formFactor, (Object)card.formFactor) && Objects.equals(this.lastFour, card.lastFour) && Objects.equals(this.number, card.number);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authentication, this.bin, this.brand, this.brandVariant, this.cardholderName, this.configuration, this.cvc, this.deliveryContact, this.expiration, this.formFactor, this.lastFour, this.number});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Card {\n");
        sb.append("    authentication: ").append(this.toIndentedString(this.authentication)).append("\n");
        sb.append("    bin: ").append(this.toIndentedString(this.bin)).append("\n");
        sb.append("    brand: ").append(this.toIndentedString(this.brand)).append("\n");
        sb.append("    brandVariant: ").append(this.toIndentedString(this.brandVariant)).append("\n");
        sb.append("    cardholderName: ").append(this.toIndentedString(this.cardholderName)).append("\n");
        sb.append("    configuration: ").append(this.toIndentedString(this.configuration)).append("\n");
        sb.append("    cvc: ").append(this.toIndentedString(this.cvc)).append("\n");
        sb.append("    deliveryContact: ").append(this.toIndentedString(this.deliveryContact)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    formFactor: ").append(this.toIndentedString((Object)this.formFactor)).append("\n");
        sb.append("    lastFour: ").append(this.toIndentedString(this.lastFour)).append("\n");
        sb.append("    number: ").append(this.toIndentedString(this.number)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Card fromJson(String jsonString) throws JsonProcessingException {
        return (Card)JSON.getMapper().readValue(jsonString, Card.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum FormFactorEnum {
        PHYSICAL("physical"),
        UNKNOWN("unknown"),
        VIRTUAL("virtual");

        private String value;

        private FormFactorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FormFactorEnum fromValue(String value) {
            for (FormFactorEnum b : FormFactorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

