/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PayAtTable {
    public static final String SERIALIZED_NAME_AUTHENTICATION_METHOD = "authenticationMethod";
    @SerializedName(value="authenticationMethod")
    private AuthenticationMethodEnum authenticationMethod;
    public static final String SERIALIZED_NAME_ENABLE_PAY_AT_TABLE = "enablePayAtTable";
    @SerializedName(value="enablePayAtTable")
    private Boolean enablePayAtTable;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public PayAtTable authenticationMethod(AuthenticationMethodEnum authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
        return this;
    }

    @ApiModelProperty(value="Allowed authentication methods: Magswipe, Manual Entry.")
    public AuthenticationMethodEnum getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(AuthenticationMethodEnum authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public PayAtTable enablePayAtTable(Boolean enablePayAtTable) {
        this.enablePayAtTable = enablePayAtTable;
        return this;
    }

    @ApiModelProperty(value="Enable Pay at table.")
    public Boolean getEnablePayAtTable() {
        return this.enablePayAtTable;
    }

    public void setEnablePayAtTable(Boolean enablePayAtTable) {
        this.enablePayAtTable = enablePayAtTable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayAtTable payAtTable = (PayAtTable)o;
        return Objects.equals((Object)this.authenticationMethod, (Object)payAtTable.authenticationMethod) && Objects.equals(this.enablePayAtTable, payAtTable.enablePayAtTable);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authenticationMethod, this.enablePayAtTable});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayAtTable {\n");
        sb.append("    authenticationMethod: ").append(this.toIndentedString((Object)this.authenticationMethod)).append("\n");
        sb.append("    enablePayAtTable: ").append(this.toIndentedString(this.enablePayAtTable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PayAtTable is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `PayAtTable` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AUTHENTICATION_METHOD) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_AUTHENTICATION_METHOD).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `authenticationMethod` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUTHENTICATION_METHOD).toString()));
            }
            AuthenticationMethodEnum.fromValue(jsonObj.get(SERIALIZED_NAME_AUTHENTICATION_METHOD).getAsString());
        }
    }

    public static PayAtTable fromJson(String jsonString) throws IOException {
        return (PayAtTable)JSON.getGson().fromJson(jsonString, PayAtTable.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AUTHENTICATION_METHOD);
        openapiFields.add(SERIALIZED_NAME_ENABLE_PAY_AT_TABLE);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(PayAtTable.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PayAtTable.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PayAtTable.class));
            return new TypeAdapter<PayAtTable>(){

                public void write(JsonWriter out, PayAtTable value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PayAtTable read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PayAtTable.validateJsonObject(jsonObj);
                    return (PayAtTable)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AuthenticationMethodEnum {
        MAGSWIPE("MAGSWIPE"),
        MKE("MKE");

        private String value;

        private AuthenticationMethodEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AuthenticationMethodEnum fromValue(String value) {
            for (AuthenticationMethodEnum b : AuthenticationMethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<AuthenticationMethodEnum> {
            public void write(JsonWriter jsonWriter, AuthenticationMethodEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AuthenticationMethodEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AuthenticationMethodEnum.fromValue(value);
            }
        }
    }
}

