/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FraudCheckResult {
    public static final String SERIALIZED_NAME_ACCOUNT_SCORE = "accountScore";
    @SerializedName(value="accountScore")
    private Integer accountScore;
    public static final String SERIALIZED_NAME_CHECK_ID = "checkId";
    @SerializedName(value="checkId")
    private Integer checkId;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public FraudCheckResult accountScore(Integer accountScore) {
        this.accountScore = accountScore;
        return this;
    }

    @ApiModelProperty(required=true, value="The fraud score generated by the risk check.")
    public Integer getAccountScore() {
        return this.accountScore;
    }

    public void setAccountScore(Integer accountScore) {
        this.accountScore = accountScore;
    }

    public FraudCheckResult checkId(Integer checkId) {
        this.checkId = checkId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the risk check.")
    public Integer getCheckId() {
        return this.checkId;
    }

    public void setCheckId(Integer checkId) {
        this.checkId = checkId;
    }

    public FraudCheckResult name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the risk check.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FraudCheckResult fraudCheckResult = (FraudCheckResult)o;
        return Objects.equals(this.accountScore, fraudCheckResult.accountScore) && Objects.equals(this.checkId, fraudCheckResult.checkId) && Objects.equals(this.name, fraudCheckResult.name);
    }

    public int hashCode() {
        return Objects.hash(this.accountScore, this.checkId, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FraudCheckResult {\n");
        sb.append("    accountScore: ").append(this.toIndentedString(this.accountScore)).append("\n");
        sb.append("    checkId: ").append(this.toIndentedString(this.checkId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in FraudCheckResult is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `FraudCheckResult` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
    }

    public static FraudCheckResult fromJson(String jsonString) throws IOException {
        return (FraudCheckResult)JSON.getGson().fromJson(jsonString, FraudCheckResult.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_SCORE);
        openapiFields.add(SERIALIZED_NAME_CHECK_ID);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ACCOUNT_SCORE);
        openapiRequiredFields.add(SERIALIZED_NAME_CHECK_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        log = Logger.getLogger(FraudCheckResult.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!FraudCheckResult.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FraudCheckResult.class));
            return new TypeAdapter<FraudCheckResult>(){

                public void write(JsonWriter out, FraudCheckResult value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public FraudCheckResult read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    FraudCheckResult.validateJsonObject(jsonObj);
                    return (FraudCheckResult)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

