/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.AccountSupportingEntityCapability;
import com.adyen.model.balanceplatform.CapabilitySettings;
import com.adyen.model.balanceplatform.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AccountHolderCapability {
    public static final String SERIALIZED_NAME_ALLOWED = "allowed";
    @SerializedName(value="allowed")
    private Boolean allowed;
    public static final String SERIALIZED_NAME_ALLOWED_LEVEL = "allowedLevel";
    @SerializedName(value="allowedLevel")
    private AllowedLevelEnum allowedLevel;
    public static final String SERIALIZED_NAME_ALLOWED_SETTINGS = "allowedSettings";
    @SerializedName(value="allowedSettings")
    private CapabilitySettings allowedSettings;
    public static final String SERIALIZED_NAME_ENABLED = "enabled";
    @SerializedName(value="enabled")
    private Boolean enabled;
    public static final String SERIALIZED_NAME_PROBLEMS = "problems";
    @SerializedName(value="problems")
    private List<Object> problems = null;
    public static final String SERIALIZED_NAME_REQUESTED = "requested";
    @SerializedName(value="requested")
    private Boolean requested;
    public static final String SERIALIZED_NAME_REQUESTED_LEVEL = "requestedLevel";
    @SerializedName(value="requestedLevel")
    private RequestedLevelEnum requestedLevel;
    public static final String SERIALIZED_NAME_REQUESTED_SETTINGS = "requestedSettings";
    @SerializedName(value="requestedSettings")
    private CapabilitySettings requestedSettings;
    public static final String SERIALIZED_NAME_TRANSFER_INSTRUMENTS = "transferInstruments";
    @SerializedName(value="transferInstruments")
    private List<AccountSupportingEntityCapability> transferInstruments = null;
    public static final String SERIALIZED_NAME_VERIFICATION_STATUS = "verificationStatus";
    @SerializedName(value="verificationStatus")
    private VerificationStatusEnum verificationStatus;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AccountHolderCapability() {
    }

    public AccountHolderCapability(Boolean allowed, AllowedLevelEnum allowedLevel, List<Object> problems, VerificationStatusEnum verificationStatus) {
        this();
        this.allowed = allowed;
        this.allowedLevel = allowedLevel;
        this.problems = problems;
        this.verificationStatus = verificationStatus;
    }

    @ApiModelProperty(value="Indicates whether the capability is allowed. Adyen sets this to **true** if the verification is successful and the account holder is permitted to use the capability.")
    public Boolean getAllowed() {
        return this.allowed;
    }

    @ApiModelProperty(value="The capability level that is allowed for the account holder.  Possible values: **notApplicable**, **low**, **medium**, **high**.")
    public AllowedLevelEnum getAllowedLevel() {
        return this.allowedLevel;
    }

    public AccountHolderCapability allowedSettings(CapabilitySettings allowedSettings) {
        this.allowedSettings = allowedSettings;
        return this;
    }

    @ApiModelProperty(value="")
    public CapabilitySettings getAllowedSettings() {
        return this.allowedSettings;
    }

    public void setAllowedSettings(CapabilitySettings allowedSettings) {
        this.allowedSettings = allowedSettings;
    }

    public AccountHolderCapability enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the capability is enabled. If **false**, the capability is temporarily disabled for the account holder.")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @ApiModelProperty(value="Contains verification errors and the actions that you can take to resolve them.")
    public List<Object> getProblems() {
        return this.problems;
    }

    public AccountHolderCapability requested(Boolean requested) {
        this.requested = requested;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the capability is requested. To check whether the account holder is permitted to use the capability, refer to the `allowed` field.")
    public Boolean getRequested() {
        return this.requested;
    }

    public void setRequested(Boolean requested) {
        this.requested = requested;
    }

    public AccountHolderCapability requestedLevel(RequestedLevelEnum requestedLevel) {
        this.requestedLevel = requestedLevel;
        return this;
    }

    @ApiModelProperty(value="The requested level of the capability. Some capabilities, such as those used in [card issuing](https://docs.adyen.com/issuing/add-capabilities#capability-levels), have different levels. Levels increase the capability, but also require additional checks and increased monitoring.  Possible values: **notApplicable**, **low**, **medium**, **high**.")
    public RequestedLevelEnum getRequestedLevel() {
        return this.requestedLevel;
    }

    public void setRequestedLevel(RequestedLevelEnum requestedLevel) {
        this.requestedLevel = requestedLevel;
    }

    public AccountHolderCapability requestedSettings(CapabilitySettings requestedSettings) {
        this.requestedSettings = requestedSettings;
        return this;
    }

    @ApiModelProperty(value="")
    public CapabilitySettings getRequestedSettings() {
        return this.requestedSettings;
    }

    public void setRequestedSettings(CapabilitySettings requestedSettings) {
        this.requestedSettings = requestedSettings;
    }

    public AccountHolderCapability transferInstruments(List<AccountSupportingEntityCapability> transferInstruments) {
        this.transferInstruments = transferInstruments;
        return this;
    }

    public AccountHolderCapability addTransferInstrumentsItem(AccountSupportingEntityCapability transferInstrumentsItem) {
        if (this.transferInstruments == null) {
            this.transferInstruments = new ArrayList<AccountSupportingEntityCapability>();
        }
        this.transferInstruments.add(transferInstrumentsItem);
        return this;
    }

    @ApiModelProperty(value="Contains the status of the transfer instruments associated with this capability. ")
    public List<AccountSupportingEntityCapability> getTransferInstruments() {
        return this.transferInstruments;
    }

    public void setTransferInstruments(List<AccountSupportingEntityCapability> transferInstruments) {
        this.transferInstruments = transferInstruments;
    }

    @ApiModelProperty(value="The status of the verification checks for the capability.  Possible values:  * **pending**: Adyen is running the verification.  * **invalid**: The verification failed. Check if the `errors` array contains more information.  * **valid**: The verification has been successfully completed.  * **rejected**: Adyen has verified the information, but found reasons to not allow the capability. ")
    public VerificationStatusEnum getVerificationStatus() {
        return this.verificationStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountHolderCapability accountHolderCapability = (AccountHolderCapability)o;
        return Objects.equals(this.allowed, accountHolderCapability.allowed) && Objects.equals((Object)this.allowedLevel, (Object)accountHolderCapability.allowedLevel) && Objects.equals(this.allowedSettings, accountHolderCapability.allowedSettings) && Objects.equals(this.enabled, accountHolderCapability.enabled) && Objects.equals(this.problems, accountHolderCapability.problems) && Objects.equals(this.requested, accountHolderCapability.requested) && Objects.equals((Object)this.requestedLevel, (Object)accountHolderCapability.requestedLevel) && Objects.equals(this.requestedSettings, accountHolderCapability.requestedSettings) && Objects.equals(this.transferInstruments, accountHolderCapability.transferInstruments) && Objects.equals((Object)this.verificationStatus, (Object)accountHolderCapability.verificationStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allowed, this.allowedLevel, this.allowedSettings, this.enabled, this.problems, this.requested, this.requestedLevel, this.requestedSettings, this.transferInstruments, this.verificationStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountHolderCapability {\n");
        sb.append("    allowed: ").append(this.toIndentedString(this.allowed)).append("\n");
        sb.append("    allowedLevel: ").append(this.toIndentedString((Object)this.allowedLevel)).append("\n");
        sb.append("    allowedSettings: ").append(this.toIndentedString(this.allowedSettings)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    problems: ").append(this.toIndentedString(this.problems)).append("\n");
        sb.append("    requested: ").append(this.toIndentedString(this.requested)).append("\n");
        sb.append("    requestedLevel: ").append(this.toIndentedString((Object)this.requestedLevel)).append("\n");
        sb.append("    requestedSettings: ").append(this.toIndentedString(this.requestedSettings)).append("\n");
        sb.append("    transferInstruments: ").append(this.toIndentedString(this.transferInstruments)).append("\n");
        sb.append("    verificationStatus: ").append(this.toIndentedString((Object)this.verificationStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        AccountHolderCapability.validateJsonObject(jsonObj, false);
    }

    public static void validateJsonObject(JsonObject jsonObj, boolean strictValidation) throws IOException {
        JsonArray jsonArraytransferInstruments;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AccountHolderCapability is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (strictValidation) {
            Set entries = jsonObj.entrySet();
            for (Map.Entry entry : entries) {
                if (openapiFields.contains(entry.getKey())) continue;
                throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AccountHolderCapability` properties.", entry.getKey()));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_ALLOWED_LEVEL) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ALLOWED_LEVEL).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `allowedLevel` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALLOWED_LEVEL).toString()));
            }
            AllowedLevelEnum.fromValue(jsonObj.get(SERIALIZED_NAME_ALLOWED_LEVEL).getAsString());
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ALLOWED_SETTINGS) != null) {
            CapabilitySettings.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ALLOWED_SETTINGS));
        }
        if (jsonObj.get(SERIALIZED_NAME_PROBLEMS) != null && !jsonObj.get(SERIALIZED_NAME_PROBLEMS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `problems` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROBLEMS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REQUESTED_LEVEL) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_REQUESTED_LEVEL).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `requestedLevel` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUESTED_LEVEL).toString()));
            }
            RequestedLevelEnum.fromValue(jsonObj.get(SERIALIZED_NAME_REQUESTED_LEVEL).getAsString());
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_REQUESTED_SETTINGS) != null) {
            CapabilitySettings.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_REQUESTED_SETTINGS));
        }
        if ((jsonArraytransferInstruments = jsonObj.getAsJsonArray(SERIALIZED_NAME_TRANSFER_INSTRUMENTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TRANSFER_INSTRUMENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `transferInstruments` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANSFER_INSTRUMENTS).toString()));
            }
            for (int i = 0; i < jsonArraytransferInstruments.size(); ++i) {
                AccountSupportingEntityCapability.validateJsonObject(jsonArraytransferInstruments.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_VERIFICATION_STATUS) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VERIFICATION_STATUS).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `verificationStatus` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERIFICATION_STATUS).toString()));
            }
            VerificationStatusEnum.fromValue(jsonObj.get(SERIALIZED_NAME_VERIFICATION_STATUS).getAsString());
        }
    }

    public static AccountHolderCapability fromJson(String jsonString) throws IOException {
        return (AccountHolderCapability)JSON.getGson().fromJson(jsonString, AccountHolderCapability.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ALLOWED);
        openapiFields.add(SERIALIZED_NAME_ALLOWED_LEVEL);
        openapiFields.add(SERIALIZED_NAME_ALLOWED_SETTINGS);
        openapiFields.add(SERIALIZED_NAME_ENABLED);
        openapiFields.add(SERIALIZED_NAME_PROBLEMS);
        openapiFields.add(SERIALIZED_NAME_REQUESTED);
        openapiFields.add(SERIALIZED_NAME_REQUESTED_LEVEL);
        openapiFields.add(SERIALIZED_NAME_REQUESTED_SETTINGS);
        openapiFields.add(SERIALIZED_NAME_TRANSFER_INSTRUMENTS);
        openapiFields.add(SERIALIZED_NAME_VERIFICATION_STATUS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AccountHolderCapability.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AccountHolderCapability.class));
            return new TypeAdapter<AccountHolderCapability>(){

                public void write(JsonWriter out, AccountHolderCapability value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AccountHolderCapability read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AccountHolderCapability.validateJsonObject(jsonObj);
                    return (AccountHolderCapability)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VerificationStatusEnum {
        INVALID("invalid"),
        PENDING("pending"),
        REJECTED("rejected"),
        VALID("valid");

        private String value;

        private VerificationStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VerificationStatusEnum fromValue(String value) {
            for (VerificationStatusEnum b : VerificationStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<VerificationStatusEnum> {
            public void write(JsonWriter jsonWriter, VerificationStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public VerificationStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VerificationStatusEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RequestedLevelEnum {
        HIGH("high"),
        LOW("low"),
        MEDIUM("medium"),
        NOTAPPLICABLE("notApplicable");

        private String value;

        private RequestedLevelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RequestedLevelEnum fromValue(String value) {
            for (RequestedLevelEnum b : RequestedLevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<RequestedLevelEnum> {
            public void write(JsonWriter jsonWriter, RequestedLevelEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RequestedLevelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RequestedLevelEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AllowedLevelEnum {
        HIGH("high"),
        LOW("low"),
        MEDIUM("medium"),
        NOTAPPLICABLE("notApplicable");

        private String value;

        private AllowedLevelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AllowedLevelEnum fromValue(String value) {
            for (AllowedLevelEnum b : AllowedLevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<AllowedLevelEnum> {
            public void write(JsonWriter jsonWriter, AllowedLevelEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AllowedLevelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AllowedLevelEnum.fromValue(value);
            }
        }
    }
}

