/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.management.GenerateClientKeyResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class ClientKeyMerchantLevelApi
extends Service {
    private final String baseURL = this.createBaseURL("https://management-test.adyen.com/v1");

    public ClientKeyMerchantLevelApi(Client client) {
        super(client);
    }

    public GenerateClientKeyResponse generateNewClientKey(String merchantId, String apiCredentialId) throws ApiException, IOException {
        return this.generateNewClientKey(merchantId, apiCredentialId, null);
    }

    public GenerateClientKeyResponse generateNewClientKey(String merchantId, String apiCredentialId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (apiCredentialId == null) {
            throw new IllegalArgumentException("Please provide the apiCredentialId path parameter");
        }
        pathParams.put("apiCredentialId", apiCredentialId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/apiCredentials/{apiCredentialId}/generateClientKey", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return GenerateClientKeyResponse.fromJson(jsonResult);
    }
}

