/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.management.ListStoresResponse;
import com.adyen.model.management.Store;
import com.adyen.model.management.StoreCreationRequest;
import com.adyen.model.management.StoreCreationWithMerchantCodeRequest;
import com.adyen.model.management.UpdateStoreRequest;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class AccountStoreLevelApi
extends Service {
    private final String baseURL = this.createBaseURL("https://management-test.adyen.com/v1");

    public AccountStoreLevelApi(Client client) {
        super(client);
    }

    public ListStoresResponse listStoresByMerchantId(String merchantId) throws ApiException, IOException {
        return this.listStoresByMerchantId(merchantId, null, null, null, null);
    }

    public ListStoresResponse listStoresByMerchantId(String merchantId, Integer pageNumber, Integer pageSize, String reference, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (pageNumber != null) {
            queryParams.put("pageNumber", pageNumber.toString());
        }
        if (pageSize != null) {
            queryParams.put("pageSize", pageSize.toString());
        }
        if (reference != null) {
            queryParams.put("reference", reference);
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/stores", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return ListStoresResponse.fromJson(jsonResult);
    }

    public Store getStore(String merchantId, String storeId) throws ApiException, IOException {
        return this.getStore(merchantId, storeId, null);
    }

    public Store getStore(String merchantId, String storeId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (storeId == null) {
            throw new IllegalArgumentException("Please provide the storeId path parameter");
        }
        pathParams.put("storeId", storeId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/stores/{storeId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return Store.fromJson(jsonResult);
    }

    public ListStoresResponse listStores() throws ApiException, IOException {
        return this.listStores(null, null, null, null, null);
    }

    public ListStoresResponse listStores(Integer pageNumber, Integer pageSize, String reference, String merchantId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (pageNumber != null) {
            queryParams.put("pageNumber", pageNumber.toString());
        }
        if (pageSize != null) {
            queryParams.put("pageSize", pageSize.toString());
        }
        if (reference != null) {
            queryParams.put("reference", reference);
        }
        if (merchantId != null) {
            queryParams.put("merchantId", merchantId);
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/stores", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, null, queryParams);
        return ListStoresResponse.fromJson(jsonResult);
    }

    public Store getStoreById(String storeId) throws ApiException, IOException {
        return this.getStoreById(storeId, null);
    }

    public Store getStoreById(String storeId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (storeId == null) {
            throw new IllegalArgumentException("Please provide the storeId path parameter");
        }
        pathParams.put("storeId", storeId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/stores/{storeId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return Store.fromJson(jsonResult);
    }

    public Store updateStore(String merchantId, String storeId, UpdateStoreRequest updateStoreRequest) throws ApiException, IOException {
        return this.updateStore(merchantId, storeId, updateStoreRequest, null);
    }

    public Store updateStore(String merchantId, String storeId, UpdateStoreRequest updateStoreRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (storeId == null) {
            throw new IllegalArgumentException("Please provide the storeId path parameter");
        }
        pathParams.put("storeId", storeId);
        String requestBody = updateStoreRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/stores/{storeId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return Store.fromJson(jsonResult);
    }

    public Store updateStoreById(String storeId, UpdateStoreRequest updateStoreRequest) throws ApiException, IOException {
        return this.updateStoreById(storeId, updateStoreRequest, null);
    }

    public Store updateStoreById(String storeId, UpdateStoreRequest updateStoreRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (storeId == null) {
            throw new IllegalArgumentException("Please provide the storeId path parameter");
        }
        pathParams.put("storeId", storeId);
        String requestBody = updateStoreRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/stores/{storeId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return Store.fromJson(jsonResult);
    }

    public Store createStoreByMerchantId(String merchantId, StoreCreationRequest storeCreationRequest) throws ApiException, IOException {
        return this.createStoreByMerchantId(merchantId, storeCreationRequest, null);
    }

    public Store createStoreByMerchantId(String merchantId, StoreCreationRequest storeCreationRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        String requestBody = storeCreationRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/stores", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return Store.fromJson(jsonResult);
    }

    public Store createStore(StoreCreationWithMerchantCodeRequest storeCreationWithMerchantCodeRequest) throws ApiException, IOException {
        return this.createStore(storeCreationWithMerchantCodeRequest, null);
    }

    public Store createStore(StoreCreationWithMerchantCodeRequest storeCreationWithMerchantCodeRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = storeCreationWithMerchantCodeRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/stores", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return Store.fromJson(jsonResult);
    }
}

