/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.checkout;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.checkout.ListStoredPaymentMethodsResponse;
import com.adyen.model.checkout.StoredPaymentMethodResource;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class RecurringApi
extends Service {
    private final String baseURL = this.createBaseURL("https://checkout-test.adyen.com/v70");

    public RecurringApi(Client client) {
        super(client);
    }

    public StoredPaymentMethodResource deleteTokenForStoredPaymentDetails(String recurringId, String shopperReference, String merchantAccount) throws ApiException, IOException {
        return this.deleteTokenForStoredPaymentDetails(recurringId, shopperReference, merchantAccount, null);
    }

    public StoredPaymentMethodResource deleteTokenForStoredPaymentDetails(String recurringId, String shopperReference, String merchantAccount, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (recurringId == null) {
            throw new IllegalArgumentException("Please provide the recurringId path parameter");
        }
        pathParams.put("recurringId", recurringId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (shopperReference != null) {
            queryParams.put("shopperReference", shopperReference);
        }
        if (merchantAccount != null) {
            queryParams.put("merchantAccount", merchantAccount);
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/storedPaymentMethods/{recurringId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.DELETE, pathParams, queryParams);
        return StoredPaymentMethodResource.fromJson(jsonResult);
    }

    public ListStoredPaymentMethodsResponse getTokensForStoredPaymentDetails() throws ApiException, IOException {
        return this.getTokensForStoredPaymentDetails(null, null, null);
    }

    public ListStoredPaymentMethodsResponse getTokensForStoredPaymentDetails(String shopperReference, String merchantAccount, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (shopperReference != null) {
            queryParams.put("shopperReference", shopperReference);
        }
        if (merchantAccount != null) {
            queryParams.put("merchantAccount", merchantAccount);
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/storedPaymentMethods", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, null, queryParams);
        return ListStoredPaymentMethodsResponse.fromJson(jsonResult);
    }
}

