/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transferwebhooks;

import com.adyen.model.transferwebhooks.Amount;
import com.adyen.model.transferwebhooks.AmountAdjustment;
import com.adyen.model.transferwebhooks.BalanceMutation;
import com.adyen.model.transferwebhooks.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransferEvent {
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Amount amount;
    public static final String SERIALIZED_NAME_AMOUNT_ADJUSTMENTS = "amountAdjustments";
    @SerializedName(value="amountAdjustments")
    private List<AmountAdjustment> amountAdjustments = null;
    public static final String SERIALIZED_NAME_BOOKING_DATE = "bookingDate";
    @SerializedName(value="bookingDate")
    private OffsetDateTime bookingDate;
    public static final String SERIALIZED_NAME_ESTIMATED_ARRIVAL_TIME = "estimatedArrivalTime";
    @SerializedName(value="estimatedArrivalTime")
    private OffsetDateTime estimatedArrivalTime;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_MUTATIONS = "mutations";
    @SerializedName(value="mutations")
    private List<BalanceMutation> mutations = null;
    public static final String SERIALIZED_NAME_ORIGINAL_AMOUNT = "originalAmount";
    @SerializedName(value="originalAmount")
    private Amount originalAmount;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private ReasonEnum reason;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_TRANSACTION_ID = "transactionId";
    @SerializedName(value="transactionId")
    private String transactionId;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_UPDATE_DATE = "updateDate";
    @SerializedName(value="updateDate")
    private OffsetDateTime updateDate;
    public static final String SERIALIZED_NAME_VALUE_DATE = "valueDate";
    @SerializedName(value="valueDate")
    private OffsetDateTime valueDate;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public TransferEvent amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public TransferEvent amountAdjustments(List<AmountAdjustment> amountAdjustments) {
        this.amountAdjustments = amountAdjustments;
        return this;
    }

    public TransferEvent addAmountAdjustmentsItem(AmountAdjustment amountAdjustmentsItem) {
        if (this.amountAdjustments == null) {
            this.amountAdjustments = new ArrayList<AmountAdjustment>();
        }
        this.amountAdjustments.add(amountAdjustmentsItem);
        return this;
    }

    @ApiModelProperty(value="The amount adjustments in this transfer.")
    public List<AmountAdjustment> getAmountAdjustments() {
        return this.amountAdjustments;
    }

    public void setAmountAdjustments(List<AmountAdjustment> amountAdjustments) {
        this.amountAdjustments = amountAdjustments;
    }

    public TransferEvent bookingDate(OffsetDateTime bookingDate) {
        this.bookingDate = bookingDate;
        return this;
    }

    @ApiModelProperty(value="The date when the transfer request was sent.")
    public OffsetDateTime getBookingDate() {
        return this.bookingDate;
    }

    public void setBookingDate(OffsetDateTime bookingDate) {
        this.bookingDate = bookingDate;
    }

    public TransferEvent estimatedArrivalTime(OffsetDateTime estimatedArrivalTime) {
        this.estimatedArrivalTime = estimatedArrivalTime;
        return this;
    }

    @ApiModelProperty(value="The estimated time the beneficiary should have access to the funds.")
    public OffsetDateTime getEstimatedArrivalTime() {
        return this.estimatedArrivalTime;
    }

    public void setEstimatedArrivalTime(OffsetDateTime estimatedArrivalTime) {
        this.estimatedArrivalTime = estimatedArrivalTime;
    }

    public TransferEvent id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the transfer event.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TransferEvent mutations(List<BalanceMutation> mutations) {
        this.mutations = mutations;
        return this;
    }

    public TransferEvent addMutationsItem(BalanceMutation mutationsItem) {
        if (this.mutations == null) {
            this.mutations = new ArrayList<BalanceMutation>();
        }
        this.mutations.add(mutationsItem);
        return this;
    }

    @ApiModelProperty(value="The list of the balance mutation per event.")
    public List<BalanceMutation> getMutations() {
        return this.mutations;
    }

    public void setMutations(List<BalanceMutation> mutations) {
        this.mutations = mutations;
    }

    public TransferEvent originalAmount(Amount originalAmount) {
        this.originalAmount = originalAmount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getOriginalAmount() {
        return this.originalAmount;
    }

    public void setOriginalAmount(Amount originalAmount) {
        this.originalAmount = originalAmount;
    }

    public TransferEvent reason(ReasonEnum reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="The reason for the transfer status.")
    public ReasonEnum getReason() {
        return this.reason;
    }

    public void setReason(ReasonEnum reason) {
        this.reason = reason;
    }

    public TransferEvent status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the transfer event.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public TransferEvent transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(value="The id of the transaction that is related to this accounting event. Only sent for events of type **accounting** where the balance changes.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public TransferEvent type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of the transfer event. Possible values: **accounting**, **tracking**.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public TransferEvent updateDate(OffsetDateTime updateDate) {
        this.updateDate = updateDate;
        return this;
    }

    @ApiModelProperty(value="The date when the tracking status was updated.")
    public OffsetDateTime getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(OffsetDateTime updateDate) {
        this.updateDate = updateDate;
    }

    public TransferEvent valueDate(OffsetDateTime valueDate) {
        this.valueDate = valueDate;
        return this;
    }

    @ApiModelProperty(value="A future date, when the funds are expected to be deducted from or credited to the balance account.")
    public OffsetDateTime getValueDate() {
        return this.valueDate;
    }

    public void setValueDate(OffsetDateTime valueDate) {
        this.valueDate = valueDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferEvent transferEvent = (TransferEvent)o;
        return Objects.equals(this.amount, transferEvent.amount) && Objects.equals(this.amountAdjustments, transferEvent.amountAdjustments) && Objects.equals(this.bookingDate, transferEvent.bookingDate) && Objects.equals(this.estimatedArrivalTime, transferEvent.estimatedArrivalTime) && Objects.equals(this.id, transferEvent.id) && Objects.equals(this.mutations, transferEvent.mutations) && Objects.equals(this.originalAmount, transferEvent.originalAmount) && Objects.equals((Object)this.reason, (Object)transferEvent.reason) && Objects.equals((Object)this.status, (Object)transferEvent.status) && Objects.equals(this.transactionId, transferEvent.transactionId) && Objects.equals((Object)this.type, (Object)transferEvent.type) && Objects.equals(this.updateDate, transferEvent.updateDate) && Objects.equals(this.valueDate, transferEvent.valueDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.amountAdjustments, this.bookingDate, this.estimatedArrivalTime, this.id, this.mutations, this.originalAmount, this.reason, this.status, this.transactionId, this.type, this.updateDate, this.valueDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferEvent {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    amountAdjustments: ").append(this.toIndentedString(this.amountAdjustments)).append("\n");
        sb.append("    bookingDate: ").append(this.toIndentedString(this.bookingDate)).append("\n");
        sb.append("    estimatedArrivalTime: ").append(this.toIndentedString(this.estimatedArrivalTime)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    mutations: ").append(this.toIndentedString(this.mutations)).append("\n");
        sb.append("    originalAmount: ").append(this.toIndentedString(this.originalAmount)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString((Object)this.reason)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    updateDate: ").append(this.toIndentedString(this.updateDate)).append("\n");
        sb.append("    valueDate: ").append(this.toIndentedString(this.valueDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraymutations;
        JsonArray jsonArrayamountAdjustments;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TransferEvent is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `TransferEvent` properties.", entry.getKey()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT));
        }
        if ((jsonArrayamountAdjustments = jsonObj.getAsJsonArray(SERIALIZED_NAME_AMOUNT_ADJUSTMENTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_AMOUNT_ADJUSTMENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `amountAdjustments` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AMOUNT_ADJUSTMENTS).toString()));
            }
            for (int i = 0; i < jsonArrayamountAdjustments.size(); ++i) {
                AmountAdjustment.validateJsonObject(jsonArrayamountAdjustments.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if ((jsonArraymutations = jsonObj.getAsJsonArray(SERIALIZED_NAME_MUTATIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_MUTATIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `mutations` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MUTATIONS).toString()));
            }
            for (int i = 0; i < jsonArraymutations.size(); ++i) {
                BalanceMutation.validateJsonObject(jsonArraymutations.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ORIGINAL_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ORIGINAL_AMOUNT));
        }
        if (jsonObj.get(SERIALIZED_NAME_REASON) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_REASON).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `reason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REASON).toString()));
            }
            ReasonEnum.fromValue(jsonObj.get(SERIALIZED_NAME_REASON).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
            }
            StatusEnum.fromValue(jsonObj.get(SERIALIZED_NAME_STATUS).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANSACTION_ID) != null && !jsonObj.get(SERIALIZED_NAME_TRANSACTION_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `transactionId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANSACTION_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static TransferEvent fromJson(String jsonString) throws IOException {
        return (TransferEvent)JSON.getGson().fromJson(jsonString, TransferEvent.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_AMOUNT_ADJUSTMENTS);
        openapiFields.add(SERIALIZED_NAME_BOOKING_DATE);
        openapiFields.add(SERIALIZED_NAME_ESTIMATED_ARRIVAL_TIME);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_MUTATIONS);
        openapiFields.add(SERIALIZED_NAME_ORIGINAL_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_REASON);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_TRANSACTION_ID);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_UPDATE_DATE);
        openapiFields.add(SERIALIZED_NAME_VALUE_DATE);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(TransferEvent.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TransferEvent.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TransferEvent.class));
            return new TypeAdapter<TransferEvent>(){

                public void write(JsonWriter out, TransferEvent value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TransferEvent read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TransferEvent.validateJsonObject(jsonObj);
                    return (TransferEvent)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        ACCOUNTING("accounting"),
        TRACKING("tracking");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        APPROVALPENDING("approvalPending"),
        ATMWITHDRAWAL("atmWithdrawal"),
        ATMWITHDRAWALREVERSALPENDING("atmWithdrawalReversalPending"),
        ATMWITHDRAWALREVERSED("atmWithdrawalReversed"),
        AUTHADJUSTMENTAUTHORISED("authAdjustmentAuthorised"),
        AUTHADJUSTMENTERROR("authAdjustmentError"),
        AUTHADJUSTMENTREFUSED("authAdjustmentRefused"),
        AUTHORISED("authorised"),
        BANKTRANSFER("bankTransfer"),
        BANKTRANSFERPENDING("bankTransferPending"),
        BOOKED("booked"),
        BOOKINGPENDING("bookingPending"),
        CANCELLED("cancelled"),
        CAPTUREPENDING("capturePending"),
        CAPTUREREVERSALPENDING("captureReversalPending"),
        CAPTUREREVERSED("captureReversed"),
        CAPTURED("captured"),
        CHARGEBACK("chargeback"),
        CHARGEBACKPENDING("chargebackPending"),
        CHARGEBACKREVERSALPENDING("chargebackReversalPending"),
        CHARGEBACKREVERSED("chargebackReversed"),
        CREDITED("credited"),
        DEPOSITCORRECTION("depositCorrection"),
        DEPOSITCORRECTIONPENDING("depositCorrectionPending"),
        DISPUTE("dispute"),
        DISPUTECLOSED("disputeClosed"),
        DISPUTEEXPIRED("disputeExpired"),
        DISPUTENEEDSREVIEW("disputeNeedsReview"),
        ERROR("error"),
        EXPIRED("expired"),
        FAILED("failed"),
        FEE("fee"),
        FEEPENDING("feePending"),
        INTERNALTRANSFER("internalTransfer"),
        INTERNALTRANSFERPENDING("internalTransferPending"),
        INVOICEDEDUCTION("invoiceDeduction"),
        INVOICEDEDUCTIONPENDING("invoiceDeductionPending"),
        MANUALCORRECTIONPENDING("manualCorrectionPending"),
        MANUALLYCORRECTED("manuallyCorrected"),
        MATCHEDSTATEMENT("matchedStatement"),
        MATCHEDSTATEMENTPENDING("matchedStatementPending"),
        MERCHANTPAYIN("merchantPayin"),
        MERCHANTPAYINPENDING("merchantPayinPending"),
        MERCHANTPAYINREVERSED("merchantPayinReversed"),
        MERCHANTPAYINREVERSEDPENDING("merchantPayinReversedPending"),
        MISCCOST("miscCost"),
        MISCCOSTPENDING("miscCostPending"),
        PAYMENTCOST("paymentCost"),
        PAYMENTCOSTPENDING("paymentCostPending"),
        RECEIVED("received"),
        REFUNDPENDING("refundPending"),
        REFUNDREVERSALPENDING("refundReversalPending"),
        REFUNDREVERSED("refundReversed"),
        REFUNDED("refunded"),
        REFUSED("refused"),
        RESERVEADJUSTMENT("reserveAdjustment"),
        RESERVEADJUSTMENTPENDING("reserveAdjustmentPending"),
        RETURNED("returned"),
        SECONDCHARGEBACK("secondChargeback"),
        SECONDCHARGEBACKPENDING("secondChargebackPending"),
        UNDEFINED("undefined");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ReasonEnum {
        AMOUNTLIMITEXCEEDED("amountLimitExceeded"),
        APPROVED("approved"),
        COUNTERPARTYACCOUNTBLOCKED("counterpartyAccountBlocked"),
        COUNTERPARTYACCOUNTCLOSED("counterpartyAccountClosed"),
        COUNTERPARTYACCOUNTNOTFOUND("counterpartyAccountNotFound"),
        COUNTERPARTYADDRESSREQUIRED("counterpartyAddressRequired"),
        COUNTERPARTYBANKTIMEDOUT("counterpartyBankTimedOut"),
        COUNTERPARTYBANKUNAVAILABLE("counterpartyBankUnavailable"),
        ERROR("error"),
        NOTENOUGHBALANCE("notEnoughBalance"),
        REFUSEDBYCOUNTERPARTYBANK("refusedByCounterpartyBank"),
        ROUTENOTFOUND("routeNotFound"),
        UNKNOWN("unknown");

        private String value;

        private ReasonEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ReasonEnum fromValue(String value) {
            for (ReasonEnum b : ReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ReasonEnum> {
            public void write(JsonWriter jsonWriter, ReasonEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ReasonEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ReasonEnum.fromValue(value);
            }
        }
    }
}

