/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.Amount;
import com.adyen.model.transfers.CounterpartyV3;
import com.adyen.model.transfers.JSON;
import com.adyen.model.transfers.PaymentInstrument;
import com.adyen.model.transfers.ResourceReference;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Transfer {
    public static final String SERIALIZED_NAME_ACCOUNT_HOLDER = "accountHolder";
    @SerializedName(value="accountHolder")
    private ResourceReference accountHolder;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Amount amount;
    public static final String SERIALIZED_NAME_BALANCE_ACCOUNT = "balanceAccount";
    @SerializedName(value="balanceAccount")
    private ResourceReference balanceAccount;
    public static final String SERIALIZED_NAME_BALANCE_ACCOUNT_ID = "balanceAccountId";
    @Deprecated
    @SerializedName(value="balanceAccountId")
    private String balanceAccountId;
    public static final String SERIALIZED_NAME_CATEGORY = "category";
    @SerializedName(value="category")
    private CategoryEnum category;
    public static final String SERIALIZED_NAME_COUNTERPARTY = "counterparty";
    @SerializedName(value="counterparty")
    private CounterpartyV3 counterparty;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_DIRECTION = "direction";
    @SerializedName(value="direction")
    private DirectionEnum direction;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_PAYMENT_INSTRUMENT = "paymentInstrument";
    @SerializedName(value="paymentInstrument")
    private PaymentInstrument paymentInstrument;
    public static final String SERIALIZED_NAME_PAYMENT_INSTRUMENT_ID = "paymentInstrumentId";
    @Deprecated
    @SerializedName(value="paymentInstrumentId")
    private String paymentInstrumentId;
    public static final String SERIALIZED_NAME_PRIORITY = "priority";
    @SerializedName(value="priority")
    private PriorityEnum priority;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private ReasonEnum reason;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_REFERENCE_FOR_BENEFICIARY = "referenceForBeneficiary";
    @SerializedName(value="referenceForBeneficiary")
    private String referenceForBeneficiary;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public Transfer accountHolder(ResourceReference accountHolder) {
        this.accountHolder = accountHolder;
        return this;
    }

    @ApiModelProperty(value="")
    public ResourceReference getAccountHolder() {
        return this.accountHolder;
    }

    public void setAccountHolder(ResourceReference accountHolder) {
        this.accountHolder = accountHolder;
    }

    public Transfer amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public Transfer balanceAccount(ResourceReference balanceAccount) {
        this.balanceAccount = balanceAccount;
        return this;
    }

    @ApiModelProperty(value="")
    public ResourceReference getBalanceAccount() {
        return this.balanceAccount;
    }

    public void setBalanceAccount(ResourceReference balanceAccount) {
        this.balanceAccount = balanceAccount;
    }

    @Deprecated
    public Transfer balanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The unique identifier of the source [balance account](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id).")
    public String getBalanceAccountId() {
        return this.balanceAccountId;
    }

    @Deprecated
    public void setBalanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
    }

    public Transfer category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of transfer.  Possible values:   - **bank**: Transfer to a [transfer instrument](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/transferInstruments__resParam_id) or a bank account.  - **internal**: Transfer to another [balance account](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id) within your platform.  - **issuedCard**: Transfer initiated by a Adyen-issued card.  - **platformPayment**: Fund movements related to payments that are acquired for your users.")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public Transfer counterparty(CounterpartyV3 counterparty) {
        this.counterparty = counterparty;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public CounterpartyV3 getCounterparty() {
        return this.counterparty;
    }

    public void setCounterparty(CounterpartyV3 counterparty) {
        this.counterparty = counterparty;
    }

    public Transfer description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Your description for the transfer. It is used by most banks as the transfer description. We recommend sending a maximum of 140 characters, otherwise the description may be truncated.  Supported characters: **[a-z] [A-Z] [0-9] / - ?** **: ( ) . , ' + Space**  Supported characters for **regular** and **fast** transfers to a US counterparty: **[a-z] [A-Z] [0-9] & $ % # @** **~ = + - _ ' \" ! ?**")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Transfer direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(value="The direction of the transfer.  Possible values: **incoming**, **outgoing**.")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public Transfer id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the resource.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Transfer paymentInstrument(PaymentInstrument paymentInstrument) {
        this.paymentInstrument = paymentInstrument;
        return this;
    }

    @ApiModelProperty(value="")
    public PaymentInstrument getPaymentInstrument() {
        return this.paymentInstrument;
    }

    public void setPaymentInstrument(PaymentInstrument paymentInstrument) {
        this.paymentInstrument = paymentInstrument;
    }

    @Deprecated
    public Transfer paymentInstrumentId(String paymentInstrumentId) {
        this.paymentInstrumentId = paymentInstrumentId;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The unique identifier of the [payment instrument](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id) used in the transfer.")
    public String getPaymentInstrumentId() {
        return this.paymentInstrumentId;
    }

    @Deprecated
    public void setPaymentInstrumentId(String paymentInstrumentId) {
        this.paymentInstrumentId = paymentInstrumentId;
    }

    public Transfer priority(PriorityEnum priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(value="The priority for the bank transfer. This sets the speed at which the transfer is sent and the fees that you have to pay. Required for transfers with `category` **bank**.  Possible values:  * **regular**: For normal, low-value transactions.  * **fast**: Faster way to transfer funds but has higher fees. Recommended for high-priority, low-value transactions.  * **wire**: Fastest way to transfer funds but has the highest fees. Recommended for high-priority, high-value transactions.  * **instant**: Instant way to transfer funds in [SEPA countries](https://www.ecb.europa.eu/paym/integration/retail/sepa/html/index.en.html).  * **crossBorder**: High-value transfer to a recipient in a different country.  * **internal**: Transfer to an Adyen-issued business bank account (by bank account number/IBAN).")
    public PriorityEnum getPriority() {
        return this.priority;
    }

    public void setPriority(PriorityEnum priority) {
        this.priority = priority;
    }

    public Transfer reason(ReasonEnum reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="Additional information about the status of the transfer.")
    public ReasonEnum getReason() {
        return this.reason;
    }

    public void setReason(ReasonEnum reason) {
        this.reason = reason;
    }

    public Transfer reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the transfer, used internally within your platform. If you don't provide this in the request, Adyen generates a unique reference.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Transfer referenceForBeneficiary(String referenceForBeneficiary) {
        this.referenceForBeneficiary = referenceForBeneficiary;
        return this;
    }

    @ApiModelProperty(value=" A reference that is sent to the recipient. This reference is also sent in all webhooks related to the transfer, so you can use it to track statuses for both the source and recipient of funds.   Supported characters: **a-z**, **A-Z**, **0-9**. The maximum length depends on the `category`.  - **internal**: 80 characters  - **bank**: 35 characters when transferring to an IBAN, 15 characters for others.")
    public String getReferenceForBeneficiary() {
        return this.referenceForBeneficiary;
    }

    public void setReferenceForBeneficiary(String referenceForBeneficiary) {
        this.referenceForBeneficiary = referenceForBeneficiary;
    }

    public Transfer status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The result of the transfer.   For example, **authorised**, **refused**, or **error**.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transfer transfer = (Transfer)o;
        return Objects.equals(this.accountHolder, transfer.accountHolder) && Objects.equals(this.amount, transfer.amount) && Objects.equals(this.balanceAccount, transfer.balanceAccount) && Objects.equals(this.balanceAccountId, transfer.balanceAccountId) && Objects.equals((Object)this.category, (Object)transfer.category) && Objects.equals(this.counterparty, transfer.counterparty) && Objects.equals(this.description, transfer.description) && Objects.equals((Object)this.direction, (Object)transfer.direction) && Objects.equals(this.id, transfer.id) && Objects.equals(this.paymentInstrument, transfer.paymentInstrument) && Objects.equals(this.paymentInstrumentId, transfer.paymentInstrumentId) && Objects.equals((Object)this.priority, (Object)transfer.priority) && Objects.equals((Object)this.reason, (Object)transfer.reason) && Objects.equals(this.reference, transfer.reference) && Objects.equals(this.referenceForBeneficiary, transfer.referenceForBeneficiary) && Objects.equals((Object)this.status, (Object)transfer.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountHolder, this.amount, this.balanceAccount, this.balanceAccountId, this.category, this.counterparty, this.description, this.direction, this.id, this.paymentInstrument, this.paymentInstrumentId, this.priority, this.reason, this.reference, this.referenceForBeneficiary, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Transfer {\n");
        sb.append("    accountHolder: ").append(this.toIndentedString(this.accountHolder)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    balanceAccount: ").append(this.toIndentedString(this.balanceAccount)).append("\n");
        sb.append("    balanceAccountId: ").append(this.toIndentedString(this.balanceAccountId)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    counterparty: ").append(this.toIndentedString(this.counterparty)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    paymentInstrument: ").append(this.toIndentedString(this.paymentInstrument)).append("\n");
        sb.append("    paymentInstrumentId: ").append(this.toIndentedString(this.paymentInstrumentId)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString((Object)this.priority)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString((Object)this.reason)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    referenceForBeneficiary: ").append(this.toIndentedString(this.referenceForBeneficiary)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Transfer is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `Transfer` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCOUNT_HOLDER) != null) {
            ResourceReference.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCOUNT_HOLDER));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BALANCE_ACCOUNT) != null) {
            ResourceReference.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BALANCE_ACCOUNT));
        }
        if (jsonObj.get(SERIALIZED_NAME_BALANCE_ACCOUNT_ID) != null && !jsonObj.get(SERIALIZED_NAME_BALANCE_ACCOUNT_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `balanceAccountId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BALANCE_ACCOUNT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CATEGORY) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CATEGORY).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `category` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CATEGORY).toString()));
            }
            CategoryEnum.fromValue(jsonObj.get(SERIALIZED_NAME_CATEGORY).getAsString());
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_COUNTERPARTY) != null) {
            CounterpartyV3.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_COUNTERPARTY));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DIRECTION) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DIRECTION).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `direction` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DIRECTION).toString()));
            }
            DirectionEnum.fromValue(jsonObj.get(SERIALIZED_NAME_DIRECTION).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PAYMENT_INSTRUMENT) != null) {
            PaymentInstrument.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PAYMENT_INSTRUMENT));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAYMENT_INSTRUMENT_ID) != null && !jsonObj.get(SERIALIZED_NAME_PAYMENT_INSTRUMENT_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `paymentInstrumentId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAYMENT_INSTRUMENT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRIORITY) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PRIORITY).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `priority` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRIORITY).toString()));
            }
            PriorityEnum.fromValue(jsonObj.get(SERIALIZED_NAME_PRIORITY).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_REASON) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_REASON).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `reason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REASON).toString()));
            }
            ReasonEnum.fromValue(jsonObj.get(SERIALIZED_NAME_REASON).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE_FOR_BENEFICIARY) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE_FOR_BENEFICIARY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `referenceForBeneficiary` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE_FOR_BENEFICIARY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
            }
            StatusEnum.fromValue(jsonObj.get(SERIALIZED_NAME_STATUS).getAsString());
        }
    }

    public static Transfer fromJson(String jsonString) throws IOException {
        return (Transfer)JSON.getGson().fromJson(jsonString, Transfer.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_HOLDER);
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_BALANCE_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_BALANCE_ACCOUNT_ID);
        openapiFields.add(SERIALIZED_NAME_CATEGORY);
        openapiFields.add(SERIALIZED_NAME_COUNTERPARTY);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_DIRECTION);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_PAYMENT_INSTRUMENT);
        openapiFields.add(SERIALIZED_NAME_PAYMENT_INSTRUMENT_ID);
        openapiFields.add(SERIALIZED_NAME_PRIORITY);
        openapiFields.add(SERIALIZED_NAME_REASON);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_REFERENCE_FOR_BENEFICIARY);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_AMOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_CATEGORY);
        openapiRequiredFields.add(SERIALIZED_NAME_COUNTERPARTY);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
        log = Logger.getLogger(Transfer.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Transfer.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Transfer.class));
            return new TypeAdapter<Transfer>(){

                public void write(JsonWriter out, Transfer value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Transfer read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Transfer.validateJsonObject(jsonObj);
                    return (Transfer)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        APPROVALPENDING("approvalPending"),
        ATMWITHDRAWAL("atmWithdrawal"),
        ATMWITHDRAWALREVERSALPENDING("atmWithdrawalReversalPending"),
        ATMWITHDRAWALREVERSED("atmWithdrawalReversed"),
        AUTHADJUSTMENTAUTHORISED("authAdjustmentAuthorised"),
        AUTHADJUSTMENTERROR("authAdjustmentError"),
        AUTHADJUSTMENTREFUSED("authAdjustmentRefused"),
        AUTHORISED("authorised"),
        BANKTRANSFER("bankTransfer"),
        BANKTRANSFERPENDING("bankTransferPending"),
        BOOKED("booked"),
        BOOKINGPENDING("bookingPending"),
        CANCELLED("cancelled"),
        CAPTUREPENDING("capturePending"),
        CAPTUREREVERSALPENDING("captureReversalPending"),
        CAPTUREREVERSED("captureReversed"),
        CAPTURED("captured"),
        CHARGEBACK("chargeback"),
        CHARGEBACKPENDING("chargebackPending"),
        CHARGEBACKREVERSALPENDING("chargebackReversalPending"),
        CHARGEBACKREVERSED("chargebackReversed"),
        CREDITED("credited"),
        DEPOSITCORRECTION("depositCorrection"),
        DEPOSITCORRECTIONPENDING("depositCorrectionPending"),
        DISPUTE("dispute"),
        DISPUTECLOSED("disputeClosed"),
        DISPUTEEXPIRED("disputeExpired"),
        DISPUTENEEDSREVIEW("disputeNeedsReview"),
        ERROR("error"),
        EXPIRED("expired"),
        FAILED("failed"),
        FEE("fee"),
        FEEPENDING("feePending"),
        INTERNALTRANSFER("internalTransfer"),
        INTERNALTRANSFERPENDING("internalTransferPending"),
        INVOICEDEDUCTION("invoiceDeduction"),
        INVOICEDEDUCTIONPENDING("invoiceDeductionPending"),
        MANUALCORRECTIONPENDING("manualCorrectionPending"),
        MANUALLYCORRECTED("manuallyCorrected"),
        MATCHEDSTATEMENT("matchedStatement"),
        MATCHEDSTATEMENTPENDING("matchedStatementPending"),
        MERCHANTPAYIN("merchantPayin"),
        MERCHANTPAYINPENDING("merchantPayinPending"),
        MERCHANTPAYINREVERSED("merchantPayinReversed"),
        MERCHANTPAYINREVERSEDPENDING("merchantPayinReversedPending"),
        MISCCOST("miscCost"),
        MISCCOSTPENDING("miscCostPending"),
        PAYMENTCOST("paymentCost"),
        PAYMENTCOSTPENDING("paymentCostPending"),
        RECEIVED("received"),
        REFUNDPENDING("refundPending"),
        REFUNDREVERSALPENDING("refundReversalPending"),
        REFUNDREVERSED("refundReversed"),
        REFUNDED("refunded"),
        REFUSED("refused"),
        RESERVEADJUSTMENT("reserveAdjustment"),
        RESERVEADJUSTMENTPENDING("reserveAdjustmentPending"),
        RETURNED("returned"),
        SECONDCHARGEBACK("secondChargeback"),
        SECONDCHARGEBACKPENDING("secondChargebackPending"),
        UNDEFINED("undefined");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ReasonEnum {
        AMOUNTLIMITEXCEEDED("amountLimitExceeded"),
        APPROVED("approved"),
        COUNTERPARTYACCOUNTBLOCKED("counterpartyAccountBlocked"),
        COUNTERPARTYACCOUNTCLOSED("counterpartyAccountClosed"),
        COUNTERPARTYACCOUNTNOTFOUND("counterpartyAccountNotFound"),
        COUNTERPARTYADDRESSREQUIRED("counterpartyAddressRequired"),
        COUNTERPARTYBANKTIMEDOUT("counterpartyBankTimedOut"),
        COUNTERPARTYBANKUNAVAILABLE("counterpartyBankUnavailable"),
        ERROR("error"),
        NOTENOUGHBALANCE("notEnoughBalance"),
        REFUSEDBYCOUNTERPARTYBANK("refusedByCounterpartyBank"),
        ROUTENOTFOUND("routeNotFound"),
        UNKNOWN("unknown");

        private String value;

        private ReasonEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ReasonEnum fromValue(String value) {
            for (ReasonEnum b : ReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ReasonEnum> {
            public void write(JsonWriter jsonWriter, ReasonEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ReasonEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ReasonEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PriorityEnum {
        CROSSBORDER("crossBorder"),
        DIRECTDEBIT("directDebit"),
        FAST("fast"),
        INSTANT("instant"),
        INTERNAL("internal"),
        REGULAR("regular"),
        WIRE("wire");

        private String value;

        private PriorityEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PriorityEnum fromValue(String value) {
            for (PriorityEnum b : PriorityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PriorityEnum> {
            public void write(JsonWriter jsonWriter, PriorityEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PriorityEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PriorityEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DirectionEnum {
        INCOMING("incoming"),
        OUTGOING("outgoing");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DirectionEnum fromValue(String value) {
            for (DirectionEnum b : DirectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DirectionEnum> {
            public void write(JsonWriter jsonWriter, DirectionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DirectionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DirectionEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CategoryEnum {
        BANK("bank"),
        INTERNAL("internal"),
        ISSUEDCARD("issuedCard"),
        PLATFORMPAYMENT("platformPayment");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<CategoryEnum> {
            public void write(JsonWriter jsonWriter, CategoryEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CategoryEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CategoryEnum.fromValue(value);
            }
        }
    }
}

