/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payout;

import com.adyen.model.payout.Amount;
import com.adyen.model.payout.FraudResult;
import com.adyen.model.payout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PayoutResponse {
    public static final String SERIALIZED_NAME_ADDITIONAL_DATA = "additionalData";
    @SerializedName(value="additionalData")
    private Map<String, String> additionalData = null;
    public static final String SERIALIZED_NAME_AUTH_CODE = "authCode";
    @SerializedName(value="authCode")
    private String authCode;
    public static final String SERIALIZED_NAME_DCC_AMOUNT = "dccAmount";
    @SerializedName(value="dccAmount")
    private Amount dccAmount;
    public static final String SERIALIZED_NAME_DCC_SIGNATURE = "dccSignature";
    @SerializedName(value="dccSignature")
    private String dccSignature;
    public static final String SERIALIZED_NAME_FRAUD_RESULT = "fraudResult";
    @SerializedName(value="fraudResult")
    private FraudResult fraudResult;
    public static final String SERIALIZED_NAME_ISSUER_URL = "issuerUrl";
    @SerializedName(value="issuerUrl")
    private String issuerUrl;
    public static final String SERIALIZED_NAME_MD = "md";
    @SerializedName(value="md")
    private String md;
    public static final String SERIALIZED_NAME_PA_REQUEST = "paRequest";
    @SerializedName(value="paRequest")
    private String paRequest;
    public static final String SERIALIZED_NAME_PSP_REFERENCE = "pspReference";
    @SerializedName(value="pspReference")
    private String pspReference;
    public static final String SERIALIZED_NAME_REFUSAL_REASON = "refusalReason";
    @SerializedName(value="refusalReason")
    private String refusalReason;
    public static final String SERIALIZED_NAME_RESULT_CODE = "resultCode";
    @SerializedName(value="resultCode")
    private ResultCodeEnum resultCode;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public PayoutResponse additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public PayoutResponse putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @ApiModelProperty(value="Contains additional information about the payment. Some data fields are included only if you select them first: Go to **Customer Area** > **Developers** > **Additional data**.")
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public PayoutResponse authCode(String authCode) {
        this.authCode = authCode;
        return this;
    }

    @ApiModelProperty(value="Authorisation code: * When the payment is authorised successfully, this field holds the authorisation code for the payment. * When the payment is not authorised, this field is empty.")
    public String getAuthCode() {
        return this.authCode;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public PayoutResponse dccAmount(Amount dccAmount) {
        this.dccAmount = dccAmount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getDccAmount() {
        return this.dccAmount;
    }

    public void setDccAmount(Amount dccAmount) {
        this.dccAmount = dccAmount;
    }

    public PayoutResponse dccSignature(String dccSignature) {
        this.dccSignature = dccSignature;
        return this;
    }

    @ApiModelProperty(value="Cryptographic signature used to verify `dccQuote`. > This value only applies if you have implemented Dynamic Currency Conversion. For more information, [contact Support](https://www.adyen.help/hc/en-us/requests/new).")
    public String getDccSignature() {
        return this.dccSignature;
    }

    public void setDccSignature(String dccSignature) {
        this.dccSignature = dccSignature;
    }

    public PayoutResponse fraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
        return this;
    }

    @ApiModelProperty(value="")
    public FraudResult getFraudResult() {
        return this.fraudResult;
    }

    public void setFraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
    }

    public PayoutResponse issuerUrl(String issuerUrl) {
        this.issuerUrl = issuerUrl;
        return this;
    }

    @ApiModelProperty(value="The URL to direct the shopper to. > In case of SecurePlus, do not redirect a shopper to this URL.")
    public String getIssuerUrl() {
        return this.issuerUrl;
    }

    public void setIssuerUrl(String issuerUrl) {
        this.issuerUrl = issuerUrl;
    }

    public PayoutResponse md(String md) {
        this.md = md;
        return this;
    }

    @ApiModelProperty(value="The payment session.")
    public String getMd() {
        return this.md;
    }

    public void setMd(String md) {
        this.md = md;
    }

    public PayoutResponse paRequest(String paRequest) {
        this.paRequest = paRequest;
        return this;
    }

    @ApiModelProperty(value="The 3D request data for the issuer.  If the value is **CUPSecurePlus-CollectSMSVerificationCode**, collect an SMS code from the shopper and pass it in the `/authorise3D` request. For more information, see [3D Secure](https://docs.adyen.com/classic-integration/3d-secure).")
    public String getPaRequest() {
        return this.paRequest;
    }

    public void setPaRequest(String paRequest) {
        this.paRequest = paRequest;
    }

    public PayoutResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @ApiModelProperty(value="Adyen's 16-character reference associated with the transaction/request. This value is globally unique; quote it when communicating with us about this request.")
    public String getPspReference() {
        return this.pspReference;
    }

    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public PayoutResponse refusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
        return this;
    }

    @ApiModelProperty(value="If the payment's authorisation is refused or an error occurs during authorisation, this field holds Adyen's mapped reason for the refusal or a description of the error. When a transaction fails, the authorisation response includes `resultCode` and `refusalReason` values.  For more information, see [Refusal reasons](https://docs.adyen.com/development-resources/refusal-reasons).")
    public String getRefusalReason() {
        return this.refusalReason;
    }

    public void setRefusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
    }

    public PayoutResponse resultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    @ApiModelProperty(value="The result of the payment. For more information, see [Result codes](https://docs.adyen.com/online-payments/payment-result-codes).  Possible values:  * **AuthenticationFinished** \u2013 The payment has been successfully authenticated with 3D Secure 2. Returned for 3D Secure 2 authentication-only transactions. * **AuthenticationNotRequired** \u2013 The transaction does not require 3D Secure authentication. Returned for [standalone authentication-only integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). * **Authorised** \u2013 The payment was successfully authorised. This state serves as an indicator to proceed with the delivery of goods and services. This is a final state. * **Cancelled** \u2013 Indicates the payment has been cancelled (either by the shopper or the merchant) before processing was completed. This is a final state. * **ChallengeShopper** \u2013 The issuer requires further shopper interaction before the payment can be authenticated. Returned for 3D Secure 2 transactions. * **Error** \u2013 There was an error when the payment was being processed. The reason is given in the `refusalReason` field. This is a final state. * **IdentifyShopper** \u2013 The issuer requires the shopper's device fingerprint before the payment can be authenticated. Returned for 3D Secure 2 transactions. * **Pending** \u2013 Indicates that it is not possible to obtain the final status of the payment. This can happen if the systems providing final status information for the payment are unavailable, or if the shopper needs to take further action to complete the payment. * **PresentToShopper** \u2013 Indicates that the response contains additional information that you need to present to a shopper, so that they can use it to complete a payment. * **Received** \u2013 Indicates the payment has successfully been received by Adyen, and will be processed. This is the initial state for all payments. * **RedirectShopper** \u2013 Indicates the shopper should be redirected to an external web page or app to complete the authorisation. * **Refused** \u2013 Indicates the payment was refused. The reason is given in the `refusalReason` field. This is a final state.")
    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayoutResponse payoutResponse = (PayoutResponse)o;
        return Objects.equals(this.additionalData, payoutResponse.additionalData) && Objects.equals(this.authCode, payoutResponse.authCode) && Objects.equals(this.dccAmount, payoutResponse.dccAmount) && Objects.equals(this.dccSignature, payoutResponse.dccSignature) && Objects.equals(this.fraudResult, payoutResponse.fraudResult) && Objects.equals(this.issuerUrl, payoutResponse.issuerUrl) && Objects.equals(this.md, payoutResponse.md) && Objects.equals(this.paRequest, payoutResponse.paRequest) && Objects.equals(this.pspReference, payoutResponse.pspReference) && Objects.equals(this.refusalReason, payoutResponse.refusalReason) && Objects.equals((Object)this.resultCode, (Object)payoutResponse.resultCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalData, this.authCode, this.dccAmount, this.dccSignature, this.fraudResult, this.issuerUrl, this.md, this.paRequest, this.pspReference, this.refusalReason, this.resultCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayoutResponse {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    authCode: ").append(this.toIndentedString(this.authCode)).append("\n");
        sb.append("    dccAmount: ").append(this.toIndentedString(this.dccAmount)).append("\n");
        sb.append("    dccSignature: ").append(this.toIndentedString(this.dccSignature)).append("\n");
        sb.append("    fraudResult: ").append(this.toIndentedString(this.fraudResult)).append("\n");
        sb.append("    issuerUrl: ").append(this.toIndentedString(this.issuerUrl)).append("\n");
        sb.append("    md: ").append(this.toIndentedString(this.md)).append("\n");
        sb.append("    paRequest: ").append(this.toIndentedString(this.paRequest)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    refusalReason: ").append(this.toIndentedString(this.refusalReason)).append("\n");
        sb.append("    resultCode: ").append(this.toIndentedString((Object)this.resultCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PayoutResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `PayoutResponse` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AUTH_CODE) != null && !jsonObj.get(SERIALIZED_NAME_AUTH_CODE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `authCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUTH_CODE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DCC_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DCC_AMOUNT));
        }
        if (jsonObj.get(SERIALIZED_NAME_DCC_SIGNATURE) != null && !jsonObj.get(SERIALIZED_NAME_DCC_SIGNATURE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `dccSignature` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DCC_SIGNATURE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_FRAUD_RESULT) != null) {
            FraudResult.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_FRAUD_RESULT));
        }
        if (jsonObj.get(SERIALIZED_NAME_ISSUER_URL) != null && !jsonObj.get(SERIALIZED_NAME_ISSUER_URL).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `issuerUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ISSUER_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MD) != null && !jsonObj.get(SERIALIZED_NAME_MD).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `md` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PA_REQUEST) != null && !jsonObj.get(SERIALIZED_NAME_PA_REQUEST).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `paRequest` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PA_REQUEST).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PSP_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_PSP_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `pspReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PSP_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFUSAL_REASON) != null && !jsonObj.get(SERIALIZED_NAME_REFUSAL_REASON).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `refusalReason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFUSAL_REASON).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESULT_CODE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RESULT_CODE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `resultCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESULT_CODE).toString()));
            }
            ResultCodeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_RESULT_CODE).getAsString());
        }
    }

    public static PayoutResponse fromJson(String jsonString) throws IOException {
        return (PayoutResponse)JSON.getGson().fromJson(jsonString, PayoutResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_DATA);
        openapiFields.add(SERIALIZED_NAME_AUTH_CODE);
        openapiFields.add(SERIALIZED_NAME_DCC_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_DCC_SIGNATURE);
        openapiFields.add(SERIALIZED_NAME_FRAUD_RESULT);
        openapiFields.add(SERIALIZED_NAME_ISSUER_URL);
        openapiFields.add(SERIALIZED_NAME_MD);
        openapiFields.add(SERIALIZED_NAME_PA_REQUEST);
        openapiFields.add(SERIALIZED_NAME_PSP_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_REFUSAL_REASON);
        openapiFields.add(SERIALIZED_NAME_RESULT_CODE);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(PayoutResponse.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PayoutResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PayoutResponse.class));
            return new TypeAdapter<PayoutResponse>(){

                public void write(JsonWriter out, PayoutResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PayoutResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PayoutResponse.validateJsonObject(jsonObj);
                    return (PayoutResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ResultCodeEnum {
        AUTHENTICATIONFINISHED("AuthenticationFinished"),
        AUTHENTICATIONNOTREQUIRED("AuthenticationNotRequired"),
        AUTHORISED("Authorised"),
        CANCELLED("Cancelled"),
        CHALLENGESHOPPER("ChallengeShopper"),
        ERROR("Error"),
        IDENTIFYSHOPPER("IdentifyShopper"),
        PENDING("Pending"),
        PRESENTTOSHOPPER("PresentToShopper"),
        RECEIVED("Received"),
        REDIRECTSHOPPER("RedirectShopper"),
        REFUSED("Refused"),
        SUCCESS("Success");

        private String value;

        private ResultCodeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ResultCodeEnum fromValue(String value) {
            for (ResultCodeEnum b : ResultCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ResultCodeEnum> {
            public void write(JsonWriter jsonWriter, ResultCodeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ResultCodeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ResultCodeEnum.fromValue(value);
            }
        }
    }
}

