/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MerchantDevice {
    public static final String SERIALIZED_NAME_OS = "os";
    @SerializedName(value="os")
    private String os;
    public static final String SERIALIZED_NAME_OS_VERSION = "osVersion";
    @SerializedName(value="osVersion")
    private String osVersion;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public MerchantDevice os(String os) {
        this.os = os;
        return this;
    }

    @ApiModelProperty(value="Operating system running on the merchant device.")
    public String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public MerchantDevice osVersion(String osVersion) {
        this.osVersion = osVersion;
        return this;
    }

    @ApiModelProperty(value="Version of the operating system on the merchant device.")
    public String getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public MerchantDevice reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Merchant device reference.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MerchantDevice merchantDevice = (MerchantDevice)o;
        return Objects.equals(this.os, merchantDevice.os) && Objects.equals(this.osVersion, merchantDevice.osVersion) && Objects.equals(this.reference, merchantDevice.reference);
    }

    public int hashCode() {
        return Objects.hash(this.os, this.osVersion, this.reference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MerchantDevice {\n");
        sb.append("    os: ").append(this.toIndentedString(this.os)).append("\n");
        sb.append("    osVersion: ").append(this.toIndentedString(this.osVersion)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in MerchantDevice is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `MerchantDevice` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OS) != null && !jsonObj.get(SERIALIZED_NAME_OS).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `os` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OS_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_OS_VERSION).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `osVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OS_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
    }

    public static MerchantDevice fromJson(String jsonString) throws IOException {
        return (MerchantDevice)JSON.getGson().fromJson(jsonString, MerchantDevice.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_OS);
        openapiFields.add(SERIALIZED_NAME_OS_VERSION);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(MerchantDevice.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!MerchantDevice.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(MerchantDevice.class));
            return new TypeAdapter<MerchantDevice>(){

                public void write(JsonWriter out, MerchantDevice value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public MerchantDevice read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    MerchantDevice.validateJsonObject(jsonObj);
                    return (MerchantDevice)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

