/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.Profile;
import com.adyen.model.management.Settings;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WifiProfiles {
    public static final String SERIALIZED_NAME_PROFILES = "profiles";
    @SerializedName(value="profiles")
    private List<Profile> profiles = null;
    public static final String SERIALIZED_NAME_SETTINGS = "settings";
    @SerializedName(value="settings")
    private Settings settings;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public WifiProfiles profiles(List<Profile> profiles) {
        this.profiles = profiles;
        return this;
    }

    public WifiProfiles addProfilesItem(Profile profilesItem) {
        if (this.profiles == null) {
            this.profiles = new ArrayList<Profile>();
        }
        this.profiles.add(profilesItem);
        return this;
    }

    @ApiModelProperty(value="List of remote Wi-Fi profiles.")
    public List<Profile> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(List<Profile> profiles) {
        this.profiles = profiles;
    }

    public WifiProfiles settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    @ApiModelProperty(value="")
    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WifiProfiles wifiProfiles = (WifiProfiles)o;
        return Objects.equals(this.profiles, wifiProfiles.profiles) && Objects.equals(this.settings, wifiProfiles.settings);
    }

    public int hashCode() {
        return Objects.hash(this.profiles, this.settings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WifiProfiles {\n");
        sb.append("    profiles: ").append(this.toIndentedString(this.profiles)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in WifiProfiles is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `WifiProfiles` properties.", entry.getKey()));
        }
        JsonArray jsonArrayprofiles = jsonObj.getAsJsonArray(SERIALIZED_NAME_PROFILES);
        if (jsonArrayprofiles != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PROFILES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `profiles` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROFILES).toString()));
            }
            for (int i = 0; i < jsonArrayprofiles.size(); ++i) {
                Profile.validateJsonObject(jsonArrayprofiles.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SETTINGS) != null) {
            Settings.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SETTINGS));
        }
    }

    public static WifiProfiles fromJson(String jsonString) throws IOException {
        return (WifiProfiles)JSON.getGson().fromJson(jsonString, WifiProfiles.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PROFILES);
        openapiFields.add(SERIALIZED_NAME_SETTINGS);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(WifiProfiles.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!WifiProfiles.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(WifiProfiles.class));
            return new TypeAdapter<WifiProfiles>(){

                public void write(JsonWriter out, WifiProfiles value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public WifiProfiles read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    WifiProfiles.validateJsonObject(jsonObj);
                    return (WifiProfiles)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

