/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TermsOfServiceAcceptanceInfo {
    public static final String SERIALIZED_NAME_ACCEPTED_BY = "acceptedBy";
    @SerializedName(value="acceptedBy")
    private String acceptedBy;
    public static final String SERIALIZED_NAME_ACCEPTED_FOR = "acceptedFor";
    @SerializedName(value="acceptedFor")
    private String acceptedFor;
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public TermsOfServiceAcceptanceInfo acceptedBy(String acceptedBy) {
        this.acceptedBy = acceptedBy;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the user that accepted the Terms of Service.")
    public String getAcceptedBy() {
        return this.acceptedBy;
    }

    public void setAcceptedBy(String acceptedBy) {
        this.acceptedBy = acceptedBy;
    }

    public TermsOfServiceAcceptanceInfo acceptedFor(String acceptedFor) {
        this.acceptedFor = acceptedFor;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the legal entity for which the Terms of Service are accepted.")
    public String getAcceptedFor() {
        return this.acceptedFor;
    }

    public void setAcceptedFor(String acceptedFor) {
        this.acceptedFor = acceptedFor;
    }

    public TermsOfServiceAcceptanceInfo createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="The date when the Terms of Service were accepted.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public TermsOfServiceAcceptanceInfo id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="An Adyen-generated reference for the accepted Terms of Service.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TermsOfServiceAcceptanceInfo type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of Terms of Service.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermsOfServiceAcceptanceInfo termsOfServiceAcceptanceInfo = (TermsOfServiceAcceptanceInfo)o;
        return Objects.equals(this.acceptedBy, termsOfServiceAcceptanceInfo.acceptedBy) && Objects.equals(this.acceptedFor, termsOfServiceAcceptanceInfo.acceptedFor) && Objects.equals(this.createdAt, termsOfServiceAcceptanceInfo.createdAt) && Objects.equals(this.id, termsOfServiceAcceptanceInfo.id) && Objects.equals((Object)this.type, (Object)termsOfServiceAcceptanceInfo.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.acceptedBy, this.acceptedFor, this.createdAt, this.id, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TermsOfServiceAcceptanceInfo {\n");
        sb.append("    acceptedBy: ").append(this.toIndentedString(this.acceptedBy)).append("\n");
        sb.append("    acceptedFor: ").append(this.toIndentedString(this.acceptedFor)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TermsOfServiceAcceptanceInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `TermsOfServiceAcceptanceInfo` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCEPTED_BY) != null && !jsonObj.get(SERIALIZED_NAME_ACCEPTED_BY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `acceptedBy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCEPTED_BY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCEPTED_FOR) != null && !jsonObj.get(SERIALIZED_NAME_ACCEPTED_FOR).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `acceptedFor` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCEPTED_FOR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static TermsOfServiceAcceptanceInfo fromJson(String jsonString) throws IOException {
        return (TermsOfServiceAcceptanceInfo)JSON.getGson().fromJson(jsonString, TermsOfServiceAcceptanceInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCEPTED_BY);
        openapiFields.add(SERIALIZED_NAME_ACCEPTED_FOR);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(TermsOfServiceAcceptanceInfo.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TermsOfServiceAcceptanceInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TermsOfServiceAcceptanceInfo.class));
            return new TypeAdapter<TermsOfServiceAcceptanceInfo>(){

                public void write(JsonWriter out, TermsOfServiceAcceptanceInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TermsOfServiceAcceptanceInfo read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TermsOfServiceAcceptanceInfo.validateJsonObject(jsonObj);
                    return (TermsOfServiceAcceptanceInfo)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        ADYENACCOUNT("adyenAccount"),
        ADYENCAPITAL("adyenCapital"),
        ADYENCARD("adyenCard"),
        ADYENFORPLATFORMSADVANCED("adyenForPlatformsAdvanced"),
        ADYENFORPLATFORMSMANAGE("adyenForPlatformsManage"),
        ADYENFRANCHISEE("adyenFranchisee"),
        ADYENISSUING("adyenIssuing");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

