/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.adyen.model.legalentitymanagement.SourceOfFunds;
import com.adyen.model.legalentitymanagement.WebData;
import com.adyen.model.legalentitymanagement.WebDataExemption;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BusinessLineInfoUpdate {
    public static final String SERIALIZED_NAME_CAPABILITY = "capability";
    @Deprecated
    @SerializedName(value="capability")
    private CapabilityEnum capability;
    public static final String SERIALIZED_NAME_INDUSTRY_CODE = "industryCode";
    @SerializedName(value="industryCode")
    private String industryCode;
    public static final String SERIALIZED_NAME_LEGAL_ENTITY_ID = "legalEntityId";
    @SerializedName(value="legalEntityId")
    private String legalEntityId;
    public static final String SERIALIZED_NAME_SALES_CHANNELS = "salesChannels";
    @SerializedName(value="salesChannels")
    private List<String> salesChannels = null;
    public static final String SERIALIZED_NAME_SERVICE = "service";
    @SerializedName(value="service")
    private ServiceEnum service;
    public static final String SERIALIZED_NAME_SOURCE_OF_FUNDS = "sourceOfFunds";
    @SerializedName(value="sourceOfFunds")
    private SourceOfFunds sourceOfFunds;
    public static final String SERIALIZED_NAME_WEB_DATA = "webData";
    @SerializedName(value="webData")
    private List<WebData> webData = null;
    public static final String SERIALIZED_NAME_WEB_DATA_EXEMPTION = "webDataExemption";
    @SerializedName(value="webDataExemption")
    private WebDataExemption webDataExemption;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    @Deprecated
    public BusinessLineInfoUpdate capability(CapabilityEnum capability) {
        this.capability = capability;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The capability for which you are creating the business line. For example, **receivePayments**.")
    public CapabilityEnum getCapability() {
        return this.capability;
    }

    @Deprecated
    public void setCapability(CapabilityEnum capability) {
        this.capability = capability;
    }

    public BusinessLineInfoUpdate industryCode(String industryCode) {
        this.industryCode = industryCode;
        return this;
    }

    @ApiModelProperty(value="A code that represents the industry of your legal entity. For example, **4431A** for computer software stores.")
    public String getIndustryCode() {
        return this.industryCode;
    }

    public void setIndustryCode(String industryCode) {
        this.industryCode = industryCode;
    }

    public BusinessLineInfoUpdate legalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
        return this;
    }

    @ApiModelProperty(value="Unique identifier of the [legal entity](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/legalEntities__resParam_id) that owns the business line.")
    public String getLegalEntityId() {
        return this.legalEntityId;
    }

    public void setLegalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
    }

    public BusinessLineInfoUpdate salesChannels(List<String> salesChannels) {
        this.salesChannels = salesChannels;
        return this;
    }

    public BusinessLineInfoUpdate addSalesChannelsItem(String salesChannelsItem) {
        if (this.salesChannels == null) {
            this.salesChannels = new ArrayList<String>();
        }
        this.salesChannels.add(salesChannelsItem);
        return this;
    }

    @ApiModelProperty(value="A list of channels where goods or services are sold.  Possible values: **pos**, **posMoto**, **eCommerce**, **ecomMoto**, **payByLink**.  Required only in combination with the `service` **paymentProcessing**.")
    public List<String> getSalesChannels() {
        return this.salesChannels;
    }

    public void setSalesChannels(List<String> salesChannels) {
        this.salesChannels = salesChannels;
    }

    public BusinessLineInfoUpdate service(ServiceEnum service) {
        this.service = service;
        return this;
    }

    @ApiModelProperty(required=true, value="The service for which you are creating the business line.  Possible values: **paymentProcessing**, **issuing**, **banking**")
    public ServiceEnum getService() {
        return this.service;
    }

    public void setService(ServiceEnum service) {
        this.service = service;
    }

    public BusinessLineInfoUpdate sourceOfFunds(SourceOfFunds sourceOfFunds) {
        this.sourceOfFunds = sourceOfFunds;
        return this;
    }

    @ApiModelProperty(value="")
    public SourceOfFunds getSourceOfFunds() {
        return this.sourceOfFunds;
    }

    public void setSourceOfFunds(SourceOfFunds sourceOfFunds) {
        this.sourceOfFunds = sourceOfFunds;
    }

    public BusinessLineInfoUpdate webData(List<WebData> webData) {
        this.webData = webData;
        return this;
    }

    public BusinessLineInfoUpdate addWebDataItem(WebData webDataItem) {
        if (this.webData == null) {
            this.webData = new ArrayList<WebData>();
        }
        this.webData.add(webDataItem);
        return this;
    }

    @ApiModelProperty(value="List of website URLs where your user's goods or services are sold. When this is required for a service but your user does not have an online presence, provide the reason in the `webDataExemption` object.")
    public List<WebData> getWebData() {
        return this.webData;
    }

    public void setWebData(List<WebData> webData) {
        this.webData = webData;
    }

    public BusinessLineInfoUpdate webDataExemption(WebDataExemption webDataExemption) {
        this.webDataExemption = webDataExemption;
        return this;
    }

    @ApiModelProperty(value="")
    public WebDataExemption getWebDataExemption() {
        return this.webDataExemption;
    }

    public void setWebDataExemption(WebDataExemption webDataExemption) {
        this.webDataExemption = webDataExemption;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BusinessLineInfoUpdate businessLineInfoUpdate = (BusinessLineInfoUpdate)o;
        return Objects.equals((Object)this.capability, (Object)businessLineInfoUpdate.capability) && Objects.equals(this.industryCode, businessLineInfoUpdate.industryCode) && Objects.equals(this.legalEntityId, businessLineInfoUpdate.legalEntityId) && Objects.equals(this.salesChannels, businessLineInfoUpdate.salesChannels) && Objects.equals((Object)this.service, (Object)businessLineInfoUpdate.service) && Objects.equals(this.sourceOfFunds, businessLineInfoUpdate.sourceOfFunds) && Objects.equals(this.webData, businessLineInfoUpdate.webData) && Objects.equals(this.webDataExemption, businessLineInfoUpdate.webDataExemption);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.capability, this.industryCode, this.legalEntityId, this.salesChannels, this.service, this.sourceOfFunds, this.webData, this.webDataExemption});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BusinessLineInfoUpdate {\n");
        sb.append("    capability: ").append(this.toIndentedString((Object)this.capability)).append("\n");
        sb.append("    industryCode: ").append(this.toIndentedString(this.industryCode)).append("\n");
        sb.append("    legalEntityId: ").append(this.toIndentedString(this.legalEntityId)).append("\n");
        sb.append("    salesChannels: ").append(this.toIndentedString(this.salesChannels)).append("\n");
        sb.append("    service: ").append(this.toIndentedString((Object)this.service)).append("\n");
        sb.append("    sourceOfFunds: ").append(this.toIndentedString(this.sourceOfFunds)).append("\n");
        sb.append("    webData: ").append(this.toIndentedString(this.webData)).append("\n");
        sb.append("    webDataExemption: ").append(this.toIndentedString(this.webDataExemption)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraywebData;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in BusinessLineInfoUpdate is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `BusinessLineInfoUpdate` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CAPABILITY) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CAPABILITY).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `capability` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CAPABILITY).toString()));
            }
            CapabilityEnum.fromValue(jsonObj.get(SERIALIZED_NAME_CAPABILITY).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_INDUSTRY_CODE) != null && !jsonObj.get(SERIALIZED_NAME_INDUSTRY_CODE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `industryCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INDUSTRY_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LEGAL_ENTITY_ID) != null && !jsonObj.get(SERIALIZED_NAME_LEGAL_ENTITY_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `legalEntityId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LEGAL_ENTITY_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SALES_CHANNELS) != null && !jsonObj.get(SERIALIZED_NAME_SALES_CHANNELS).isJsonArray()) {
            log.log(Level.WARNING, String.format("Expected the field `salesChannels` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SALES_CHANNELS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SERVICE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SERVICE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `service` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SERVICE).toString()));
            }
            ServiceEnum.fromValue(jsonObj.get(SERIALIZED_NAME_SERVICE).getAsString());
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SOURCE_OF_FUNDS) != null) {
            SourceOfFunds.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SOURCE_OF_FUNDS));
        }
        if ((jsonArraywebData = jsonObj.getAsJsonArray(SERIALIZED_NAME_WEB_DATA)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_WEB_DATA).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `webData` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WEB_DATA).toString()));
            }
            for (int i = 0; i < jsonArraywebData.size(); ++i) {
                WebData.validateJsonObject(jsonArraywebData.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_WEB_DATA_EXEMPTION) != null) {
            WebDataExemption.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_WEB_DATA_EXEMPTION));
        }
    }

    public static BusinessLineInfoUpdate fromJson(String jsonString) throws IOException {
        return (BusinessLineInfoUpdate)JSON.getGson().fromJson(jsonString, BusinessLineInfoUpdate.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CAPABILITY);
        openapiFields.add(SERIALIZED_NAME_INDUSTRY_CODE);
        openapiFields.add(SERIALIZED_NAME_LEGAL_ENTITY_ID);
        openapiFields.add(SERIALIZED_NAME_SALES_CHANNELS);
        openapiFields.add(SERIALIZED_NAME_SERVICE);
        openapiFields.add(SERIALIZED_NAME_SOURCE_OF_FUNDS);
        openapiFields.add(SERIALIZED_NAME_WEB_DATA);
        openapiFields.add(SERIALIZED_NAME_WEB_DATA_EXEMPTION);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_SERVICE);
        log = Logger.getLogger(BusinessLineInfoUpdate.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!BusinessLineInfoUpdate.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(BusinessLineInfoUpdate.class));
            return new TypeAdapter<BusinessLineInfoUpdate>(){

                public void write(JsonWriter out, BusinessLineInfoUpdate value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public BusinessLineInfoUpdate read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    BusinessLineInfoUpdate.validateJsonObject(jsonObj);
                    return (BusinessLineInfoUpdate)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ServiceEnum {
        PAYMENTPROCESSING("paymentProcessing"),
        ISSUING("issuing"),
        BANKING("banking");

        private String value;

        private ServiceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ServiceEnum fromValue(String value) {
            for (ServiceEnum b : ServiceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ServiceEnum> {
            public void write(JsonWriter jsonWriter, ServiceEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ServiceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ServiceEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CapabilityEnum {
        RECEIVEPAYMENTS("receivePayments"),
        RECEIVEFROMPLATFORMPAYMENTS("receiveFromPlatformPayments"),
        ISSUEBANKACCOUNT("issueBankAccount");

        private String value;

        private CapabilityEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CapabilityEnum fromValue(String value) {
            for (CapabilityEnum b : CapabilityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<CapabilityEnum> {
            public void write(JsonWriter jsonWriter, CapabilityEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CapabilityEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CapabilityEnum.fromValue(value);
            }
        }
    }
}

