/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.Amount;
import com.adyen.model.configurationwebhooks.JSON;
import com.adyen.model.configurationwebhooks.SweepConfigurationSchedule;
import com.adyen.model.configurationwebhooks.SweepCounterparty;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SweepConfigurationV2 {
    public static final String SERIALIZED_NAME_COUNTERPARTY = "counterparty";
    @SerializedName(value="counterparty")
    private SweepCounterparty counterparty;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private ReasonEnum reason;
    public static final String SERIALIZED_NAME_SCHEDULE = "schedule";
    @SerializedName(value="schedule")
    private SweepConfigurationSchedule schedule;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_SWEEP_AMOUNT = "sweepAmount";
    @SerializedName(value="sweepAmount")
    private Amount sweepAmount;
    public static final String SERIALIZED_NAME_TARGET_AMOUNT = "targetAmount";
    @SerializedName(value="targetAmount")
    private Amount targetAmount;
    public static final String SERIALIZED_NAME_TRIGGER_AMOUNT = "triggerAmount";
    @SerializedName(value="triggerAmount")
    private Amount triggerAmount;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type = TypeEnum.PUSH;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public SweepConfigurationV2 counterparty(SweepCounterparty counterparty) {
        this.counterparty = counterparty;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public SweepCounterparty getCounterparty() {
        return this.counterparty;
    }

    public void setCounterparty(SweepCounterparty counterparty) {
        this.counterparty = counterparty;
    }

    public SweepConfigurationV2 currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(required=true, value="The three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes) in uppercase. For example, **EUR**.  The sweep currency must match any of the [balances currencies](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/get/balanceAccounts/{id}__resParam_balances).")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public SweepConfigurationV2 description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The message that will be used in the sweep transfer's description body with a maximum length of 140 characters.  If the message is longer after replacing placeholders, the message will be cut off at 140 characters.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SweepConfigurationV2 id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the sweep.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public SweepConfigurationV2 reason(ReasonEnum reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="The reason for disabling the sweep.")
    public ReasonEnum getReason() {
        return this.reason;
    }

    public void setReason(ReasonEnum reason) {
        this.reason = reason;
    }

    public SweepConfigurationV2 schedule(SweepConfigurationSchedule schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public SweepConfigurationSchedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(SweepConfigurationSchedule schedule) {
        this.schedule = schedule;
    }

    public SweepConfigurationV2 status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the sweep. If not provided, by default, this is set to **active**.  Possible values:    * **active**:  the sweep is enabled and funds will be pulled in or pushed out based on the defined configuration.    * **inactive**: the sweep is disabled and cannot be triggered.   ")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public SweepConfigurationV2 sweepAmount(Amount sweepAmount) {
        this.sweepAmount = sweepAmount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getSweepAmount() {
        return this.sweepAmount;
    }

    public void setSweepAmount(Amount sweepAmount) {
        this.sweepAmount = sweepAmount;
    }

    public SweepConfigurationV2 targetAmount(Amount targetAmount) {
        this.targetAmount = targetAmount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getTargetAmount() {
        return this.targetAmount;
    }

    public void setTargetAmount(Amount targetAmount) {
        this.targetAmount = targetAmount;
    }

    public SweepConfigurationV2 triggerAmount(Amount triggerAmount) {
        this.triggerAmount = triggerAmount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getTriggerAmount() {
        return this.triggerAmount;
    }

    public void setTriggerAmount(Amount triggerAmount) {
        this.triggerAmount = triggerAmount;
    }

    public SweepConfigurationV2 type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The direction of sweep, whether pushing out or pulling in funds to the balance account. If not provided, by default, this is set to **push**.  Possible values:   * **push**: _push out funds_ to a destination balance account or transfer instrument.   * **pull**: _pull in funds_ from a source merchant account, transfer instrument, or balance account.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SweepConfigurationV2 sweepConfigurationV2 = (SweepConfigurationV2)o;
        return Objects.equals(this.counterparty, sweepConfigurationV2.counterparty) && Objects.equals(this.currency, sweepConfigurationV2.currency) && Objects.equals(this.description, sweepConfigurationV2.description) && Objects.equals(this.id, sweepConfigurationV2.id) && Objects.equals((Object)this.reason, (Object)sweepConfigurationV2.reason) && Objects.equals(this.schedule, sweepConfigurationV2.schedule) && Objects.equals((Object)this.status, (Object)sweepConfigurationV2.status) && Objects.equals(this.sweepAmount, sweepConfigurationV2.sweepAmount) && Objects.equals(this.targetAmount, sweepConfigurationV2.targetAmount) && Objects.equals(this.triggerAmount, sweepConfigurationV2.triggerAmount) && Objects.equals((Object)this.type, (Object)sweepConfigurationV2.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.counterparty, this.currency, this.description, this.id, this.reason, this.schedule, this.status, this.sweepAmount, this.targetAmount, this.triggerAmount, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SweepConfigurationV2 {\n");
        sb.append("    counterparty: ").append(this.toIndentedString(this.counterparty)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString((Object)this.reason)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    sweepAmount: ").append(this.toIndentedString(this.sweepAmount)).append("\n");
        sb.append("    targetAmount: ").append(this.toIndentedString(this.targetAmount)).append("\n");
        sb.append("    triggerAmount: ").append(this.toIndentedString(this.triggerAmount)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in SweepConfigurationV2 is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `SweepConfigurationV2` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_COUNTERPARTY) != null) {
            SweepCounterparty.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_COUNTERPARTY));
        }
        if (jsonObj.get(SERIALIZED_NAME_CURRENCY) != null && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REASON) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_REASON).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `reason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REASON).toString()));
            }
            ReasonEnum.fromValue(jsonObj.get(SERIALIZED_NAME_REASON).getAsString());
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SCHEDULE) != null) {
            SweepConfigurationSchedule.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SCHEDULE));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
            }
            StatusEnum.fromValue(jsonObj.get(SERIALIZED_NAME_STATUS).getAsString());
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SWEEP_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SWEEP_AMOUNT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TARGET_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TARGET_AMOUNT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TRIGGER_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TRIGGER_AMOUNT));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static SweepConfigurationV2 fromJson(String jsonString) throws IOException {
        return (SweepConfigurationV2)JSON.getGson().fromJson(jsonString, SweepConfigurationV2.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_COUNTERPARTY);
        openapiFields.add(SERIALIZED_NAME_CURRENCY);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_REASON);
        openapiFields.add(SERIALIZED_NAME_SCHEDULE);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_SWEEP_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_TARGET_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_TRIGGER_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_COUNTERPARTY);
        openapiRequiredFields.add(SERIALIZED_NAME_CURRENCY);
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_SCHEDULE);
        log = Logger.getLogger(SweepConfigurationV2.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!SweepConfigurationV2.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SweepConfigurationV2.class));
            return new TypeAdapter<SweepConfigurationV2>(){

                public void write(JsonWriter out, SweepConfigurationV2 value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public SweepConfigurationV2 read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    SweepConfigurationV2.validateJsonObject(jsonObj);
                    return (SweepConfigurationV2)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        PULL("pull"),
        PUSH("push");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        ACTIVE("active"),
        INACTIVE("inactive");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ReasonEnum {
        AMOUNTLIMITEXCEEDED("amountLimitExceeded"),
        APPROVED("approved"),
        COUNTERPARTYACCOUNTBLOCKED("counterpartyAccountBlocked"),
        COUNTERPARTYACCOUNTCLOSED("counterpartyAccountClosed"),
        COUNTERPARTYACCOUNTNOTFOUND("counterpartyAccountNotFound"),
        COUNTERPARTYADDRESSREQUIRED("counterpartyAddressRequired"),
        COUNTERPARTYBANKTIMEDOUT("counterpartyBankTimedOut"),
        COUNTERPARTYBANKUNAVAILABLE("counterpartyBankUnavailable"),
        ERROR("error"),
        NOTENOUGHBALANCE("notEnoughBalance"),
        REFUSEDBYCOUNTERPARTYBANK("refusedByCounterpartyBank"),
        ROUTENOTFOUND("routeNotFound"),
        UNKNOWN("unknown");

        private String value;

        private ReasonEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ReasonEnum fromValue(String value) {
            for (ReasonEnum b : ReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ReasonEnum> {
            public void write(JsonWriter jsonWriter, ReasonEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ReasonEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ReasonEnum.fromValue(value);
            }
        }
    }
}

