/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.Balance;
import com.adyen.model.configurationwebhooks.JSON;
import com.adyen.model.configurationwebhooks.PaymentInstrumentReference;
import com.adyen.model.configurationwebhooks.SweepConfiguration;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BalanceAccount {
    public static final String SERIALIZED_NAME_ACCOUNT_HOLDER_ID = "accountHolderId";
    @SerializedName(value="accountHolderId")
    private String accountHolderId;
    public static final String SERIALIZED_NAME_BALANCES = "balances";
    @SerializedName(value="balances")
    private List<Balance> balances = null;
    public static final String SERIALIZED_NAME_DEFAULT_CURRENCY_CODE = "defaultCurrencyCode";
    @SerializedName(value="defaultCurrencyCode")
    private String defaultCurrencyCode;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_PAYMENT_INSTRUMENTS = "paymentInstruments";
    @SerializedName(value="paymentInstruments")
    private List<PaymentInstrumentReference> paymentInstruments = null;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_SWEEP_CONFIGURATIONS = "sweepConfigurations";
    @SerializedName(value="sweepConfigurations")
    private Map<String, SweepConfiguration> sweepConfigurations = null;
    public static final String SERIALIZED_NAME_TIME_ZONE = "timeZone";
    @SerializedName(value="timeZone")
    private String timeZone;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public BalanceAccount accountHolderId(String accountHolderId) {
        this.accountHolderId = accountHolderId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the [account holder](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/accountHolders__resParam_id) associated with the balance account.")
    public String getAccountHolderId() {
        return this.accountHolderId;
    }

    public void setAccountHolderId(String accountHolderId) {
        this.accountHolderId = accountHolderId;
    }

    public BalanceAccount balances(List<Balance> balances) {
        this.balances = balances;
        return this;
    }

    public BalanceAccount addBalancesItem(Balance balancesItem) {
        if (this.balances == null) {
            this.balances = new ArrayList<Balance>();
        }
        this.balances.add(balancesItem);
        return this;
    }

    @ApiModelProperty(value="List of balances with the amount and currency.")
    public List<Balance> getBalances() {
        return this.balances;
    }

    public void setBalances(List<Balance> balances) {
        this.balances = balances;
    }

    public BalanceAccount defaultCurrencyCode(String defaultCurrencyCode) {
        this.defaultCurrencyCode = defaultCurrencyCode;
        return this;
    }

    @ApiModelProperty(value="The default three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes) of the balance account. The default value is **EUR**.")
    public String getDefaultCurrencyCode() {
        return this.defaultCurrencyCode;
    }

    public void setDefaultCurrencyCode(String defaultCurrencyCode) {
        this.defaultCurrencyCode = defaultCurrencyCode;
    }

    public BalanceAccount description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="A human-readable description of the balance account, maximum 300 characters. You can use this parameter to distinguish between multiple balance accounts under an account holder.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BalanceAccount id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the balance account.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BalanceAccount paymentInstruments(List<PaymentInstrumentReference> paymentInstruments) {
        this.paymentInstruments = paymentInstruments;
        return this;
    }

    public BalanceAccount addPaymentInstrumentsItem(PaymentInstrumentReference paymentInstrumentsItem) {
        if (this.paymentInstruments == null) {
            this.paymentInstruments = new ArrayList<PaymentInstrumentReference>();
        }
        this.paymentInstruments.add(paymentInstrumentsItem);
        return this;
    }

    @ApiModelProperty(value="List of [payment instruments](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/paymentInstruments) associated with the balance account.")
    public List<PaymentInstrumentReference> getPaymentInstruments() {
        return this.paymentInstruments;
    }

    public void setPaymentInstruments(List<PaymentInstrumentReference> paymentInstruments) {
        this.paymentInstruments = paymentInstruments;
    }

    public BalanceAccount reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the balance account, maximum 150 characters.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public BalanceAccount status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the balance account, set to **Active** by default.  ")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public BalanceAccount sweepConfigurations(Map<String, SweepConfiguration> sweepConfigurations) {
        this.sweepConfigurations = sweepConfigurations;
        return this;
    }

    public BalanceAccount putSweepConfigurationsItem(String key, SweepConfiguration sweepConfigurationsItem) {
        if (this.sweepConfigurations == null) {
            this.sweepConfigurations = new HashMap<String, SweepConfiguration>();
        }
        this.sweepConfigurations.put(key, sweepConfigurationsItem);
        return this;
    }

    @ApiModelProperty(value="Contains key-value pairs that specify configurations for balance sweeps per currency code. A sweep pulls in or pushes out funds based on a defined schedule, amount, and a source (for pulling funds) or a destination (for pushing funds).  The key must be a three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes) in uppercase. For example, **EUR**. The value must be an object containing the sweep configuration.")
    public Map<String, SweepConfiguration> getSweepConfigurations() {
        return this.sweepConfigurations;
    }

    public void setSweepConfigurations(Map<String, SweepConfiguration> sweepConfigurations) {
        this.sweepConfigurations = sweepConfigurations;
    }

    public BalanceAccount timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @ApiModelProperty(value="The time zone of the balance account. For example, **Europe/Amsterdam**. Defaults to the time zone of the account holder if no time zone is set. For possible values, see the [list of time zone codes](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones).")
    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalanceAccount balanceAccount = (BalanceAccount)o;
        return Objects.equals(this.accountHolderId, balanceAccount.accountHolderId) && Objects.equals(this.balances, balanceAccount.balances) && Objects.equals(this.defaultCurrencyCode, balanceAccount.defaultCurrencyCode) && Objects.equals(this.description, balanceAccount.description) && Objects.equals(this.id, balanceAccount.id) && Objects.equals(this.paymentInstruments, balanceAccount.paymentInstruments) && Objects.equals(this.reference, balanceAccount.reference) && Objects.equals((Object)this.status, (Object)balanceAccount.status) && Objects.equals(this.sweepConfigurations, balanceAccount.sweepConfigurations) && Objects.equals(this.timeZone, balanceAccount.timeZone);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountHolderId, this.balances, this.defaultCurrencyCode, this.description, this.id, this.paymentInstruments, this.reference, this.status, this.sweepConfigurations, this.timeZone});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BalanceAccount {\n");
        sb.append("    accountHolderId: ").append(this.toIndentedString(this.accountHolderId)).append("\n");
        sb.append("    balances: ").append(this.toIndentedString(this.balances)).append("\n");
        sb.append("    defaultCurrencyCode: ").append(this.toIndentedString(this.defaultCurrencyCode)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    paymentInstruments: ").append(this.toIndentedString(this.paymentInstruments)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    sweepConfigurations: ").append(this.toIndentedString(this.sweepConfigurations)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraypaymentInstruments;
        JsonArray jsonArraybalances;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in BalanceAccount is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `BalanceAccount` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_HOLDER_ID) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_HOLDER_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `accountHolderId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_HOLDER_ID).toString()));
        }
        if ((jsonArraybalances = jsonObj.getAsJsonArray(SERIALIZED_NAME_BALANCES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_BALANCES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `balances` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BALANCES).toString()));
            }
            for (int i = 0; i < jsonArraybalances.size(); ++i) {
                Balance.validateJsonObject(jsonArraybalances.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_DEFAULT_CURRENCY_CODE) != null && !jsonObj.get(SERIALIZED_NAME_DEFAULT_CURRENCY_CODE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `defaultCurrencyCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEFAULT_CURRENCY_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if ((jsonArraypaymentInstruments = jsonObj.getAsJsonArray(SERIALIZED_NAME_PAYMENT_INSTRUMENTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PAYMENT_INSTRUMENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `paymentInstruments` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAYMENT_INSTRUMENTS).toString()));
            }
            for (int i = 0; i < jsonArraypaymentInstruments.size(); ++i) {
                PaymentInstrumentReference.validateJsonObject(jsonArraypaymentInstruments.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
            }
            StatusEnum.fromValue(jsonObj.get(SERIALIZED_NAME_STATUS).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_TIME_ZONE) != null && !jsonObj.get(SERIALIZED_NAME_TIME_ZONE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `timeZone` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TIME_ZONE).toString()));
        }
    }

    public static BalanceAccount fromJson(String jsonString) throws IOException {
        return (BalanceAccount)JSON.getGson().fromJson(jsonString, BalanceAccount.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_HOLDER_ID);
        openapiFields.add(SERIALIZED_NAME_BALANCES);
        openapiFields.add(SERIALIZED_NAME_DEFAULT_CURRENCY_CODE);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_PAYMENT_INSTRUMENTS);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_SWEEP_CONFIGURATIONS);
        openapiFields.add(SERIALIZED_NAME_TIME_ZONE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ACCOUNT_HOLDER_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        log = Logger.getLogger(BalanceAccount.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!BalanceAccount.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(BalanceAccount.class));
            return new TypeAdapter<BalanceAccount>(){

                public void write(JsonWriter out, BalanceAccount value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public BalanceAccount read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    BalanceAccount.validateJsonObject(jsonObj);
                    return (BalanceAccount)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        ACTIVE("Active"),
        CLOSED("Closed"),
        INACTIVE("Inactive"),
        SUSPENDED("Suspended");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }
}

