/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Balance {
    public static final String SERIALIZED_NAME_AVAILABLE = "available";
    @SerializedName(value="available")
    private Long available;
    public static final String SERIALIZED_NAME_BALANCE = "balance";
    @SerializedName(value="balance")
    private Long balance;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_RESERVED = "reserved";
    @SerializedName(value="reserved")
    private Long reserved;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public Balance available(Long available) {
        this.available = available;
        return this;
    }

    @ApiModelProperty(required=true, value="The remaining amount available for spending.")
    public Long getAvailable() {
        return this.available;
    }

    public void setAvailable(Long available) {
        this.available = available;
    }

    public Balance balance(Long balance) {
        this.balance = balance;
        return this;
    }

    @ApiModelProperty(required=true, value="The total amount in the balance.")
    public Long getBalance() {
        return this.balance;
    }

    public void setBalance(Long balance) {
        this.balance = balance;
    }

    public Balance currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(required=true, value="The three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes) of the balance.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Balance reserved(Long reserved) {
        this.reserved = reserved;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount reserved for payments that have been authorised, but have not been captured yet.")
    public Long getReserved() {
        return this.reserved;
    }

    public void setReserved(Long reserved) {
        this.reserved = reserved;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Balance balance = (Balance)o;
        return Objects.equals(this.available, balance.available) && Objects.equals(this.balance, balance.balance) && Objects.equals(this.currency, balance.currency) && Objects.equals(this.reserved, balance.reserved);
    }

    public int hashCode() {
        return Objects.hash(this.available, this.balance, this.currency, this.reserved);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Balance {\n");
        sb.append("    available: ").append(this.toIndentedString(this.available)).append("\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    reserved: ").append(this.toIndentedString(this.reserved)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Balance is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `Balance` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CURRENCY) != null && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCY).toString()));
        }
    }

    public static Balance fromJson(String jsonString) throws IOException {
        return (Balance)JSON.getGson().fromJson(jsonString, Balance.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AVAILABLE);
        openapiFields.add(SERIALIZED_NAME_BALANCE);
        openapiFields.add(SERIALIZED_NAME_CURRENCY);
        openapiFields.add(SERIALIZED_NAME_RESERVED);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_AVAILABLE);
        openapiRequiredFields.add(SERIALIZED_NAME_BALANCE);
        openapiRequiredFields.add(SERIALIZED_NAME_CURRENCY);
        openapiRequiredFields.add(SERIALIZED_NAME_RESERVED);
        log = Logger.getLogger(Balance.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Balance.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Balance.class));
            return new TypeAdapter<Balance>(){

                public void write(JsonWriter out, Balance value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Balance read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Balance.validateJsonObject(jsonObj);
                    return (Balance)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

