/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.JSON;
import com.adyen.model.configurationwebhooks.Phone;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Authentication {
    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(value="email")
    private String email;
    public static final String SERIALIZED_NAME_PASSWORD = "password";
    @SerializedName(value="password")
    private String password;
    public static final String SERIALIZED_NAME_PHONE = "phone";
    @SerializedName(value="phone")
    private Phone phone;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public Authentication email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="The email address where the one-time password (OTP) is sent.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Authentication password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="The password used for 3D Secure password-based authentication. The value must be between 1 to 30 characters and must only contain the following supported characters.  * Characters between **a-z**, **A-Z**, and **0-9**  * Special characters: **\u00e4\u00f6\u00fc\u00df\u00c4\u00d6\u00dc+-*_/\u00e7%()=?!~#'\",;:$&\u00e0\u00f9\u00f2\u00e2\u00f4\u00fb\u00e1\u00fa\u00f3**")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Authentication phone(Phone phone) {
        this.phone = phone;
        return this;
    }

    @ApiModelProperty(value="")
    public Phone getPhone() {
        return this.phone;
    }

    public void setPhone(Phone phone) {
        this.phone = phone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Authentication authentication = (Authentication)o;
        return Objects.equals(this.email, authentication.email) && Objects.equals(this.password, authentication.password) && Objects.equals(this.phone, authentication.phone);
    }

    public int hashCode() {
        return Objects.hash(this.email, this.password, this.phone);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Authentication {\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Authentication is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `Authentication` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_EMAIL).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `email` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EMAIL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PASSWORD) != null && !jsonObj.get(SERIALIZED_NAME_PASSWORD).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `password` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PASSWORD).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PHONE) != null) {
            Phone.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PHONE));
        }
    }

    public static Authentication fromJson(String jsonString) throws IOException {
        return (Authentication)JSON.getGson().fromJson(jsonString, Authentication.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_EMAIL);
        openapiFields.add(SERIALIZED_NAME_PASSWORD);
        openapiFields.add(SERIALIZED_NAME_PHONE);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(Authentication.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Authentication.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Authentication.class));
            return new TypeAdapter<Authentication>(){

                public void write(JsonWriter out, Authentication value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Authentication read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Authentication.validateJsonObject(jsonObj);
                    return (Authentication)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

