/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.capital;

import com.adyen.model.capital.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CapitalBalance {
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_FEE = "fee";
    @SerializedName(value="fee")
    private Long fee;
    public static final String SERIALIZED_NAME_PRINCIPAL = "principal";
    @SerializedName(value="principal")
    private Long principal;
    public static final String SERIALIZED_NAME_TOTAL = "total";
    @SerializedName(value="total")
    private Long total;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public CapitalBalance currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(required=true, value="The three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes).")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public CapitalBalance fee(Long fee) {
        this.fee = fee;
        return this;
    }

    @ApiModelProperty(required=true, value="Fee amount.")
    public Long getFee() {
        return this.fee;
    }

    public void setFee(Long fee) {
        this.fee = fee;
    }

    public CapitalBalance principal(Long principal) {
        this.principal = principal;
        return this;
    }

    @ApiModelProperty(required=true, value="Principal amount.")
    public Long getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Long principal) {
        this.principal = principal;
    }

    public CapitalBalance total(Long total) {
        this.total = total;
        return this;
    }

    @ApiModelProperty(required=true, value="Total amount. A sum of principal amount and fee amount.")
    public Long getTotal() {
        return this.total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CapitalBalance capitalBalance = (CapitalBalance)o;
        return Objects.equals(this.currency, capitalBalance.currency) && Objects.equals(this.fee, capitalBalance.fee) && Objects.equals(this.principal, capitalBalance.principal) && Objects.equals(this.total, capitalBalance.total);
    }

    public int hashCode() {
        return Objects.hash(this.currency, this.fee, this.principal, this.total);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CapitalBalance {\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    principal: ").append(this.toIndentedString(this.principal)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CapitalBalance is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `CapitalBalance` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CURRENCY) != null && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCY).toString()));
        }
    }

    public static CapitalBalance fromJson(String jsonString) throws IOException {
        return (CapitalBalance)JSON.getGson().fromJson(jsonString, CapitalBalance.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CURRENCY);
        openapiFields.add(SERIALIZED_NAME_FEE);
        openapiFields.add(SERIALIZED_NAME_PRINCIPAL);
        openapiFields.add(SERIALIZED_NAME_TOTAL);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_CURRENCY);
        openapiRequiredFields.add(SERIALIZED_NAME_FEE);
        openapiRequiredFields.add(SERIALIZED_NAME_PRINCIPAL);
        openapiRequiredFields.add(SERIALIZED_NAME_TOTAL);
        log = Logger.getLogger(CapitalBalance.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CapitalBalance.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CapitalBalance.class));
            return new TypeAdapter<CapitalBalance>(){

                public void write(JsonWriter out, CapitalBalance value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CapitalBalance read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CapitalBalance.validateJsonObject(jsonObj);
                    return (CapitalBalance)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

