/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.binlookup;

import com.adyen.model.binlookup.BinDetail;
import com.adyen.model.binlookup.DSPublicKeyDetail;
import com.adyen.model.binlookup.JSON;
import com.adyen.model.binlookup.ThreeDS2CardRangeDetail;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThreeDSAvailabilityResponse {
    public static final String SERIALIZED_NAME_BIN_DETAILS = "binDetails";
    @SerializedName(value="binDetails")
    private BinDetail binDetails;
    public static final String SERIALIZED_NAME_DS_PUBLIC_KEYS = "dsPublicKeys";
    @SerializedName(value="dsPublicKeys")
    private List<DSPublicKeyDetail> dsPublicKeys = null;
    public static final String SERIALIZED_NAME_THREE_D_S1_SUPPORTED = "threeDS1Supported";
    @SerializedName(value="threeDS1Supported")
    private Boolean threeDS1Supported;
    public static final String SERIALIZED_NAME_THREE_D_S2_CARD_RANGE_DETAILS = "threeDS2CardRangeDetails";
    @SerializedName(value="threeDS2CardRangeDetails")
    private List<ThreeDS2CardRangeDetail> threeDS2CardRangeDetails = null;
    public static final String SERIALIZED_NAME_THREE_D_S2SUPPORTED = "threeDS2supported";
    @SerializedName(value="threeDS2supported")
    private Boolean threeDS2supported;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public ThreeDSAvailabilityResponse binDetails(BinDetail binDetails) {
        this.binDetails = binDetails;
        return this;
    }

    @ApiModelProperty(value="")
    public BinDetail getBinDetails() {
        return this.binDetails;
    }

    public void setBinDetails(BinDetail binDetails) {
        this.binDetails = binDetails;
    }

    public ThreeDSAvailabilityResponse dsPublicKeys(List<DSPublicKeyDetail> dsPublicKeys) {
        this.dsPublicKeys = dsPublicKeys;
        return this;
    }

    public ThreeDSAvailabilityResponse addDsPublicKeysItem(DSPublicKeyDetail dsPublicKeysItem) {
        if (this.dsPublicKeys == null) {
            this.dsPublicKeys = new ArrayList<DSPublicKeyDetail>();
        }
        this.dsPublicKeys.add(dsPublicKeysItem);
        return this;
    }

    @ApiModelProperty(value="List of Directory Server (DS) public keys.")
    public List<DSPublicKeyDetail> getDsPublicKeys() {
        return this.dsPublicKeys;
    }

    public void setDsPublicKeys(List<DSPublicKeyDetail> dsPublicKeys) {
        this.dsPublicKeys = dsPublicKeys;
    }

    public ThreeDSAvailabilityResponse threeDS1Supported(Boolean threeDS1Supported) {
        this.threeDS1Supported = threeDS1Supported;
        return this;
    }

    @ApiModelProperty(value="Indicator if 3D Secure 1 is supported.")
    public Boolean getThreeDS1Supported() {
        return this.threeDS1Supported;
    }

    public void setThreeDS1Supported(Boolean threeDS1Supported) {
        this.threeDS1Supported = threeDS1Supported;
    }

    public ThreeDSAvailabilityResponse threeDS2CardRangeDetails(List<ThreeDS2CardRangeDetail> threeDS2CardRangeDetails) {
        this.threeDS2CardRangeDetails = threeDS2CardRangeDetails;
        return this;
    }

    public ThreeDSAvailabilityResponse addThreeDS2CardRangeDetailsItem(ThreeDS2CardRangeDetail threeDS2CardRangeDetailsItem) {
        if (this.threeDS2CardRangeDetails == null) {
            this.threeDS2CardRangeDetails = new ArrayList<ThreeDS2CardRangeDetail>();
        }
        this.threeDS2CardRangeDetails.add(threeDS2CardRangeDetailsItem);
        return this;
    }

    @ApiModelProperty(value="List of brand and card range pairs.")
    public List<ThreeDS2CardRangeDetail> getThreeDS2CardRangeDetails() {
        return this.threeDS2CardRangeDetails;
    }

    public void setThreeDS2CardRangeDetails(List<ThreeDS2CardRangeDetail> threeDS2CardRangeDetails) {
        this.threeDS2CardRangeDetails = threeDS2CardRangeDetails;
    }

    public ThreeDSAvailabilityResponse threeDS2supported(Boolean threeDS2supported) {
        this.threeDS2supported = threeDS2supported;
        return this;
    }

    @ApiModelProperty(value="Indicator if 3D Secure 2 is supported.")
    public Boolean getThreeDS2supported() {
        return this.threeDS2supported;
    }

    public void setThreeDS2supported(Boolean threeDS2supported) {
        this.threeDS2supported = threeDS2supported;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreeDSAvailabilityResponse threeDSAvailabilityResponse = (ThreeDSAvailabilityResponse)o;
        return Objects.equals(this.binDetails, threeDSAvailabilityResponse.binDetails) && Objects.equals(this.dsPublicKeys, threeDSAvailabilityResponse.dsPublicKeys) && Objects.equals(this.threeDS1Supported, threeDSAvailabilityResponse.threeDS1Supported) && Objects.equals(this.threeDS2CardRangeDetails, threeDSAvailabilityResponse.threeDS2CardRangeDetails) && Objects.equals(this.threeDS2supported, threeDSAvailabilityResponse.threeDS2supported);
    }

    public int hashCode() {
        return Objects.hash(this.binDetails, this.dsPublicKeys, this.threeDS1Supported, this.threeDS2CardRangeDetails, this.threeDS2supported);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ThreeDSAvailabilityResponse {\n");
        sb.append("    binDetails: ").append(this.toIndentedString(this.binDetails)).append("\n");
        sb.append("    dsPublicKeys: ").append(this.toIndentedString(this.dsPublicKeys)).append("\n");
        sb.append("    threeDS1Supported: ").append(this.toIndentedString(this.threeDS1Supported)).append("\n");
        sb.append("    threeDS2CardRangeDetails: ").append(this.toIndentedString(this.threeDS2CardRangeDetails)).append("\n");
        sb.append("    threeDS2supported: ").append(this.toIndentedString(this.threeDS2supported)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraythreeDS2CardRangeDetails;
        JsonArray jsonArraydsPublicKeys;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ThreeDSAvailabilityResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `ThreeDSAvailabilityResponse` properties.", entry.getKey()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BIN_DETAILS) != null) {
            BinDetail.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BIN_DETAILS));
        }
        if ((jsonArraydsPublicKeys = jsonObj.getAsJsonArray(SERIALIZED_NAME_DS_PUBLIC_KEYS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DS_PUBLIC_KEYS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `dsPublicKeys` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DS_PUBLIC_KEYS).toString()));
            }
            for (int i = 0; i < jsonArraydsPublicKeys.size(); ++i) {
                DSPublicKeyDetail.validateJsonObject(jsonArraydsPublicKeys.get(i).getAsJsonObject());
            }
        }
        if ((jsonArraythreeDS2CardRangeDetails = jsonObj.getAsJsonArray(SERIALIZED_NAME_THREE_D_S2_CARD_RANGE_DETAILS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_THREE_D_S2_CARD_RANGE_DETAILS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `threeDS2CardRangeDetails` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_THREE_D_S2_CARD_RANGE_DETAILS).toString()));
            }
            for (int i = 0; i < jsonArraythreeDS2CardRangeDetails.size(); ++i) {
                ThreeDS2CardRangeDetail.validateJsonObject(jsonArraythreeDS2CardRangeDetails.get(i).getAsJsonObject());
            }
        }
    }

    public static ThreeDSAvailabilityResponse fromJson(String jsonString) throws IOException {
        return (ThreeDSAvailabilityResponse)JSON.getGson().fromJson(jsonString, ThreeDSAvailabilityResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BIN_DETAILS);
        openapiFields.add(SERIALIZED_NAME_DS_PUBLIC_KEYS);
        openapiFields.add(SERIALIZED_NAME_THREE_D_S1_SUPPORTED);
        openapiFields.add(SERIALIZED_NAME_THREE_D_S2_CARD_RANGE_DETAILS);
        openapiFields.add(SERIALIZED_NAME_THREE_D_S2SUPPORTED);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(ThreeDSAvailabilityResponse.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ThreeDSAvailabilityResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ThreeDSAvailabilityResponse.class));
            return new TypeAdapter<ThreeDSAvailabilityResponse>(){

                public void write(JsonWriter out, ThreeDSAvailabilityResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ThreeDSAvailabilityResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ThreeDSAvailabilityResponse.validateJsonObject(jsonObj);
                    return (ThreeDSAvailabilityResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

