/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.AdditionalBankIdentification;
import com.adyen.model.balanceplatform.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class NumberAndBicAccountIdentification {
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "accountNumber";
    @SerializedName(value="accountNumber")
    private String accountNumber;
    public static final String SERIALIZED_NAME_ADDITIONAL_BANK_IDENTIFICATION = "additionalBankIdentification";
    @SerializedName(value="additionalBankIdentification")
    private AdditionalBankIdentification additionalBankIdentification;
    public static final String SERIALIZED_NAME_BIC = "bic";
    @SerializedName(value="bic")
    private String bic;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type = TypeEnum.NUMBERANDBIC;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public NumberAndBicAccountIdentification accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The bank account number, without separators or whitespace. The length and format depends on the bank or country.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public NumberAndBicAccountIdentification additionalBankIdentification(AdditionalBankIdentification additionalBankIdentification) {
        this.additionalBankIdentification = additionalBankIdentification;
        return this;
    }

    @ApiModelProperty(value="")
    public AdditionalBankIdentification getAdditionalBankIdentification() {
        return this.additionalBankIdentification;
    }

    public void setAdditionalBankIdentification(AdditionalBankIdentification additionalBankIdentification) {
        this.additionalBankIdentification = additionalBankIdentification;
    }

    public NumberAndBicAccountIdentification bic(String bic) {
        this.bic = bic;
        return this;
    }

    @ApiModelProperty(required=true, value="The bank's 8- or 11-character BIC or SWIFT code.")
    public String getBic() {
        return this.bic;
    }

    public void setBic(String bic) {
        this.bic = bic;
    }

    public NumberAndBicAccountIdentification type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="**numberAndBic**")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumberAndBicAccountIdentification numberAndBicAccountIdentification = (NumberAndBicAccountIdentification)o;
        return Objects.equals(this.accountNumber, numberAndBicAccountIdentification.accountNumber) && Objects.equals(this.additionalBankIdentification, numberAndBicAccountIdentification.additionalBankIdentification) && Objects.equals(this.bic, numberAndBicAccountIdentification.bic) && Objects.equals((Object)this.type, (Object)numberAndBicAccountIdentification.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountNumber, this.additionalBankIdentification, this.bic, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NumberAndBicAccountIdentification {\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    additionalBankIdentification: ").append(this.toIndentedString(this.additionalBankIdentification)).append("\n");
        sb.append("    bic: ").append(this.toIndentedString(this.bic)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        NumberAndBicAccountIdentification.validateJsonObject(jsonObj, false);
    }

    public static void validateJsonObject(JsonObject jsonObj, boolean strictValidation) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in NumberAndBicAccountIdentification is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (strictValidation) {
            Set entries = jsonObj.entrySet();
            for (Map.Entry entry : entries) {
                if (openapiFields.contains(entry.getKey())) continue;
                throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `NumberAndBicAccountIdentification` properties.", entry.getKey()));
            }
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `accountNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDITIONAL_BANK_IDENTIFICATION) != null) {
            AdditionalBankIdentification.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDITIONAL_BANK_IDENTIFICATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_BIC) != null && !jsonObj.get(SERIALIZED_NAME_BIC).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `bic` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BIC).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static NumberAndBicAccountIdentification fromJson(String jsonString) throws IOException {
        return (NumberAndBicAccountIdentification)JSON.getGson().fromJson(jsonString, NumberAndBicAccountIdentification.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_NUMBER);
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_BANK_IDENTIFICATION);
        openapiFields.add(SERIALIZED_NAME_BIC);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ACCOUNT_NUMBER);
        openapiRequiredFields.add(SERIALIZED_NAME_BIC);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!NumberAndBicAccountIdentification.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(NumberAndBicAccountIdentification.class));
            return new TypeAdapter<NumberAndBicAccountIdentification>(){

                public void write(JsonWriter out, NumberAndBicAccountIdentification value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public NumberAndBicAccountIdentification read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    NumberAndBicAccountIdentification.validateJsonObject(jsonObj);
                    return (NumberAndBicAccountIdentification)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        NUMBERANDBIC("numberAndBic");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

