/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.adyen.model.balanceplatform.SweepConfigurationV2;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BalanceSweepConfigurationsResponse {
    public static final String SERIALIZED_NAME_HAS_NEXT = "hasNext";
    @SerializedName(value="hasNext")
    private Boolean hasNext;
    public static final String SERIALIZED_NAME_HAS_PREVIOUS = "hasPrevious";
    @SerializedName(value="hasPrevious")
    private Boolean hasPrevious;
    public static final String SERIALIZED_NAME_SWEEPS = "sweeps";
    @SerializedName(value="sweeps")
    private List<SweepConfigurationV2> sweeps = new ArrayList<SweepConfigurationV2>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public BalanceSweepConfigurationsResponse hasNext(Boolean hasNext) {
        this.hasNext = hasNext;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether there are more items on the next page.")
    public Boolean getHasNext() {
        return this.hasNext;
    }

    public void setHasNext(Boolean hasNext) {
        this.hasNext = hasNext;
    }

    public BalanceSweepConfigurationsResponse hasPrevious(Boolean hasPrevious) {
        this.hasPrevious = hasPrevious;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether there are more items on the previous page.")
    public Boolean getHasPrevious() {
        return this.hasPrevious;
    }

    public void setHasPrevious(Boolean hasPrevious) {
        this.hasPrevious = hasPrevious;
    }

    public BalanceSweepConfigurationsResponse sweeps(List<SweepConfigurationV2> sweeps) {
        this.sweeps = sweeps;
        return this;
    }

    public BalanceSweepConfigurationsResponse addSweepsItem(SweepConfigurationV2 sweepsItem) {
        this.sweeps.add(sweepsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of sweeps associated with the balance account.")
    public List<SweepConfigurationV2> getSweeps() {
        return this.sweeps;
    }

    public void setSweeps(List<SweepConfigurationV2> sweeps) {
        this.sweeps = sweeps;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalanceSweepConfigurationsResponse balanceSweepConfigurationsResponse = (BalanceSweepConfigurationsResponse)o;
        return Objects.equals(this.hasNext, balanceSweepConfigurationsResponse.hasNext) && Objects.equals(this.hasPrevious, balanceSweepConfigurationsResponse.hasPrevious) && Objects.equals(this.sweeps, balanceSweepConfigurationsResponse.sweeps);
    }

    public int hashCode() {
        return Objects.hash(this.hasNext, this.hasPrevious, this.sweeps);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BalanceSweepConfigurationsResponse {\n");
        sb.append("    hasNext: ").append(this.toIndentedString(this.hasNext)).append("\n");
        sb.append("    hasPrevious: ").append(this.toIndentedString(this.hasPrevious)).append("\n");
        sb.append("    sweeps: ").append(this.toIndentedString(this.sweeps)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        BalanceSweepConfigurationsResponse.validateJsonObject(jsonObj, false);
    }

    public static void validateJsonObject(JsonObject jsonObj, boolean strictValidation) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in BalanceSweepConfigurationsResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (strictValidation) {
            Set entries = jsonObj.entrySet();
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (openapiFields.contains(entry.getKey())) continue;
                throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `BalanceSweepConfigurationsResponse` properties.", entry.getKey()));
            }
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        JsonArray jsonArraysweeps = jsonObj.getAsJsonArray(SERIALIZED_NAME_SWEEPS);
        if (jsonArraysweeps != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SWEEPS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `sweeps` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SWEEPS).toString()));
            }
            for (int i = 0; i < jsonArraysweeps.size(); ++i) {
                SweepConfigurationV2.validateJsonObject(jsonArraysweeps.get(i).getAsJsonObject());
            }
        }
    }

    public static BalanceSweepConfigurationsResponse fromJson(String jsonString) throws IOException {
        return (BalanceSweepConfigurationsResponse)JSON.getGson().fromJson(jsonString, BalanceSweepConfigurationsResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_HAS_NEXT);
        openapiFields.add(SERIALIZED_NAME_HAS_PREVIOUS);
        openapiFields.add(SERIALIZED_NAME_SWEEPS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_HAS_NEXT);
        openapiRequiredFields.add(SERIALIZED_NAME_HAS_PREVIOUS);
        openapiRequiredFields.add(SERIALIZED_NAME_SWEEPS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!BalanceSweepConfigurationsResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(BalanceSweepConfigurationsResponse.class));
            return new TypeAdapter<BalanceSweepConfigurationsResponse>(){

                public void write(JsonWriter out, BalanceSweepConfigurationsResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public BalanceSweepConfigurationsResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    BalanceSweepConfigurationsResponse.validateJsonObject(jsonObj);
                    return (BalanceSweepConfigurationsResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

