/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.resource;

import com.adyen.Config;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.httpclient.ClientInterface;
import com.adyen.httpclient.HTTPClientException;
import com.adyen.model.ApiError;
import com.adyen.model.RequestOptions;
import com.adyen.service.exception.ApiException;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class Resource {
    protected static final Gson GSON = new Gson();
    protected String endpoint;
    protected List<String> requiredFields;
    private final Service service;

    public Resource(Service service, String endpoint, List<String> requiredFields) {
        this.service = service;
        this.endpoint = endpoint;
        this.requiredFields = requiredFields;
    }

    public String request(String json, ApiConstants.HttpMethod httpMethod) throws ApiException, IOException {
        return this.request(json, null, httpMethod, null);
    }

    public String request(String json) throws ApiException, IOException {
        return this.request(json, null, ApiConstants.HttpMethod.POST, null);
    }

    public String request(String json, RequestOptions requestOptions) throws ApiException, IOException {
        return this.request(json, requestOptions, ApiConstants.HttpMethod.POST, null);
    }

    public String request(String json, RequestOptions requestOptions, ApiConstants.HttpMethod httpMethod, Map<String, String> pathParams) throws ApiException, IOException {
        return this.request(json, requestOptions, httpMethod, pathParams, null);
    }

    public String request(String json, RequestOptions requestOptions, ApiConstants.HttpMethod httpMethod, Map<String, String> pathParams, Map<String, String> queryString) throws ApiException, IOException {
        ClientInterface clientInterface = this.service.getClient().getHttpClient();
        Config config = this.service.getClient().getConfig();
        try {
            return clientInterface.request(this.resolve(pathParams), json, config, this.service.isApiKeyRequired(), requestOptions, httpMethod, queryString);
        }
        catch (HTTPClientException e) {
            ApiException apiException = new ApiException(e.getMessage(), e.getCode(), e.getResponseHeaders());
            apiException.setResponseBody(e.getResponseBody());
            apiException.setError(ApiError.fromJson(e.getResponseBody()));
            throw apiException;
        }
    }

    private String resolve(Map<String, String> params) {
        int endVar;
        if (this.endpoint == null || params == null || this.endpoint.isEmpty() || params.isEmpty()) {
            return this.endpoint;
        }
        StringBuilder path = new StringBuilder();
        int i = 0;
        do {
            int beginVar;
            if ((beginVar = this.endpoint.indexOf("{", i)) < 0) {
                path.append(this.endpoint, i, this.endpoint.length());
                break;
            }
            path.append(this.endpoint, i, beginVar);
            endVar = this.endpoint.indexOf("}", i);
            if (endVar < 0) {
                path.append(this.endpoint, beginVar, this.endpoint.length());
                break;
            }
            String varName = this.endpoint.substring(beginVar + 1, endVar);
            path.append(params.get(varName));
        } while ((i = endVar + 1) < this.endpoint.length());
        return path.toString();
    }
}

