/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CheckoutQrCodeAction {
    public static final String SERIALIZED_NAME_EXPIRES_AT = "expiresAt";
    @SerializedName(value="expiresAt")
    private String expiresAt;
    public static final String SERIALIZED_NAME_PAYMENT_DATA = "paymentData";
    @SerializedName(value="paymentData")
    private String paymentData;
    public static final String SERIALIZED_NAME_PAYMENT_METHOD_TYPE = "paymentMethodType";
    @SerializedName(value="paymentMethodType")
    private String paymentMethodType;
    public static final String SERIALIZED_NAME_QR_CODE_DATA = "qrCodeData";
    @SerializedName(value="qrCodeData")
    private String qrCodeData;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public CheckoutQrCodeAction expiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @ApiModelProperty(value="Expiry time of the QR code.")
    public String getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
    }

    public CheckoutQrCodeAction paymentData(String paymentData) {
        this.paymentData = paymentData;
        return this;
    }

    @ApiModelProperty(value="A value that must be submitted to the `/payments/details` endpoint to verify this payment.")
    public String getPaymentData() {
        return this.paymentData;
    }

    public void setPaymentData(String paymentData) {
        this.paymentData = paymentData;
    }

    public CheckoutQrCodeAction paymentMethodType(String paymentMethodType) {
        this.paymentMethodType = paymentMethodType;
        return this;
    }

    @ApiModelProperty(value="Specifies the payment method.")
    public String getPaymentMethodType() {
        return this.paymentMethodType;
    }

    public void setPaymentMethodType(String paymentMethodType) {
        this.paymentMethodType = paymentMethodType;
    }

    public CheckoutQrCodeAction qrCodeData(String qrCodeData) {
        this.qrCodeData = qrCodeData;
        return this;
    }

    @ApiModelProperty(value="The contents of the QR code as a UTF8 string.")
    public String getQrCodeData() {
        return this.qrCodeData;
    }

    public void setQrCodeData(String qrCodeData) {
        this.qrCodeData = qrCodeData;
    }

    public CheckoutQrCodeAction type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="**qrCode**")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CheckoutQrCodeAction url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="Specifies the URL to redirect to.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckoutQrCodeAction checkoutQrCodeAction = (CheckoutQrCodeAction)o;
        return Objects.equals(this.expiresAt, checkoutQrCodeAction.expiresAt) && Objects.equals(this.paymentData, checkoutQrCodeAction.paymentData) && Objects.equals(this.paymentMethodType, checkoutQrCodeAction.paymentMethodType) && Objects.equals(this.qrCodeData, checkoutQrCodeAction.qrCodeData) && Objects.equals((Object)this.type, (Object)checkoutQrCodeAction.type) && Objects.equals(this.url, checkoutQrCodeAction.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.expiresAt, this.paymentData, this.paymentMethodType, this.qrCodeData, this.type, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CheckoutQrCodeAction {\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    paymentData: ").append(this.toIndentedString(this.paymentData)).append("\n");
        sb.append("    paymentMethodType: ").append(this.toIndentedString(this.paymentMethodType)).append("\n");
        sb.append("    qrCodeData: ").append(this.toIndentedString(this.qrCodeData)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CheckoutQrCodeAction is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `CheckoutQrCodeAction` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXPIRES_AT) != null && !jsonObj.get(SERIALIZED_NAME_EXPIRES_AT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `expiresAt` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXPIRES_AT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAYMENT_DATA) != null && !jsonObj.get(SERIALIZED_NAME_PAYMENT_DATA).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `paymentData` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAYMENT_DATA).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAYMENT_METHOD_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_PAYMENT_METHOD_TYPE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `paymentMethodType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAYMENT_METHOD_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_QR_CODE_DATA) != null && !jsonObj.get(SERIALIZED_NAME_QR_CODE_DATA).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `qrCodeData` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_QR_CODE_DATA).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_URL) != null && !jsonObj.get(SERIALIZED_NAME_URL).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URL).toString()));
        }
    }

    public static CheckoutQrCodeAction fromJson(String jsonString) throws IOException {
        return (CheckoutQrCodeAction)JSON.getGson().fromJson(jsonString, CheckoutQrCodeAction.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_EXPIRES_AT);
        openapiFields.add(SERIALIZED_NAME_PAYMENT_DATA);
        openapiFields.add(SERIALIZED_NAME_PAYMENT_METHOD_TYPE);
        openapiFields.add(SERIALIZED_NAME_QR_CODE_DATA);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_URL);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
        log = Logger.getLogger(CheckoutQrCodeAction.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CheckoutQrCodeAction.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CheckoutQrCodeAction.class));
            return new TypeAdapter<CheckoutQrCodeAction>(){

                public void write(JsonWriter out, CheckoutQrCodeAction value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CheckoutQrCodeAction read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CheckoutQrCodeAction.validateJsonObject(jsonObj);
                    return (CheckoutQrCodeAction)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        QRCODE("qrCode");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

