/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.adyen.model.balanceplatform.MerchantAcquirerPair;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MerchantsRestriction {
    public static final String SERIALIZED_NAME_OPERATION = "operation";
    @SerializedName(value="operation")
    private String operation;
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    private List<MerchantAcquirerPair> value = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public MerchantsRestriction operation(String operation) {
        this.operation = operation;
        return this;
    }

    @ApiModelProperty(required=true, value="Defines how the condition must be evaluated.")
    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public MerchantsRestriction value(List<MerchantAcquirerPair> value) {
        this.value = value;
        return this;
    }

    public MerchantsRestriction addValueItem(MerchantAcquirerPair valueItem) {
        if (this.value == null) {
            this.value = new ArrayList<MerchantAcquirerPair>();
        }
        this.value.add(valueItem);
        return this;
    }

    @ApiModelProperty(value="List of merchant ID and acquirer ID pairs.")
    public List<MerchantAcquirerPair> getValue() {
        return this.value;
    }

    public void setValue(List<MerchantAcquirerPair> value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MerchantsRestriction merchantsRestriction = (MerchantsRestriction)o;
        return Objects.equals(this.operation, merchantsRestriction.operation) && Objects.equals(this.value, merchantsRestriction.value);
    }

    public int hashCode() {
        return Objects.hash(this.operation, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MerchantsRestriction {\n");
        sb.append("    operation: ").append(this.toIndentedString(this.operation)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayvalue;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in MerchantsRestriction is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `MerchantsRestriction` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OPERATION) != null && !jsonObj.get(SERIALIZED_NAME_OPERATION).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `operation` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OPERATION).toString()));
        }
        if ((jsonArrayvalue = jsonObj.getAsJsonArray(SERIALIZED_NAME_VALUE)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VALUE).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `value` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VALUE).toString()));
            }
            for (int i = 0; i < jsonArrayvalue.size(); ++i) {
                MerchantAcquirerPair.validateJsonObject(jsonArrayvalue.get(i).getAsJsonObject());
            }
        }
    }

    public static MerchantsRestriction fromJson(String jsonString) throws IOException {
        return (MerchantsRestriction)JSON.getGson().fromJson(jsonString, MerchantsRestriction.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_OPERATION);
        openapiFields.add(SERIALIZED_NAME_VALUE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_OPERATION);
        log = Logger.getLogger(MerchantsRestriction.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!MerchantsRestriction.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(MerchantsRestriction.class));
            return new TypeAdapter<MerchantsRestriction>(){

                public void write(JsonWriter out, MerchantsRestriction value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public MerchantsRestriction read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    MerchantsRestriction.validateJsonObject(jsonObj);
                    return (MerchantsRestriction)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

