/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.Amount;
import com.adyen.model.transfers.CounterpartyInfoV3;
import com.adyen.model.transfers.JSON;
import com.adyen.model.transfers.UltimatePartyIdentification;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class TransferInfo {
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Amount amount;
    public static final String SERIALIZED_NAME_BALANCE_ACCOUNT_ID = "balanceAccountId";
    @SerializedName(value="balanceAccountId")
    private String balanceAccountId;
    public static final String SERIALIZED_NAME_CATEGORY = "category";
    @SerializedName(value="category")
    private CategoryEnum category;
    public static final String SERIALIZED_NAME_COUNTERPARTY = "counterparty";
    @SerializedName(value="counterparty")
    private CounterpartyInfoV3 counterparty;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_PAYMENT_INSTRUMENT_ID = "paymentInstrumentId";
    @SerializedName(value="paymentInstrumentId")
    private String paymentInstrumentId;
    public static final String SERIALIZED_NAME_PRIORITY = "priority";
    @SerializedName(value="priority")
    private PriorityEnum priority;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_REFERENCE_FOR_BENEFICIARY = "referenceForBeneficiary";
    @SerializedName(value="referenceForBeneficiary")
    private String referenceForBeneficiary;
    public static final String SERIALIZED_NAME_ULTIMATE_PARTY = "ultimateParty";
    @SerializedName(value="ultimateParty")
    private UltimatePartyIdentification ultimateParty;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TransferInfo amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public TransferInfo balanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the source [balance account](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id).")
    public String getBalanceAccountId() {
        return this.balanceAccountId;
    }

    public void setBalanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
    }

    public TransferInfo category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of transfer.  Possible values:   - **bank**: Transfer to a [transfer instrument](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/transferInstruments__resParam_id) or a bank account.  - **internal**: Transfer to another [balance account](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id) within your platform.  - **issuedCard**: Transfer initiated by a Adyen-issued card.  - **platformPayment**: Fund movements related to payments that are acquired for your users.")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public TransferInfo counterparty(CounterpartyInfoV3 counterparty) {
        this.counterparty = counterparty;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public CounterpartyInfoV3 getCounterparty() {
        return this.counterparty;
    }

    public void setCounterparty(CounterpartyInfoV3 counterparty) {
        this.counterparty = counterparty;
    }

    public TransferInfo description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Your description for the transfer. It is used by most banks as the transfer description. We recommend sending a maximum of 140 characters, otherwise the description may be truncated.  Supported characters: **[a-z] [A-Z] [0-9] / - ?** **: ( ) . , ' + Space**  Supported characters for **regular** and **fast** transfers to a US counterparty: **[a-z] [A-Z] [0-9] & $ % # @** **~ = + - _ ' \" ! ?**")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TransferInfo id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the resource.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TransferInfo paymentInstrumentId(String paymentInstrumentId) {
        this.paymentInstrumentId = paymentInstrumentId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the source [payment instrument](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/paymentInstruments__resParam_id).")
    public String getPaymentInstrumentId() {
        return this.paymentInstrumentId;
    }

    public void setPaymentInstrumentId(String paymentInstrumentId) {
        this.paymentInstrumentId = paymentInstrumentId;
    }

    public TransferInfo priority(PriorityEnum priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(value="The priority for the bank transfer. This sets the speed at which the transfer is sent and the fees that you have to pay. Required for transfers with `category` **bank**.  Possible values:  * **regular**: For normal, low-value transactions.  * **fast**: Faster way to transfer funds but has higher fees. Recommended for high-priority, low-value transactions.  * **wire**: Fastest way to transfer funds but has the highest fees. Recommended for high-priority, high-value transactions.  * **instant**: Instant way to transfer funds in [SEPA countries](https://www.ecb.europa.eu/paym/integration/retail/sepa/html/index.en.html).  * **crossBorder**: High-value transfer to a recipient in a different country.  * **internal**: Transfer to an Adyen-issued business bank account (by bank account number/IBAN).")
    public PriorityEnum getPriority() {
        return this.priority;
    }

    public void setPriority(PriorityEnum priority) {
        this.priority = priority;
    }

    public TransferInfo reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the transfer, used internally within your platform. If you don't provide this in the request, Adyen generates a unique reference.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public TransferInfo referenceForBeneficiary(String referenceForBeneficiary) {
        this.referenceForBeneficiary = referenceForBeneficiary;
        return this;
    }

    @ApiModelProperty(value=" A reference that is sent to the recipient. This reference is also sent in all notification webhooks related to the transfer, so you can use it to track statuses for both the source and recipient of funds.   Supported characters: **a-z**, **A-Z**, **0-9**. The maximum length depends on the `category`.  - **internal**: 80 characters  - **bank**: 35 characters when transferring to an IBAN, 15 characters for others.")
    public String getReferenceForBeneficiary() {
        return this.referenceForBeneficiary;
    }

    public void setReferenceForBeneficiary(String referenceForBeneficiary) {
        this.referenceForBeneficiary = referenceForBeneficiary;
    }

    public TransferInfo ultimateParty(UltimatePartyIdentification ultimateParty) {
        this.ultimateParty = ultimateParty;
        return this;
    }

    @ApiModelProperty(value="")
    public UltimatePartyIdentification getUltimateParty() {
        return this.ultimateParty;
    }

    public void setUltimateParty(UltimatePartyIdentification ultimateParty) {
        this.ultimateParty = ultimateParty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferInfo transferInfo = (TransferInfo)o;
        return Objects.equals(this.amount, transferInfo.amount) && Objects.equals(this.balanceAccountId, transferInfo.balanceAccountId) && Objects.equals((Object)this.category, (Object)transferInfo.category) && Objects.equals(this.counterparty, transferInfo.counterparty) && Objects.equals(this.description, transferInfo.description) && Objects.equals(this.id, transferInfo.id) && Objects.equals(this.paymentInstrumentId, transferInfo.paymentInstrumentId) && Objects.equals((Object)this.priority, (Object)transferInfo.priority) && Objects.equals(this.reference, transferInfo.reference) && Objects.equals(this.referenceForBeneficiary, transferInfo.referenceForBeneficiary) && Objects.equals(this.ultimateParty, transferInfo.ultimateParty);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.balanceAccountId, this.category, this.counterparty, this.description, this.id, this.paymentInstrumentId, this.priority, this.reference, this.referenceForBeneficiary, this.ultimateParty});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferInfo {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    balanceAccountId: ").append(this.toIndentedString(this.balanceAccountId)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    counterparty: ").append(this.toIndentedString(this.counterparty)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    paymentInstrumentId: ").append(this.toIndentedString(this.paymentInstrumentId)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString((Object)this.priority)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    referenceForBeneficiary: ").append(this.toIndentedString(this.referenceForBeneficiary)).append("\n");
        sb.append("    ultimateParty: ").append(this.toIndentedString(this.ultimateParty)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TransferInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TransferInfo` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT));
        }
        if (jsonObj.get(SERIALIZED_NAME_BALANCE_ACCOUNT_ID) != null && !jsonObj.get(SERIALIZED_NAME_BALANCE_ACCOUNT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `balanceAccountId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BALANCE_ACCOUNT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CATEGORY) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CATEGORY).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `category` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CATEGORY).toString()));
            }
            CategoryEnum.fromValue(jsonObj.get(SERIALIZED_NAME_CATEGORY).getAsString());
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_COUNTERPARTY) != null) {
            CounterpartyInfoV3.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_COUNTERPARTY));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAYMENT_INSTRUMENT_ID) != null && !jsonObj.get(SERIALIZED_NAME_PAYMENT_INSTRUMENT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `paymentInstrumentId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAYMENT_INSTRUMENT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRIORITY) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PRIORITY).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `priority` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRIORITY).toString()));
            }
            PriorityEnum.fromValue(jsonObj.get(SERIALIZED_NAME_PRIORITY).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE_FOR_BENEFICIARY) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE_FOR_BENEFICIARY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `referenceForBeneficiary` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE_FOR_BENEFICIARY).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ULTIMATE_PARTY) != null) {
            UltimatePartyIdentification.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ULTIMATE_PARTY));
        }
    }

    public static TransferInfo fromJson(String jsonString) throws IOException {
        return (TransferInfo)JSON.getGson().fromJson(jsonString, TransferInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_BALANCE_ACCOUNT_ID);
        openapiFields.add(SERIALIZED_NAME_CATEGORY);
        openapiFields.add(SERIALIZED_NAME_COUNTERPARTY);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_PAYMENT_INSTRUMENT_ID);
        openapiFields.add(SERIALIZED_NAME_PRIORITY);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_REFERENCE_FOR_BENEFICIARY);
        openapiFields.add(SERIALIZED_NAME_ULTIMATE_PARTY);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_AMOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_CATEGORY);
        openapiRequiredFields.add(SERIALIZED_NAME_COUNTERPARTY);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TransferInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TransferInfo.class));
            return new TypeAdapter<TransferInfo>(){

                public void write(JsonWriter out, TransferInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TransferInfo read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TransferInfo.validateJsonObject(jsonObj);
                    return (TransferInfo)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PriorityEnum {
        CROSSBORDER("crossBorder"),
        DIRECTDEBIT("directDebit"),
        FAST("fast"),
        INSTANT("instant"),
        INTERNAL("internal"),
        REGULAR("regular"),
        WIRE("wire");

        private String value;

        private PriorityEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PriorityEnum fromValue(String value) {
            for (PriorityEnum b : PriorityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PriorityEnum> {
            public void write(JsonWriter jsonWriter, PriorityEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PriorityEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PriorityEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CategoryEnum {
        BANK("bank"),
        INTERNAL("internal"),
        ISSUEDCARD("issuedCard"),
        PLATFORMPAYMENT("platformPayment");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<CategoryEnum> {
            public void write(JsonWriter jsonWriter, CategoryEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CategoryEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CategoryEnum.fromValue(value);
            }
        }
    }
}

