/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payout;

import com.adyen.model.payout.Address;
import com.adyen.model.payout.BankAccount;
import com.adyen.model.payout.Card;
import com.adyen.model.payout.JSON;
import com.adyen.model.payout.Name;
import com.adyen.model.payout.Recurring;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class StoreDetailRequest {
    public static final String SERIALIZED_NAME_ADDITIONAL_DATA = "additionalData";
    @SerializedName(value="additionalData")
    private Map<String, String> additionalData = null;
    public static final String SERIALIZED_NAME_BANK = "bank";
    @SerializedName(value="bank")
    private BankAccount bank;
    public static final String SERIALIZED_NAME_BILLING_ADDRESS = "billingAddress";
    @SerializedName(value="billingAddress")
    private Address billingAddress;
    public static final String SERIALIZED_NAME_CARD = "card";
    @SerializedName(value="card")
    private Card card;
    public static final String SERIALIZED_NAME_DATE_OF_BIRTH = "dateOfBirth";
    @SerializedName(value="dateOfBirth")
    private LocalDate dateOfBirth;
    public static final String SERIALIZED_NAME_ENTITY_TYPE = "entityType";
    @SerializedName(value="entityType")
    private EntityTypeEnum entityType;
    public static final String SERIALIZED_NAME_FRAUD_OFFSET = "fraudOffset";
    @SerializedName(value="fraudOffset")
    private Integer fraudOffset;
    public static final String SERIALIZED_NAME_MERCHANT_ACCOUNT = "merchantAccount";
    @SerializedName(value="merchantAccount")
    private String merchantAccount;
    public static final String SERIALIZED_NAME_NATIONALITY = "nationality";
    @SerializedName(value="nationality")
    private String nationality;
    public static final String SERIALIZED_NAME_RECURRING = "recurring";
    @SerializedName(value="recurring")
    private Recurring recurring;
    public static final String SERIALIZED_NAME_SELECTED_BRAND = "selectedBrand";
    @SerializedName(value="selectedBrand")
    private String selectedBrand;
    public static final String SERIALIZED_NAME_SHOPPER_EMAIL = "shopperEmail";
    @SerializedName(value="shopperEmail")
    private String shopperEmail;
    public static final String SERIALIZED_NAME_SHOPPER_NAME = "shopperName";
    @SerializedName(value="shopperName")
    private Name shopperName;
    public static final String SERIALIZED_NAME_SHOPPER_REFERENCE = "shopperReference";
    @SerializedName(value="shopperReference")
    private String shopperReference;
    public static final String SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER = "socialSecurityNumber";
    @SerializedName(value="socialSecurityNumber")
    private String socialSecurityNumber;
    public static final String SERIALIZED_NAME_TELEPHONE_NUMBER = "telephoneNumber";
    @SerializedName(value="telephoneNumber")
    private String telephoneNumber;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public StoreDetailRequest additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public StoreDetailRequest putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @ApiModelProperty(value="This field contains additional data, which may be required for a particular request.")
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public StoreDetailRequest bank(BankAccount bank) {
        this.bank = bank;
        return this;
    }

    @ApiModelProperty(value="")
    public BankAccount getBank() {
        return this.bank;
    }

    public void setBank(BankAccount bank) {
        this.bank = bank;
    }

    public StoreDetailRequest billingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @ApiModelProperty(value="")
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    public StoreDetailRequest card(Card card) {
        this.card = card;
        return this;
    }

    @ApiModelProperty(value="")
    public Card getCard() {
        return this.card;
    }

    public void setCard(Card card) {
        this.card = card;
    }

    public StoreDetailRequest dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @ApiModelProperty(required=true, value="The date of birth. Format: [ISO-8601](https://www.w3.org/TR/NOTE-datetime); example: YYYY-MM-DD For Paysafecard it must be the same as used when registering the Paysafecard account. > This field is mandatory for natural persons.")
    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public StoreDetailRequest entityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of the entity the payout is processed for.")
    public EntityTypeEnum getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
    }

    public StoreDetailRequest fraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
        return this;
    }

    @ApiModelProperty(value="An integer value that is added to the normal fraud score. The value can be either positive or negative.")
    public Integer getFraudOffset() {
        return this.fraudOffset;
    }

    public void setFraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
    }

    public StoreDetailRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account identifier, with which you want to process the transaction.")
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public StoreDetailRequest nationality(String nationality) {
        this.nationality = nationality;
        return this;
    }

    @ApiModelProperty(required=true, value="The shopper's nationality.  A valid value is an ISO 2-character country code (e.g. 'NL').")
    public String getNationality() {
        return this.nationality;
    }

    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    public StoreDetailRequest recurring(Recurring recurring) {
        this.recurring = recurring;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Recurring getRecurring() {
        return this.recurring;
    }

    public void setRecurring(Recurring recurring) {
        this.recurring = recurring;
    }

    public StoreDetailRequest selectedBrand(String selectedBrand) {
        this.selectedBrand = selectedBrand;
        return this;
    }

    @ApiModelProperty(value="The name of the brand to make a payout to.  For Paysafecard it must be set to `paysafecard`.")
    public String getSelectedBrand() {
        return this.selectedBrand;
    }

    public void setSelectedBrand(String selectedBrand) {
        this.selectedBrand = selectedBrand;
    }

    public StoreDetailRequest shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        return this;
    }

    @ApiModelProperty(required=true, value="The shopper's email address.")
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public StoreDetailRequest shopperName(Name shopperName) {
        this.shopperName = shopperName;
        return this;
    }

    @ApiModelProperty(value="")
    public Name getShopperName() {
        return this.shopperName;
    }

    public void setShopperName(Name shopperName) {
        this.shopperName = shopperName;
    }

    public StoreDetailRequest shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @ApiModelProperty(required=true, value="The shopper's reference for the payment transaction.")
    public String getShopperReference() {
        return this.shopperReference;
    }

    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public StoreDetailRequest socialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
        return this;
    }

    @ApiModelProperty(value="The shopper's social security number.")
    public String getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    public void setSocialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
    }

    public StoreDetailRequest telephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
        return this;
    }

    @ApiModelProperty(value="The shopper's phone number.")
    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreDetailRequest storeDetailRequest = (StoreDetailRequest)o;
        return Objects.equals(this.additionalData, storeDetailRequest.additionalData) && Objects.equals(this.bank, storeDetailRequest.bank) && Objects.equals(this.billingAddress, storeDetailRequest.billingAddress) && Objects.equals(this.card, storeDetailRequest.card) && Objects.equals(this.dateOfBirth, storeDetailRequest.dateOfBirth) && Objects.equals((Object)this.entityType, (Object)storeDetailRequest.entityType) && Objects.equals(this.fraudOffset, storeDetailRequest.fraudOffset) && Objects.equals(this.merchantAccount, storeDetailRequest.merchantAccount) && Objects.equals(this.nationality, storeDetailRequest.nationality) && Objects.equals(this.recurring, storeDetailRequest.recurring) && Objects.equals(this.selectedBrand, storeDetailRequest.selectedBrand) && Objects.equals(this.shopperEmail, storeDetailRequest.shopperEmail) && Objects.equals(this.shopperName, storeDetailRequest.shopperName) && Objects.equals(this.shopperReference, storeDetailRequest.shopperReference) && Objects.equals(this.socialSecurityNumber, storeDetailRequest.socialSecurityNumber) && Objects.equals(this.telephoneNumber, storeDetailRequest.telephoneNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalData, this.bank, this.billingAddress, this.card, this.dateOfBirth, this.entityType, this.fraudOffset, this.merchantAccount, this.nationality, this.recurring, this.selectedBrand, this.shopperEmail, this.shopperName, this.shopperReference, this.socialSecurityNumber, this.telephoneNumber});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StoreDetailRequest {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    bank: ").append(this.toIndentedString(this.bank)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    card: ").append(this.toIndentedString(this.card)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    entityType: ").append(this.toIndentedString((Object)this.entityType)).append("\n");
        sb.append("    fraudOffset: ").append(this.toIndentedString(this.fraudOffset)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    nationality: ").append(this.toIndentedString(this.nationality)).append("\n");
        sb.append("    recurring: ").append(this.toIndentedString(this.recurring)).append("\n");
        sb.append("    selectedBrand: ").append(this.toIndentedString(this.selectedBrand)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    shopperName: ").append(this.toIndentedString(this.shopperName)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    socialSecurityNumber: ").append(this.toIndentedString(this.socialSecurityNumber)).append("\n");
        sb.append("    telephoneNumber: ").append(this.toIndentedString(this.telephoneNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in StoreDetailRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `StoreDetailRequest` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BANK) != null) {
            BankAccount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BANK));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BILLING_ADDRESS) != null) {
            Address.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BILLING_ADDRESS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_CARD) != null) {
            Card.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CARD));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENTITY_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ENTITY_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `entityType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENTITY_TYPE).toString()));
            }
            EntityTypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_ENTITY_TYPE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `merchantAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NATIONALITY) != null && !jsonObj.get(SERIALIZED_NAME_NATIONALITY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `nationality` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NATIONALITY).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_RECURRING) != null) {
            Recurring.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_RECURRING));
        }
        if (jsonObj.get(SERIALIZED_NAME_SELECTED_BRAND) != null && !jsonObj.get(SERIALIZED_NAME_SELECTED_BRAND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `selectedBrand` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SELECTED_BRAND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_EMAIL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shopperEmail` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_EMAIL).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SHOPPER_NAME) != null) {
            Name.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SHOPPER_NAME));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shopperReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `socialSecurityNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TELEPHONE_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_TELEPHONE_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `telephoneNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TELEPHONE_NUMBER).toString()));
        }
    }

    public static StoreDetailRequest fromJson(String jsonString) throws IOException {
        return (StoreDetailRequest)JSON.getGson().fromJson(jsonString, StoreDetailRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_DATA);
        openapiFields.add(SERIALIZED_NAME_BANK);
        openapiFields.add(SERIALIZED_NAME_BILLING_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_CARD);
        openapiFields.add(SERIALIZED_NAME_DATE_OF_BIRTH);
        openapiFields.add(SERIALIZED_NAME_ENTITY_TYPE);
        openapiFields.add(SERIALIZED_NAME_FRAUD_OFFSET);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_NATIONALITY);
        openapiFields.add(SERIALIZED_NAME_RECURRING);
        openapiFields.add(SERIALIZED_NAME_SELECTED_BRAND);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_EMAIL);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_NAME);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER);
        openapiFields.add(SERIALIZED_NAME_TELEPHONE_NUMBER);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_DATE_OF_BIRTH);
        openapiRequiredFields.add(SERIALIZED_NAME_ENTITY_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_NATIONALITY);
        openapiRequiredFields.add(SERIALIZED_NAME_RECURRING);
        openapiRequiredFields.add(SERIALIZED_NAME_SHOPPER_EMAIL);
        openapiRequiredFields.add(SERIALIZED_NAME_SHOPPER_REFERENCE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!StoreDetailRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StoreDetailRequest.class));
            return new TypeAdapter<StoreDetailRequest>(){

                public void write(JsonWriter out, StoreDetailRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public StoreDetailRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    StoreDetailRequest.validateJsonObject(jsonObj);
                    return (StoreDetailRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum EntityTypeEnum {
        NATURALPERSON("NaturalPerson"),
        COMPANY("Company");

        private String value;

        private EntityTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EntityTypeEnum fromValue(String value) {
            for (EntityTypeEnum b : EntityTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<EntityTypeEnum> {
            public void write(JsonWriter jsonWriter, EntityTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public EntityTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return EntityTypeEnum.fromValue(value);
            }
        }
    }
}

