/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Card {
    public static final String SERIALIZED_NAME_CVC = "cvc";
    @SerializedName(value="cvc")
    private String cvc;
    public static final String SERIALIZED_NAME_EXPIRY_MONTH = "expiryMonth";
    @SerializedName(value="expiryMonth")
    private String expiryMonth;
    public static final String SERIALIZED_NAME_EXPIRY_YEAR = "expiryYear";
    @SerializedName(value="expiryYear")
    private String expiryYear;
    public static final String SERIALIZED_NAME_HOLDER_NAME = "holderName";
    @SerializedName(value="holderName")
    private String holderName;
    public static final String SERIALIZED_NAME_ISSUE_NUMBER = "issueNumber";
    @SerializedName(value="issueNumber")
    private String issueNumber;
    public static final String SERIALIZED_NAME_NUMBER = "number";
    @SerializedName(value="number")
    private String number;
    public static final String SERIALIZED_NAME_START_MONTH = "startMonth";
    @SerializedName(value="startMonth")
    private String startMonth;
    public static final String SERIALIZED_NAME_START_YEAR = "startYear";
    @SerializedName(value="startYear")
    private String startYear;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Card cvc(String cvc) {
        this.cvc = cvc;
        return this;
    }

    @ApiModelProperty(value="The [card verification code](https://docs.adyen.com/payments-fundamentals/payment-glossary#card-security-code-cvc-cvv-cid) (1-20 characters). Depending on the card brand, it is known also as: * CVV2/CVC2 \u2013 length: 3 digits * CID \u2013 length: 4 digits > If you are using [Client-Side Encryption](https://docs.adyen.com/classic-integration/cse-integration-ecommerce), the CVC code is present in the encrypted data. You must never post the card details to the server. > This field must be always present in a [one-click payment request](https://docs.adyen.com/classic-integration/recurring-payments). > When this value is returned in a response, it is always empty because it is not stored.")
    public String getCvc() {
        return this.cvc;
    }

    public void setCvc(String cvc) {
        this.cvc = cvc;
    }

    public Card expiryMonth(String expiryMonth) {
        this.expiryMonth = expiryMonth;
        return this;
    }

    @ApiModelProperty(value="The card expiry month. Format: 2 digits, zero-padded for single digits. For example: * 03 = March * 11 = November")
    public String getExpiryMonth() {
        return this.expiryMonth;
    }

    public void setExpiryMonth(String expiryMonth) {
        this.expiryMonth = expiryMonth;
    }

    public Card expiryYear(String expiryYear) {
        this.expiryYear = expiryYear;
        return this;
    }

    @ApiModelProperty(value="The card expiry year. Format: 4 digits. For example: 2020")
    public String getExpiryYear() {
        return this.expiryYear;
    }

    public void setExpiryYear(String expiryYear) {
        this.expiryYear = expiryYear;
    }

    public Card holderName(String holderName) {
        this.holderName = holderName;
        return this;
    }

    @ApiModelProperty(value="The name of the cardholder, as printed on the card.")
    public String getHolderName() {
        return this.holderName;
    }

    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public Card issueNumber(String issueNumber) {
        this.issueNumber = issueNumber;
        return this;
    }

    @ApiModelProperty(value="The issue number of the card (for some UK debit cards only).")
    public String getIssueNumber() {
        return this.issueNumber;
    }

    public void setIssueNumber(String issueNumber) {
        this.issueNumber = issueNumber;
    }

    public Card number(String number) {
        this.number = number;
        return this;
    }

    @ApiModelProperty(value="The card number (4-19 characters). Do not use any separators. When this value is returned in a response, only the last 4 digits of the card number are returned.")
    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Card startMonth(String startMonth) {
        this.startMonth = startMonth;
        return this;
    }

    @ApiModelProperty(value="The month component of the start date (for some UK debit cards only).")
    public String getStartMonth() {
        return this.startMonth;
    }

    public void setStartMonth(String startMonth) {
        this.startMonth = startMonth;
    }

    public Card startYear(String startYear) {
        this.startYear = startYear;
        return this;
    }

    @ApiModelProperty(value="The year component of the start date (for some UK debit cards only).")
    public String getStartYear() {
        return this.startYear;
    }

    public void setStartYear(String startYear) {
        this.startYear = startYear;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Card card = (Card)o;
        return Objects.equals(this.cvc, card.cvc) && Objects.equals(this.expiryMonth, card.expiryMonth) && Objects.equals(this.expiryYear, card.expiryYear) && Objects.equals(this.holderName, card.holderName) && Objects.equals(this.issueNumber, card.issueNumber) && Objects.equals(this.number, card.number) && Objects.equals(this.startMonth, card.startMonth) && Objects.equals(this.startYear, card.startYear);
    }

    public int hashCode() {
        return Objects.hash(this.cvc, this.expiryMonth, this.expiryYear, this.holderName, this.issueNumber, this.number, this.startMonth, this.startYear);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Card {\n");
        sb.append("    cvc: ").append(this.toIndentedString(this.cvc)).append("\n");
        sb.append("    expiryMonth: ").append(this.toIndentedString(this.expiryMonth)).append("\n");
        sb.append("    expiryYear: ").append(this.toIndentedString(this.expiryYear)).append("\n");
        sb.append("    holderName: ").append(this.toIndentedString(this.holderName)).append("\n");
        sb.append("    issueNumber: ").append(this.toIndentedString(this.issueNumber)).append("\n");
        sb.append("    number: ").append(this.toIndentedString(this.number)).append("\n");
        sb.append("    startMonth: ").append(this.toIndentedString(this.startMonth)).append("\n");
        sb.append("    startYear: ").append(this.toIndentedString(this.startYear)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Card is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Card` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CVC) != null && !jsonObj.get(SERIALIZED_NAME_CVC).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cvc` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CVC).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXPIRY_MONTH) != null && !jsonObj.get(SERIALIZED_NAME_EXPIRY_MONTH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `expiryMonth` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXPIRY_MONTH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXPIRY_YEAR) != null && !jsonObj.get(SERIALIZED_NAME_EXPIRY_YEAR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `expiryYear` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXPIRY_YEAR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOLDER_NAME) != null && !jsonObj.get(SERIALIZED_NAME_HOLDER_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `holderName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOLDER_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ISSUE_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_ISSUE_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `issueNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ISSUE_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `number` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_START_MONTH) != null && !jsonObj.get(SERIALIZED_NAME_START_MONTH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `startMonth` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_START_MONTH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_START_YEAR) != null && !jsonObj.get(SERIALIZED_NAME_START_YEAR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `startYear` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_START_YEAR).toString()));
        }
    }

    public static Card fromJson(String jsonString) throws IOException {
        return (Card)JSON.getGson().fromJson(jsonString, Card.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CVC);
        openapiFields.add(SERIALIZED_NAME_EXPIRY_MONTH);
        openapiFields.add(SERIALIZED_NAME_EXPIRY_YEAR);
        openapiFields.add(SERIALIZED_NAME_HOLDER_NAME);
        openapiFields.add(SERIALIZED_NAME_ISSUE_NUMBER);
        openapiFields.add(SERIALIZED_NAME_NUMBER);
        openapiFields.add(SERIALIZED_NAME_START_MONTH);
        openapiFields.add(SERIALIZED_NAME_START_YEAR);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Card.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Card.class));
            return new TypeAdapter<Card>(){

                public void write(JsonWriter out, Card value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Card read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Card.validateJsonObject(jsonObj);
                    return (Card)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

