/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpay;

import com.adyen.model.marketpay.AccountEvent;
import com.adyen.model.marketpay.AccountPayoutState;
import com.adyen.model.marketpay.AccountProcessingState;
import com.adyen.util.Util;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AccountHolderStatus {
    @SerializedName(value="events")
    private List<AccountEvent> events = null;
    @SerializedName(value="payoutState")
    private AccountPayoutState payoutState = null;
    @SerializedName(value="processingState")
    private AccountProcessingState processingState = null;
    @SerializedName(value="status")
    private StatusEnum status = null;
    @SerializedName(value="statusReason")
    private String statusReason = null;

    public AccountHolderStatus events(List<AccountEvent> events) {
        this.events = events;
        return this;
    }

    public AccountHolderStatus addEventsItem(AccountEvent eventsItem) {
        if (this.events == null) {
            this.events = new ArrayList<AccountEvent>();
        }
        this.events.add(eventsItem);
        return this;
    }

    public List<AccountEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<AccountEvent> events) {
        this.events = events;
    }

    public AccountHolderStatus payoutState(AccountPayoutState payoutState) {
        this.payoutState = payoutState;
        return this;
    }

    public AccountPayoutState getPayoutState() {
        return this.payoutState;
    }

    public void setPayoutState(AccountPayoutState payoutState) {
        this.payoutState = payoutState;
    }

    public AccountHolderStatus processingState(AccountProcessingState processingState) {
        this.processingState = processingState;
        return this;
    }

    public AccountProcessingState getProcessingState() {
        return this.processingState;
    }

    public void setProcessingState(AccountProcessingState processingState) {
        this.processingState = processingState;
    }

    public AccountHolderStatus status(StatusEnum status) {
        this.status = status;
        return this;
    }

    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public AccountHolderStatus statusReason(String statusReason) {
        this.statusReason = statusReason;
        return this;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountHolderStatus accountHolderStatus = (AccountHolderStatus)o;
        return Objects.equals(this.events, accountHolderStatus.events) && Objects.equals(this.payoutState, accountHolderStatus.payoutState) && Objects.equals(this.processingState, accountHolderStatus.processingState) && Objects.equals((Object)this.status, (Object)accountHolderStatus.status) && Objects.equals(this.statusReason, accountHolderStatus.statusReason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.events, this.payoutState, this.processingState, this.status, this.statusReason});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountHolderStatus {\n");
        sb.append("    events: ").append(Util.toIndentedString(this.events)).append("\n");
        sb.append("    payoutState: ").append(Util.toIndentedString(this.payoutState)).append("\n");
        sb.append("    processingState: ").append(Util.toIndentedString(this.processingState)).append("\n");
        sb.append("    status: ").append(Util.toIndentedString((Object)this.status)).append("\n");
        sb.append("    statusReason: ").append(Util.toIndentedString(this.statusReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        ACTIVE("Active"),
        CLOSED("Closed"),
        INACTIVE("Inactive"),
        SUSPENDED("Suspended");

        private final String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

