/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.Name2;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class UpdateMerchantUserRequest {
    public static final String SERIALIZED_NAME_ACCOUNT_GROUPS = "accountGroups";
    @SerializedName(value="accountGroups")
    private List<String> accountGroups = null;
    public static final String SERIALIZED_NAME_ACTIVE = "active";
    @SerializedName(value="active")
    private Boolean active;
    public static final String SERIALIZED_NAME_AUTHN_APPS_TO_ADD = "authnAppsToAdd";
    @SerializedName(value="authnAppsToAdd")
    private List<String> authnAppsToAdd = null;
    public static final String SERIALIZED_NAME_AUTHN_APPS_TO_REMOVE = "authnAppsToRemove";
    @SerializedName(value="authnAppsToRemove")
    private List<String> authnAppsToRemove = null;
    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(value="email")
    private String email;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private Name2 name;
    public static final String SERIALIZED_NAME_ROLES = "roles";
    @SerializedName(value="roles")
    private List<String> roles = null;
    public static final String SERIALIZED_NAME_TIME_ZONE_CODE = "timeZoneCode";
    @SerializedName(value="timeZoneCode")
    private String timeZoneCode;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public UpdateMerchantUserRequest accountGroups(List<String> accountGroups) {
        this.accountGroups = accountGroups;
        return this;
    }

    public UpdateMerchantUserRequest addAccountGroupsItem(String accountGroupsItem) {
        if (this.accountGroups == null) {
            this.accountGroups = new ArrayList<String>();
        }
        this.accountGroups.add(accountGroupsItem);
        return this;
    }

    @ApiModelProperty(value="The list of [account groups](https://docs.adyen.com/account/account-structure#account-groups) associated with this user.")
    public List<String> getAccountGroups() {
        return this.accountGroups;
    }

    public void setAccountGroups(List<String> accountGroups) {
        this.accountGroups = accountGroups;
    }

    public UpdateMerchantUserRequest active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(value="Sets the status of the user to active (**true**) or inactive (**false**).")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public UpdateMerchantUserRequest authnAppsToAdd(List<String> authnAppsToAdd) {
        this.authnAppsToAdd = authnAppsToAdd;
        return this;
    }

    public UpdateMerchantUserRequest addAuthnAppsToAddItem(String authnAppsToAddItem) {
        if (this.authnAppsToAdd == null) {
            this.authnAppsToAdd = new ArrayList<String>();
        }
        this.authnAppsToAdd.add(authnAppsToAddItem);
        return this;
    }

    @ApiModelProperty(value="Set of authn apps to add to this user")
    public List<String> getAuthnAppsToAdd() {
        return this.authnAppsToAdd;
    }

    public void setAuthnAppsToAdd(List<String> authnAppsToAdd) {
        this.authnAppsToAdd = authnAppsToAdd;
    }

    public UpdateMerchantUserRequest authnAppsToRemove(List<String> authnAppsToRemove) {
        this.authnAppsToRemove = authnAppsToRemove;
        return this;
    }

    public UpdateMerchantUserRequest addAuthnAppsToRemoveItem(String authnAppsToRemoveItem) {
        if (this.authnAppsToRemove == null) {
            this.authnAppsToRemove = new ArrayList<String>();
        }
        this.authnAppsToRemove.add(authnAppsToRemoveItem);
        return this;
    }

    @ApiModelProperty(value="Set of authn apps to remove from this user")
    public List<String> getAuthnAppsToRemove() {
        return this.authnAppsToRemove;
    }

    public void setAuthnAppsToRemove(List<String> authnAppsToRemove) {
        this.authnAppsToRemove = authnAppsToRemove;
    }

    public UpdateMerchantUserRequest email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="The email address of the user.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public UpdateMerchantUserRequest name(Name2 name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="")
    public Name2 getName() {
        return this.name;
    }

    public void setName(Name2 name) {
        this.name = name;
    }

    public UpdateMerchantUserRequest roles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public UpdateMerchantUserRequest addRolesItem(String rolesItem) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        this.roles.add(rolesItem);
        return this;
    }

    @ApiModelProperty(value="The list of [roles](https://docs.adyen.com/account/user-roles) for this user.")
    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public UpdateMerchantUserRequest timeZoneCode(String timeZoneCode) {
        this.timeZoneCode = timeZoneCode;
        return this;
    }

    @ApiModelProperty(value="The [tz database name](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones) of the time zone of the user. For example, **Europe/Amsterdam**.")
    public String getTimeZoneCode() {
        return this.timeZoneCode;
    }

    public void setTimeZoneCode(String timeZoneCode) {
        this.timeZoneCode = timeZoneCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateMerchantUserRequest updateMerchantUserRequest = (UpdateMerchantUserRequest)o;
        return Objects.equals(this.accountGroups, updateMerchantUserRequest.accountGroups) && Objects.equals(this.active, updateMerchantUserRequest.active) && Objects.equals(this.authnAppsToAdd, updateMerchantUserRequest.authnAppsToAdd) && Objects.equals(this.authnAppsToRemove, updateMerchantUserRequest.authnAppsToRemove) && Objects.equals(this.email, updateMerchantUserRequest.email) && Objects.equals(this.name, updateMerchantUserRequest.name) && Objects.equals(this.roles, updateMerchantUserRequest.roles) && Objects.equals(this.timeZoneCode, updateMerchantUserRequest.timeZoneCode);
    }

    public int hashCode() {
        return Objects.hash(this.accountGroups, this.active, this.authnAppsToAdd, this.authnAppsToRemove, this.email, this.name, this.roles, this.timeZoneCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateMerchantUserRequest {\n");
        sb.append("    accountGroups: ").append(this.toIndentedString(this.accountGroups)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    authnAppsToAdd: ").append(this.toIndentedString(this.authnAppsToAdd)).append("\n");
        sb.append("    authnAppsToRemove: ").append(this.toIndentedString(this.authnAppsToRemove)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    timeZoneCode: ").append(this.toIndentedString(this.timeZoneCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in UpdateMerchantUserRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `UpdateMerchantUserRequest` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_GROUPS) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_GROUPS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `accountGroups` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_GROUPS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AUTHN_APPS_TO_ADD) != null && !jsonObj.get(SERIALIZED_NAME_AUTHN_APPS_TO_ADD).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `authnAppsToAdd` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUTHN_APPS_TO_ADD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AUTHN_APPS_TO_REMOVE) != null && !jsonObj.get(SERIALIZED_NAME_AUTHN_APPS_TO_REMOVE).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `authnAppsToRemove` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUTHN_APPS_TO_REMOVE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_EMAIL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `email` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EMAIL).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_NAME) != null) {
            Name2.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_NAME));
        }
        if (jsonObj.get(SERIALIZED_NAME_ROLES) != null && !jsonObj.get(SERIALIZED_NAME_ROLES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `roles` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROLES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TIME_ZONE_CODE) != null && !jsonObj.get(SERIALIZED_NAME_TIME_ZONE_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `timeZoneCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TIME_ZONE_CODE).toString()));
        }
    }

    public static UpdateMerchantUserRequest fromJson(String jsonString) throws IOException {
        return (UpdateMerchantUserRequest)JSON.getGson().fromJson(jsonString, UpdateMerchantUserRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_GROUPS);
        openapiFields.add(SERIALIZED_NAME_ACTIVE);
        openapiFields.add(SERIALIZED_NAME_AUTHN_APPS_TO_ADD);
        openapiFields.add(SERIALIZED_NAME_AUTHN_APPS_TO_REMOVE);
        openapiFields.add(SERIALIZED_NAME_EMAIL);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_ROLES);
        openapiFields.add(SERIALIZED_NAME_TIME_ZONE_CODE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!UpdateMerchantUserRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(UpdateMerchantUserRequest.class));
            return new TypeAdapter<UpdateMerchantUserRequest>(){

                public void write(JsonWriter out, UpdateMerchantUserRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public UpdateMerchantUserRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    UpdateMerchantUserRequest.validateJsonObject(jsonObj);
                    return (UpdateMerchantUserRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

