/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.CustomNotification;
import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class TestWebhookRequest {
    public static final String SERIALIZED_NAME_NOTIFICATION = "notification";
    @SerializedName(value="notification")
    private CustomNotification notification;
    public static final String SERIALIZED_NAME_TYPES = "types";
    @SerializedName(value="types")
    private List<String> types = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TestWebhookRequest notification(CustomNotification notification) {
        this.notification = notification;
        return this;
    }

    @ApiModelProperty(value="")
    public CustomNotification getNotification() {
        return this.notification;
    }

    public void setNotification(CustomNotification notification) {
        this.notification = notification;
    }

    public TestWebhookRequest types(List<String> types) {
        this.types = types;
        return this;
    }

    public TestWebhookRequest addTypesItem(String typesItem) {
        if (this.types == null) {
            this.types = new ArrayList<String>();
        }
        this.types.add(typesItem);
        return this;
    }

    @ApiModelProperty(value="List of event codes for which to send test notifications. Only the webhook types below are supported.   Possible values if webhook `type`: **standard**:  * **AUTHORISATION** * **CHARGEBACK_REVERSED** * **ORDER_CLOSED** * **ORDER_OPENED** * **PAIDOUT_REVERSED** * **PAYOUT_THIRDPARTY** * **REFUNDED_REVERSED** * **REFUND_WITH_DATA** * **REPORT_AVAILABLE** * **CUSTOM** - set your custom notification fields in the [`notification`](https://docs.adyen.com/api-explorer/#/ManagementService/v1/post/companies/{companyId}/webhooks/{webhookId}/test__reqParam_notification) object.  Possible values if webhook `type`: **banktransfer-notification**:  * **PENDING**  Possible values if webhook `type`: **report-notification**:  * **REPORT_AVAILABLE**  Possible values if webhook `type`: **ideal-notification**:  * **AUTHORISATION**  Possible values if webhook `type`: **pending-notification**:  * **PENDING** ")
    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestWebhookRequest testWebhookRequest = (TestWebhookRequest)o;
        return Objects.equals(this.notification, testWebhookRequest.notification) && Objects.equals(this.types, testWebhookRequest.types);
    }

    public int hashCode() {
        return Objects.hash(this.notification, this.types);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestWebhookRequest {\n");
        sb.append("    notification: ").append(this.toIndentedString(this.notification)).append("\n");
        sb.append("    types: ").append(this.toIndentedString(this.types)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TestWebhookRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TestWebhookRequest` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_NOTIFICATION) != null) {
            CustomNotification.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_NOTIFICATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPES) != null && !jsonObj.get(SERIALIZED_NAME_TYPES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `types` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPES).toString()));
        }
    }

    public static TestWebhookRequest fromJson(String jsonString) throws IOException {
        return (TestWebhookRequest)JSON.getGson().fromJson(jsonString, TestWebhookRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NOTIFICATION);
        openapiFields.add(SERIALIZED_NAME_TYPES);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TestWebhookRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TestWebhookRequest.class));
            return new TypeAdapter<TestWebhookRequest>(){

                public void write(JsonWriter out, TestWebhookRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TestWebhookRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TestWebhookRequest.validateJsonObject(jsonObj);
                    return (TestWebhookRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

