/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.PaginationLinks;
import com.adyen.model.management.PaymentMethod;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PaymentMethodResponse {
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private PaginationLinks links;
    public static final String SERIALIZED_NAME_DATA = "data";
    @SerializedName(value="data")
    private List<PaymentMethod> data = null;
    public static final String SERIALIZED_NAME_ITEMS_TOTAL = "itemsTotal";
    @SerializedName(value="itemsTotal")
    private Integer itemsTotal;
    public static final String SERIALIZED_NAME_PAGES_TOTAL = "pagesTotal";
    @SerializedName(value="pagesTotal")
    private Integer pagesTotal;
    public static final String SERIALIZED_NAME_TYPES_WITH_ERRORS = "typesWithErrors";
    @SerializedName(value="typesWithErrors")
    private List<TypesWithErrorsEnum> typesWithErrors = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PaymentMethodResponse links(PaginationLinks links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    public PaginationLinks getLinks() {
        return this.links;
    }

    public void setLinks(PaginationLinks links) {
        this.links = links;
    }

    public PaymentMethodResponse data(List<PaymentMethod> data) {
        this.data = data;
        return this;
    }

    public PaymentMethodResponse addDataItem(PaymentMethod dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<PaymentMethod>();
        }
        this.data.add(dataItem);
        return this;
    }

    @ApiModelProperty(value="Payment methods details.")
    public List<PaymentMethod> getData() {
        return this.data;
    }

    public void setData(List<PaymentMethod> data) {
        this.data = data;
    }

    public PaymentMethodResponse itemsTotal(Integer itemsTotal) {
        this.itemsTotal = itemsTotal;
        return this;
    }

    @ApiModelProperty(required=true, value="Total number of items.")
    public Integer getItemsTotal() {
        return this.itemsTotal;
    }

    public void setItemsTotal(Integer itemsTotal) {
        this.itemsTotal = itemsTotal;
    }

    public PaymentMethodResponse pagesTotal(Integer pagesTotal) {
        this.pagesTotal = pagesTotal;
        return this;
    }

    @ApiModelProperty(required=true, value="Total number of pages.")
    public Integer getPagesTotal() {
        return this.pagesTotal;
    }

    public void setPagesTotal(Integer pagesTotal) {
        this.pagesTotal = pagesTotal;
    }

    public PaymentMethodResponse typesWithErrors(List<TypesWithErrorsEnum> typesWithErrors) {
        this.typesWithErrors = typesWithErrors;
        return this;
    }

    public PaymentMethodResponse addTypesWithErrorsItem(TypesWithErrorsEnum typesWithErrorsItem) {
        if (this.typesWithErrors == null) {
            this.typesWithErrors = new ArrayList<TypesWithErrorsEnum>();
        }
        this.typesWithErrors.add(typesWithErrorsItem);
        return this;
    }

    @ApiModelProperty(value="Payment method types with errors.")
    public List<TypesWithErrorsEnum> getTypesWithErrors() {
        return this.typesWithErrors;
    }

    public void setTypesWithErrors(List<TypesWithErrorsEnum> typesWithErrors) {
        this.typesWithErrors = typesWithErrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMethodResponse paymentMethodResponse = (PaymentMethodResponse)o;
        return Objects.equals(this.links, paymentMethodResponse.links) && Objects.equals(this.data, paymentMethodResponse.data) && Objects.equals(this.itemsTotal, paymentMethodResponse.itemsTotal) && Objects.equals(this.pagesTotal, paymentMethodResponse.pagesTotal) && Objects.equals(this.typesWithErrors, paymentMethodResponse.typesWithErrors);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.data, this.itemsTotal, this.pagesTotal, this.typesWithErrors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentMethodResponse {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    itemsTotal: ").append(this.toIndentedString(this.itemsTotal)).append("\n");
        sb.append("    pagesTotal: ").append(this.toIndentedString(this.pagesTotal)).append("\n");
        sb.append("    typesWithErrors: ").append(this.toIndentedString(this.typesWithErrors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraydata;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PaymentMethodResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PaymentMethodResponse` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_LINKS) != null) {
            PaginationLinks.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_LINKS));
        }
        if ((jsonArraydata = jsonObj.getAsJsonArray(SERIALIZED_NAME_DATA)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DATA).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `data` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DATA).toString()));
            }
            for (int i = 0; i < jsonArraydata.size(); ++i) {
                PaymentMethod.validateJsonObject(jsonArraydata.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPES_WITH_ERRORS) != null && !jsonObj.get(SERIALIZED_NAME_TYPES_WITH_ERRORS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `typesWithErrors` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPES_WITH_ERRORS).toString()));
        }
    }

    public static PaymentMethodResponse fromJson(String jsonString) throws IOException {
        return (PaymentMethodResponse)JSON.getGson().fromJson(jsonString, PaymentMethodResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_DATA);
        openapiFields.add(SERIALIZED_NAME_ITEMS_TOTAL);
        openapiFields.add(SERIALIZED_NAME_PAGES_TOTAL);
        openapiFields.add(SERIALIZED_NAME_TYPES_WITH_ERRORS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ITEMS_TOTAL);
        openapiRequiredFields.add(SERIALIZED_NAME_PAGES_TOTAL);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PaymentMethodResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PaymentMethodResponse.class));
            return new TypeAdapter<PaymentMethodResponse>(){

                public void write(JsonWriter out, PaymentMethodResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PaymentMethodResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PaymentMethodResponse.validateJsonObject(jsonObj);
                    return (PaymentMethodResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypesWithErrorsEnum {
        AFTERPAYTOUCH("afterpaytouch"),
        ALIPAY("alipay"),
        ALIPAY_HK("alipay_hk"),
        AMEX("amex"),
        APPLEPAY("applepay"),
        BCMC("bcmc"),
        BLIK("blik"),
        CARTEBANCAIRE("cartebancaire"),
        CLEARPAY("clearpay"),
        CUP("cup"),
        DINERS("diners"),
        DIRECTEBANKING("directEbanking"),
        DIRECTDEBIT_GB("directdebit_GB"),
        DISCOVER("discover"),
        EBANKING_FI("ebanking_FI"),
        EFTPOS_AUSTRALIA("eftpos_australia"),
        ELO("elo"),
        ELOCREDIT("elocredit"),
        ELODEBIT("elodebit"),
        GIROCARD("girocard"),
        GIROPAY("giropay"),
        GOOGLEPAY("googlepay"),
        HIPER("hiper"),
        HIPERCARD("hipercard"),
        IDEAL("ideal"),
        INTERAC_CARD("interac_card"),
        JCB("jcb"),
        KLARNA("klarna"),
        KLARNA_ACCOUNT("klarna_account"),
        KLARNA_PAYNOW("klarna_paynow"),
        MAESTRO("maestro"),
        MBWAY("mbway"),
        MC("mc"),
        MCDEBIT("mcdebit"),
        MEALVOUCHER_FR("mealVoucher_FR"),
        MOBILEPAY("mobilepay"),
        MULTIBANCO("multibanco"),
        ONLINEBANKING_PL("onlineBanking_PL"),
        PAYPAL("paypal"),
        PAYSHOP("payshop"),
        SWISH("swish"),
        TRUSTLY("trustly"),
        VIPPS("vipps"),
        VISA("visa"),
        VISADEBIT("visadebit"),
        VPAY("vpay"),
        WECHATPAY("wechatpay"),
        WECHATPAY_POS("wechatpay_pos");

        private String value;

        private TypesWithErrorsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypesWithErrorsEnum fromValue(String value) {
            for (TypesWithErrorsEnum b : TypesWithErrorsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypesWithErrorsEnum> {
            public void write(JsonWriter jsonWriter, TypesWithErrorsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypesWithErrorsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypesWithErrorsEnum.fromValue(value);
            }
        }
    }
}

