/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class OrderItem {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_INSTALLMENTS = "installments";
    @SerializedName(value="installments")
    private Long installments;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    private Integer quantity;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public OrderItem id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the product.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public OrderItem installments(Long installments) {
        this.installments = installments;
        return this;
    }

    @ApiModelProperty(value="The number of installments for the specified product `id`.")
    public Long getInstallments() {
        return this.installments;
    }

    public void setInstallments(Long installments) {
        this.installments = installments;
    }

    public OrderItem name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the product.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OrderItem quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(value="The number of items with the specified product `id` included in the order.")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderItem orderItem = (OrderItem)o;
        return Objects.equals(this.id, orderItem.id) && Objects.equals(this.installments, orderItem.installments) && Objects.equals(this.name, orderItem.name) && Objects.equals(this.quantity, orderItem.quantity);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.installments, this.name, this.quantity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderItem {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    installments: ").append(this.toIndentedString(this.installments)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in OrderItem is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `OrderItem` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
    }

    public static OrderItem fromJson(String jsonString) throws IOException {
        return (OrderItem)JSON.getGson().fromJson(jsonString, OrderItem.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_INSTALLMENTS);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_QUANTITY);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!OrderItem.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(OrderItem.class));
            return new TypeAdapter<OrderItem>(){

                public void write(JsonWriter out, OrderItem value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public OrderItem read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    OrderItem.validateJsonObject(jsonObj);
                    return (OrderItem)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

