/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class KlarnaInfo {
    public static final String SERIALIZED_NAME_AUTO_CAPTURE = "autoCapture";
    @SerializedName(value="autoCapture")
    private Boolean autoCapture;
    public static final String SERIALIZED_NAME_DISPUTE_EMAIL = "disputeEmail";
    @SerializedName(value="disputeEmail")
    private String disputeEmail;
    public static final String SERIALIZED_NAME_REGION = "region";
    @SerializedName(value="region")
    private RegionEnum region;
    public static final String SERIALIZED_NAME_SUPPORT_EMAIL = "supportEmail";
    @SerializedName(value="supportEmail")
    private String supportEmail;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public KlarnaInfo autoCapture(Boolean autoCapture) {
        this.autoCapture = autoCapture;
        return this;
    }

    @ApiModelProperty(value="Indicates the status of [Automatic capture](https://docs.adyen.com/online-payments/capture#automatic-capture). Default value: **false**.")
    public Boolean getAutoCapture() {
        return this.autoCapture;
    }

    public void setAutoCapture(Boolean autoCapture) {
        this.autoCapture = autoCapture;
    }

    public KlarnaInfo disputeEmail(String disputeEmail) {
        this.disputeEmail = disputeEmail;
        return this;
    }

    @ApiModelProperty(required=true, value="The email address for disputes.")
    public String getDisputeEmail() {
        return this.disputeEmail;
    }

    public void setDisputeEmail(String disputeEmail) {
        this.disputeEmail = disputeEmail;
    }

    public KlarnaInfo region(RegionEnum region) {
        this.region = region;
        return this;
    }

    @ApiModelProperty(value="The region of operation. For example, **NA**, **EU**, **CH**, **AU**.")
    public RegionEnum getRegion() {
        return this.region;
    }

    public void setRegion(RegionEnum region) {
        this.region = region;
    }

    public KlarnaInfo supportEmail(String supportEmail) {
        this.supportEmail = supportEmail;
        return this;
    }

    @ApiModelProperty(required=true, value="The email address of merchant support.")
    public String getSupportEmail() {
        return this.supportEmail;
    }

    public void setSupportEmail(String supportEmail) {
        this.supportEmail = supportEmail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KlarnaInfo klarnaInfo = (KlarnaInfo)o;
        return Objects.equals(this.autoCapture, klarnaInfo.autoCapture) && Objects.equals(this.disputeEmail, klarnaInfo.disputeEmail) && Objects.equals((Object)this.region, (Object)klarnaInfo.region) && Objects.equals(this.supportEmail, klarnaInfo.supportEmail);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.autoCapture, this.disputeEmail, this.region, this.supportEmail});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KlarnaInfo {\n");
        sb.append("    autoCapture: ").append(this.toIndentedString(this.autoCapture)).append("\n");
        sb.append("    disputeEmail: ").append(this.toIndentedString(this.disputeEmail)).append("\n");
        sb.append("    region: ").append(this.toIndentedString((Object)this.region)).append("\n");
        sb.append("    supportEmail: ").append(this.toIndentedString(this.supportEmail)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in KlarnaInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `KlarnaInfo` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DISPUTE_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_DISPUTE_EMAIL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `disputeEmail` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DISPUTE_EMAIL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REGION) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_REGION).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `region` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REGION).toString()));
            }
            RegionEnum.fromValue(jsonObj.get(SERIALIZED_NAME_REGION).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_SUPPORT_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_SUPPORT_EMAIL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `supportEmail` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUPPORT_EMAIL).toString()));
        }
    }

    public static KlarnaInfo fromJson(String jsonString) throws IOException {
        return (KlarnaInfo)JSON.getGson().fromJson(jsonString, KlarnaInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AUTO_CAPTURE);
        openapiFields.add(SERIALIZED_NAME_DISPUTE_EMAIL);
        openapiFields.add(SERIALIZED_NAME_REGION);
        openapiFields.add(SERIALIZED_NAME_SUPPORT_EMAIL);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_DISPUTE_EMAIL);
        openapiRequiredFields.add(SERIALIZED_NAME_SUPPORT_EMAIL);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!KlarnaInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(KlarnaInfo.class));
            return new TypeAdapter<KlarnaInfo>(){

                public void write(JsonWriter out, KlarnaInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public KlarnaInfo read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    KlarnaInfo.validateJsonObject(jsonObj);
                    return (KlarnaInfo)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RegionEnum {
        NA("NA"),
        EU("EU"),
        CH("CH"),
        AU("AU");

        private String value;

        private RegionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RegionEnum fromValue(String value) {
            for (RegionEnum b : RegionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<RegionEnum> {
            public void write(JsonWriter jsonWriter, RegionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RegionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RegionEnum.fromValue(value);
            }
        }
    }
}

