/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.capital;

import com.adyen.model.capital.Counterparty;
import com.adyen.model.capital.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CapitalGrantInfo {
    public static final String SERIALIZED_NAME_COUNTERPARTY = "counterparty";
    @SerializedName(value="counterparty")
    private Counterparty counterparty;
    public static final String SERIALIZED_NAME_GRANT_ACCOUNT_ID = "grantAccountId";
    @SerializedName(value="grantAccountId")
    private String grantAccountId;
    public static final String SERIALIZED_NAME_GRANT_OFFER_ID = "grantOfferId";
    @SerializedName(value="grantOfferId")
    private String grantOfferId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CapitalGrantInfo counterparty(Counterparty counterparty) {
        this.counterparty = counterparty;
        return this;
    }

    @ApiModelProperty(value="")
    public Counterparty getCounterparty() {
        return this.counterparty;
    }

    public void setCounterparty(Counterparty counterparty) {
        this.counterparty = counterparty;
    }

    public CapitalGrantInfo grantAccountId(String grantAccountId) {
        this.grantAccountId = grantAccountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The identifier of the grant account used for the grant.")
    public String getGrantAccountId() {
        return this.grantAccountId;
    }

    public void setGrantAccountId(String grantAccountId) {
        this.grantAccountId = grantAccountId;
    }

    public CapitalGrantInfo grantOfferId(String grantOfferId) {
        this.grantOfferId = grantOfferId;
        return this;
    }

    @ApiModelProperty(required=true, value="The identifier of the grant offer that has been selected and from which the grant details will be used.")
    public String getGrantOfferId() {
        return this.grantOfferId;
    }

    public void setGrantOfferId(String grantOfferId) {
        this.grantOfferId = grantOfferId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CapitalGrantInfo capitalGrantInfo = (CapitalGrantInfo)o;
        return Objects.equals(this.counterparty, capitalGrantInfo.counterparty) && Objects.equals(this.grantAccountId, capitalGrantInfo.grantAccountId) && Objects.equals(this.grantOfferId, capitalGrantInfo.grantOfferId);
    }

    public int hashCode() {
        return Objects.hash(this.counterparty, this.grantAccountId, this.grantOfferId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CapitalGrantInfo {\n");
        sb.append("    counterparty: ").append(this.toIndentedString(this.counterparty)).append("\n");
        sb.append("    grantAccountId: ").append(this.toIndentedString(this.grantAccountId)).append("\n");
        sb.append("    grantOfferId: ").append(this.toIndentedString(this.grantOfferId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CapitalGrantInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CapitalGrantInfo` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_COUNTERPARTY) != null) {
            Counterparty.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_COUNTERPARTY));
        }
        if (jsonObj.get(SERIALIZED_NAME_GRANT_ACCOUNT_ID) != null && !jsonObj.get(SERIALIZED_NAME_GRANT_ACCOUNT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `grantAccountId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GRANT_ACCOUNT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GRANT_OFFER_ID) != null && !jsonObj.get(SERIALIZED_NAME_GRANT_OFFER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `grantOfferId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GRANT_OFFER_ID).toString()));
        }
    }

    public static CapitalGrantInfo fromJson(String jsonString) throws IOException {
        return (CapitalGrantInfo)JSON.getGson().fromJson(jsonString, CapitalGrantInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_COUNTERPARTY);
        openapiFields.add(SERIALIZED_NAME_GRANT_ACCOUNT_ID);
        openapiFields.add(SERIALIZED_NAME_GRANT_OFFER_ID);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_GRANT_ACCOUNT_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_GRANT_OFFER_ID);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CapitalGrantInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CapitalGrantInfo.class));
            return new TypeAdapter<CapitalGrantInfo>(){

                public void write(JsonWriter out, CapitalGrantInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CapitalGrantInfo read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CapitalGrantInfo.validateJsonObject(jsonObj);
                    return (CapitalGrantInfo)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

