/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.adyen.model.balanceplatform.TransactionRuleEntityKey;
import com.adyen.model.balanceplatform.TransactionRuleInterval;
import com.adyen.model.balanceplatform.TransactionRuleRestrictions;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class TransactionRule {
    public static final String SERIALIZED_NAME_AGGREGATION_LEVEL = "aggregationLevel";
    @SerializedName(value="aggregationLevel")
    private String aggregationLevel;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_END_DATE = "endDate";
    @SerializedName(value="endDate")
    private String endDate;
    public static final String SERIALIZED_NAME_ENTITY_KEY = "entityKey";
    @SerializedName(value="entityKey")
    private TransactionRuleEntityKey entityKey;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_INTERVAL = "interval";
    @SerializedName(value="interval")
    private TransactionRuleInterval interval;
    public static final String SERIALIZED_NAME_OUTCOME_TYPE = "outcomeType";
    @SerializedName(value="outcomeType")
    private OutcomeTypeEnum outcomeType;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_REQUEST_TYPE = "requestType";
    @SerializedName(value="requestType")
    private RequestTypeEnum requestType;
    public static final String SERIALIZED_NAME_RULE_RESTRICTIONS = "ruleRestrictions";
    @SerializedName(value="ruleRestrictions")
    private TransactionRuleRestrictions ruleRestrictions;
    public static final String SERIALIZED_NAME_SCORE = "score";
    @SerializedName(value="score")
    private Integer score;
    public static final String SERIALIZED_NAME_START_DATE = "startDate";
    @SerializedName(value="startDate")
    private String startDate;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TransactionRule aggregationLevel(String aggregationLevel) {
        this.aggregationLevel = aggregationLevel;
        return this;
    }

    @ApiModelProperty(value="The level at which data must be accumulated, used in rules with `type` **velocity** or **maxUsage**. The level must be the [same or lower in hierarchy](https://docs.adyen.com/issuing/transaction-rules#accumulate-data) than the `entityKey`.  If not provided, by default, the rule will accumulate data at the **paymentInstrument** level.  Possible values: **paymentInstrument**, **paymentInstrumentGroup**, **balanceAccount**, **accountHolder**, **balancePlatform**.")
    public String getAggregationLevel() {
        return this.aggregationLevel;
    }

    public void setAggregationLevel(String aggregationLevel) {
        this.aggregationLevel = aggregationLevel;
    }

    public TransactionRule description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="Your description for the transaction rule, maximum 300 characters.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TransactionRule endDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(value="The date when the rule will stop being evaluated, in ISO 8601 extended offset date-time format. For example, **2020-12-18T10:15:30+01:00**.  If not provided, the rule will be evaluated until the rule status is set to **inactive**.")
    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public TransactionRule entityKey(TransactionRuleEntityKey entityKey) {
        this.entityKey = entityKey;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransactionRuleEntityKey getEntityKey() {
        return this.entityKey;
    }

    public void setEntityKey(TransactionRuleEntityKey entityKey) {
        this.entityKey = entityKey;
    }

    public TransactionRule id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the transaction rule.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TransactionRule interval(TransactionRuleInterval interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransactionRuleInterval getInterval() {
        return this.interval;
    }

    public void setInterval(TransactionRuleInterval interval) {
        this.interval = interval;
    }

    public TransactionRule outcomeType(OutcomeTypeEnum outcomeType) {
        this.outcomeType = outcomeType;
        return this;
    }

    @ApiModelProperty(value="The [outcome](https://docs.adyen.com/issuing/transaction-rules#outcome) that will be applied when a transaction meets the conditions of the rule. If not provided, by default, this is set to **hardBlock**.  Possible values:   * **hardBlock**: the transaction is declined.  * **scoreBased**: the transaction is assigned the `score` you specified. Adyen calculates the total score and if it exceeds 100, the transaction is declined.")
    public OutcomeTypeEnum getOutcomeType() {
        return this.outcomeType;
    }

    public void setOutcomeType(OutcomeTypeEnum outcomeType) {
        this.outcomeType = outcomeType;
    }

    public TransactionRule reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(required=true, value="Your reference for the transaction rule, maximum 150 characters.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public TransactionRule requestType(RequestTypeEnum requestType) {
        this.requestType = requestType;
        return this;
    }

    @ApiModelProperty(value="Indicates the type of request to which the rule applies.  Possible values: **authorization**, **authentication**, **tokenization**.")
    public RequestTypeEnum getRequestType() {
        return this.requestType;
    }

    public void setRequestType(RequestTypeEnum requestType) {
        this.requestType = requestType;
    }

    public TransactionRule ruleRestrictions(TransactionRuleRestrictions ruleRestrictions) {
        this.ruleRestrictions = ruleRestrictions;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransactionRuleRestrictions getRuleRestrictions() {
        return this.ruleRestrictions;
    }

    public void setRuleRestrictions(TransactionRuleRestrictions ruleRestrictions) {
        this.ruleRestrictions = ruleRestrictions;
    }

    public TransactionRule score(Integer score) {
        this.score = score;
        return this;
    }

    @ApiModelProperty(value="A positive or negative score applied to the transaction if it meets the conditions of the rule. Required when `outcomeType` is **scoreBased**.  The value must be between **-100** and **100**.")
    public Integer getScore() {
        return this.score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    public TransactionRule startDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(value="The date when the rule will start to be evaluated, in ISO 8601 extended offset date-time format. For example, **2020-12-18T10:15:30+01:00**.  If not provided when creating a transaction rule, the `startDate` is set to the date when the rule status is set to **active**.   ")
    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public TransactionRule status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the transaction rule. If you provide a `startDate` in the request, the rule is automatically created  with an **active** status.   Possible values: **active**, **inactive**.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public TransactionRule type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The [type of rule](https://docs.adyen.com/issuing/transaction-rules#rule-types), which defines if a rule blocks transactions based on individual characteristics or accumulates data.  Possible values:  * **blockList**: decline a transaction when the conditions are met.  * **maxUsage**: add the amount or number of transactions for the lifetime of a payment instrument, and then decline a transaction when the specified limits are met.  * **velocity**: add the amount or number of transactions based on a specified time interval, and then decline a transaction when the specified limits are met. ")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionRule transactionRule = (TransactionRule)o;
        return Objects.equals(this.aggregationLevel, transactionRule.aggregationLevel) && Objects.equals(this.description, transactionRule.description) && Objects.equals(this.endDate, transactionRule.endDate) && Objects.equals(this.entityKey, transactionRule.entityKey) && Objects.equals(this.id, transactionRule.id) && Objects.equals(this.interval, transactionRule.interval) && Objects.equals((Object)this.outcomeType, (Object)transactionRule.outcomeType) && Objects.equals(this.reference, transactionRule.reference) && Objects.equals((Object)this.requestType, (Object)transactionRule.requestType) && Objects.equals(this.ruleRestrictions, transactionRule.ruleRestrictions) && Objects.equals(this.score, transactionRule.score) && Objects.equals(this.startDate, transactionRule.startDate) && Objects.equals((Object)this.status, (Object)transactionRule.status) && Objects.equals((Object)this.type, (Object)transactionRule.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.aggregationLevel, this.description, this.endDate, this.entityKey, this.id, this.interval, this.outcomeType, this.reference, this.requestType, this.ruleRestrictions, this.score, this.startDate, this.status, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionRule {\n");
        sb.append("    aggregationLevel: ").append(this.toIndentedString(this.aggregationLevel)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    entityKey: ").append(this.toIndentedString(this.entityKey)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    outcomeType: ").append(this.toIndentedString((Object)this.outcomeType)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    requestType: ").append(this.toIndentedString((Object)this.requestType)).append("\n");
        sb.append("    ruleRestrictions: ").append(this.toIndentedString(this.ruleRestrictions)).append("\n");
        sb.append("    score: ").append(this.toIndentedString(this.score)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TransactionRule is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TransactionRule` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AGGREGATION_LEVEL) != null && !jsonObj.get(SERIALIZED_NAME_AGGREGATION_LEVEL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `aggregationLevel` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AGGREGATION_LEVEL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_END_DATE) != null && !jsonObj.get(SERIALIZED_NAME_END_DATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `endDate` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_END_DATE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ENTITY_KEY) != null) {
            TransactionRuleEntityKey.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ENTITY_KEY));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_INTERVAL) != null) {
            TransactionRuleInterval.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_INTERVAL));
        }
        if (jsonObj.get(SERIALIZED_NAME_OUTCOME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_OUTCOME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `outcomeType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OUTCOME_TYPE).toString()));
            }
            OutcomeTypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_OUTCOME_TYPE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REQUEST_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_REQUEST_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `requestType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUEST_TYPE).toString()));
            }
            RequestTypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_REQUEST_TYPE).getAsString());
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_RULE_RESTRICTIONS) != null) {
            TransactionRuleRestrictions.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_RULE_RESTRICTIONS));
        }
        if (jsonObj.get(SERIALIZED_NAME_START_DATE) != null && !jsonObj.get(SERIALIZED_NAME_START_DATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `startDate` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_START_DATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
            }
            StatusEnum.fromValue(jsonObj.get(SERIALIZED_NAME_STATUS).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static TransactionRule fromJson(String jsonString) throws IOException {
        return (TransactionRule)JSON.getGson().fromJson(jsonString, TransactionRule.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AGGREGATION_LEVEL);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_END_DATE);
        openapiFields.add(SERIALIZED_NAME_ENTITY_KEY);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_INTERVAL);
        openapiFields.add(SERIALIZED_NAME_OUTCOME_TYPE);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_REQUEST_TYPE);
        openapiFields.add(SERIALIZED_NAME_RULE_RESTRICTIONS);
        openapiFields.add(SERIALIZED_NAME_SCORE);
        openapiFields.add(SERIALIZED_NAME_START_DATE);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiRequiredFields.add(SERIALIZED_NAME_ENTITY_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_INTERVAL);
        openapiRequiredFields.add(SERIALIZED_NAME_REFERENCE);
        openapiRequiredFields.add(SERIALIZED_NAME_RULE_RESTRICTIONS);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TransactionRule.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TransactionRule.class));
            return new TypeAdapter<TransactionRule>(){

                public void write(JsonWriter out, TransactionRule value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TransactionRule read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TransactionRule.validateJsonObject(jsonObj);
                    return (TransactionRule)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        ALLOWLIST("allowList"),
        BLOCKLIST("blockList"),
        MAXUSAGE("maxUsage"),
        VELOCITY("velocity");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        ACTIVE("active"),
        INACTIVE("inactive");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RequestTypeEnum {
        AUTHENTICATION("authentication"),
        AUTHORIZATION("authorization"),
        TOKENIZATION("tokenization");

        private String value;

        private RequestTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RequestTypeEnum fromValue(String value) {
            for (RequestTypeEnum b : RequestTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<RequestTypeEnum> {
            public void write(JsonWriter jsonWriter, RequestTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RequestTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RequestTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OutcomeTypeEnum {
        HARDBLOCK("hardBlock"),
        SCOREBASED("scoreBased");

        private String value;

        private OutcomeTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OutcomeTypeEnum fromValue(String value) {
            for (OutcomeTypeEnum b : OutcomeTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<OutcomeTypeEnum> {
            public void write(JsonWriter jsonWriter, OutcomeTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OutcomeTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OutcomeTypeEnum.fromValue(value);
            }
        }
    }
}

