/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class StringMatch {
    public static final String SERIALIZED_NAME_OPERATION = "operation";
    @SerializedName(value="operation")
    private OperationEnum operation;
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    private String value;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public StringMatch operation(OperationEnum operation) {
        this.operation = operation;
        return this;
    }

    @ApiModelProperty(value="The type of string matching operation. Possible values:  **startsWith**, **endsWith**, **isEqualTo**, **contains**,")
    public OperationEnum getOperation() {
        return this.operation;
    }

    public void setOperation(OperationEnum operation) {
        this.operation = operation;
    }

    public StringMatch value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="The string to be matched.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringMatch stringMatch = (StringMatch)o;
        return Objects.equals((Object)this.operation, (Object)stringMatch.operation) && Objects.equals(this.value, stringMatch.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operation, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StringMatch {\n");
        sb.append("    operation: ").append(this.toIndentedString((Object)this.operation)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in StringMatch is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `StringMatch` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OPERATION) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_OPERATION).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `operation` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OPERATION).toString()));
            }
            OperationEnum.fromValue(jsonObj.get(SERIALIZED_NAME_OPERATION).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_VALUE) != null && !jsonObj.get(SERIALIZED_NAME_VALUE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `value` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VALUE).toString()));
        }
    }

    public static StringMatch fromJson(String jsonString) throws IOException {
        return (StringMatch)JSON.getGson().fromJson(jsonString, StringMatch.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_OPERATION);
        openapiFields.add(SERIALIZED_NAME_VALUE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!StringMatch.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StringMatch.class));
            return new TypeAdapter<StringMatch>(){

                public void write(JsonWriter out, StringMatch value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public StringMatch read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    StringMatch.validateJsonObject(jsonObj);
                    return (StringMatch)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OperationEnum {
        CONTAINS("contains"),
        ENDSWITH("endsWith"),
        ISEQUALTO("isEqualTo"),
        STARTSWITH("startsWith");

        private String value;

        private OperationEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OperationEnum fromValue(String value) {
            for (OperationEnum b : OperationEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<OperationEnum> {
            public void write(JsonWriter jsonWriter, OperationEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OperationEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OperationEnum.fromValue(value);
            }
        }
    }
}

