/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.CapitalBalance;
import com.adyen.model.balanceplatform.GrantLimit;
import com.adyen.model.balanceplatform.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CapitalGrantAccount {
    public static final String SERIALIZED_NAME_BALANCES = "balances";
    @SerializedName(value="balances")
    private List<CapitalBalance> balances = null;
    public static final String SERIALIZED_NAME_FUNDING_BALANCE_ACCOUNT_ID = "fundingBalanceAccountId";
    @SerializedName(value="fundingBalanceAccountId")
    private String fundingBalanceAccountId;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_LIMITS = "limits";
    @SerializedName(value="limits")
    private List<GrantLimit> limits = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CapitalGrantAccount balances(List<CapitalBalance> balances) {
        this.balances = balances;
        return this;
    }

    public CapitalGrantAccount addBalancesItem(CapitalBalance balancesItem) {
        if (this.balances == null) {
            this.balances = new ArrayList<CapitalBalance>();
        }
        this.balances.add(balancesItem);
        return this;
    }

    @ApiModelProperty(value="The balances of the grant account.")
    public List<CapitalBalance> getBalances() {
        return this.balances;
    }

    public void setBalances(List<CapitalBalance> balances) {
        this.balances = balances;
    }

    public CapitalGrantAccount fundingBalanceAccountId(String fundingBalanceAccountId) {
        this.fundingBalanceAccountId = fundingBalanceAccountId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the balance account used to fund the grant.")
    public String getFundingBalanceAccountId() {
        return this.fundingBalanceAccountId;
    }

    public void setFundingBalanceAccountId(String fundingBalanceAccountId) {
        this.fundingBalanceAccountId = fundingBalanceAccountId;
    }

    public CapitalGrantAccount id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The identifier of the grant account.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CapitalGrantAccount limits(List<GrantLimit> limits) {
        this.limits = limits;
        return this;
    }

    public CapitalGrantAccount addLimitsItem(GrantLimit limitsItem) {
        if (this.limits == null) {
            this.limits = new ArrayList<GrantLimit>();
        }
        this.limits.add(limitsItem);
        return this;
    }

    @ApiModelProperty(value="The limits of the grant account.")
    public List<GrantLimit> getLimits() {
        return this.limits;
    }

    public void setLimits(List<GrantLimit> limits) {
        this.limits = limits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CapitalGrantAccount capitalGrantAccount = (CapitalGrantAccount)o;
        return Objects.equals(this.balances, capitalGrantAccount.balances) && Objects.equals(this.fundingBalanceAccountId, capitalGrantAccount.fundingBalanceAccountId) && Objects.equals(this.id, capitalGrantAccount.id) && Objects.equals(this.limits, capitalGrantAccount.limits);
    }

    public int hashCode() {
        return Objects.hash(this.balances, this.fundingBalanceAccountId, this.id, this.limits);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CapitalGrantAccount {\n");
        sb.append("    balances: ").append(this.toIndentedString(this.balances)).append("\n");
        sb.append("    fundingBalanceAccountId: ").append(this.toIndentedString(this.fundingBalanceAccountId)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    limits: ").append(this.toIndentedString(this.limits)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CapitalGrantAccount is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CapitalGrantAccount` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        JsonArray jsonArraybalances = jsonObj.getAsJsonArray(SERIALIZED_NAME_BALANCES);
        if (jsonArraybalances != null) {
            if (!jsonObj.get(SERIALIZED_NAME_BALANCES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `balances` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BALANCES).toString()));
            }
            for (int i = 0; i < jsonArraybalances.size(); ++i) {
                CapitalBalance.validateJsonObject(jsonArraybalances.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_FUNDING_BALANCE_ACCOUNT_ID) != null && !jsonObj.get(SERIALIZED_NAME_FUNDING_BALANCE_ACCOUNT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fundingBalanceAccountId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FUNDING_BALANCE_ACCOUNT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        JsonArray jsonArraylimits = jsonObj.getAsJsonArray(SERIALIZED_NAME_LIMITS);
        if (jsonArraylimits != null) {
            if (!jsonObj.get(SERIALIZED_NAME_LIMITS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `limits` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LIMITS).toString()));
            }
            for (int i = 0; i < jsonArraylimits.size(); ++i) {
                GrantLimit.validateJsonObject(jsonArraylimits.get(i).getAsJsonObject());
            }
        }
    }

    public static CapitalGrantAccount fromJson(String jsonString) throws IOException {
        return (CapitalGrantAccount)JSON.getGson().fromJson(jsonString, CapitalGrantAccount.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BALANCES);
        openapiFields.add(SERIALIZED_NAME_FUNDING_BALANCE_ACCOUNT_ID);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_LIMITS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CapitalGrantAccount.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CapitalGrantAccount.class));
            return new TypeAdapter<CapitalGrantAccount>(){

                public void write(JsonWriter out, CapitalGrantAccount value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CapitalGrantAccount read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CapitalGrantAccount.validateJsonObject(jsonObj);
                    return (CapitalGrantAccount)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

