/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpay;

import com.adyen.model.Amount;
import com.adyen.model.marketpay.AmountContainer;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DetailBalance {
    @SerializedName(value="pendingBalance")
    private List<AmountContainer> pendingBalanceContainers = null;
    private transient List<Amount> pendingBalance = null;
    @SerializedName(value="balance")
    private List<AmountContainer> balanceContainers = null;
    private transient List<Amount> balance = null;

    public List<Amount> getPendingBalance() {
        if (this.pendingBalance == null) {
            this.pendingBalance = new ArrayList<Amount>();
        }
        if (this.pendingBalanceContainers != null && !this.pendingBalanceContainers.isEmpty()) {
            for (AmountContainer amountContainer : this.pendingBalanceContainers) {
                this.pendingBalance.add(amountContainer.getAmount());
            }
        }
        return this.pendingBalance;
    }

    public void setPendingBalance(List<Amount> pendingBalance) {
        this.pendingBalance = pendingBalance;
        this.pendingBalanceContainers = new ArrayList<AmountContainer>();
        for (Amount amount : pendingBalance) {
            AmountContainer amountContainer = this.createAmountContainerFromAmount(amount);
            this.pendingBalanceContainers.add(amountContainer);
        }
    }

    public DetailBalance addPendingBalanceItem(Amount amount) {
        AmountContainer amountContainer = this.createAmountContainerFromAmount(amount);
        if (this.pendingBalanceContainers == null) {
            this.pendingBalanceContainers = new ArrayList<AmountContainer>();
        }
        this.pendingBalanceContainers.add(amountContainer);
        if (this.pendingBalance == null) {
            this.pendingBalance = new ArrayList<Amount>();
        }
        this.pendingBalance.add(amount);
        return this;
    }

    private AmountContainer createAmountContainerFromAmount(Amount amount) {
        AmountContainer amountContainer = new AmountContainer();
        amountContainer.setAmount(amount);
        return amountContainer;
    }

    public List<Amount> getBalance() {
        if (this.balance == null) {
            this.balance = new ArrayList<Amount>();
            if (this.balanceContainers != null && !this.balanceContainers.isEmpty()) {
                for (AmountContainer amountContainer : this.balanceContainers) {
                    this.balance.add(amountContainer.getAmount());
                }
            }
        }
        return this.balance;
    }

    public void setBalance(List<Amount> balance) {
        this.balance = balance;
        this.balanceContainers = new ArrayList<AmountContainer>();
        for (Amount amount : balance) {
            AmountContainer amountContainer = this.createAmountContainerFromAmount(amount);
            this.balanceContainers.add(amountContainer);
        }
    }

    public DetailBalance addBalanceItem(Amount amount) {
        AmountContainer amountContainer = this.createAmountContainerFromAmount(amount);
        if (this.balanceContainers == null) {
            this.balanceContainers = new ArrayList<AmountContainer>();
        }
        this.balanceContainers.add(amountContainer);
        if (this.balance == null) {
            this.balance = new ArrayList<Amount>();
        }
        this.balance.add(amount);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DetailBalance detailBalance = (DetailBalance)o;
        return Objects.equals(this.pendingBalanceContainers, detailBalance.pendingBalanceContainers) && Objects.equals(this.balanceContainers, detailBalance.balanceContainers);
    }

    public int hashCode() {
        return Objects.hash(this.pendingBalanceContainers, this.balanceContainers);
    }

    public String toString() {
        this.getPendingBalance();
        this.getBalance();
        StringBuilder sb = new StringBuilder();
        sb.append("class DetailBalance {\n");
        sb.append("    pendingBalance: ").append(this.toIndentedString(this.pendingBalance)).append("\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

