/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.ApiKeyAuthenticatedService;
import com.adyen.Client;
import com.adyen.constants.ApiConstants;
import com.adyen.model.management.CompanyApiCredential;
import com.adyen.model.management.CreateCompanyApiCredentialRequest;
import com.adyen.model.management.CreateCompanyApiCredentialResponse;
import com.adyen.model.management.JSON;
import com.adyen.model.management.ListCompanyApiCredentialsResponse;
import com.adyen.model.management.UpdateCompanyApiCredentialRequest;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.ManagementResource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ApiCredentialsCompanyLevel
extends ApiKeyAuthenticatedService {
    public ApiCredentialsCompanyLevel(Client client) {
        super(client);
        new JSON();
    }

    public ListCompanyApiCredentialsResponse listApiCredentials(String companyId, Map<String, String> queryParams) throws ApiException, IOException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("companyId", companyId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/companies/{companyId}/apiCredentials");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return ListCompanyApiCredentialsResponse.fromJson(jsonResult);
    }

    public CompanyApiCredential getApiCredential(String companyId, String apiCredentialId) throws ApiException, IOException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId'", 400);
        }
        if (apiCredentialId == null) {
            throw new ApiException("Missing the required parameter 'apiCredentialId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("companyId", companyId);
        pathParams.put("apiCredentialId", apiCredentialId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/companies/{companyId}/apiCredentials/{apiCredentialId}");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams);
        return CompanyApiCredential.fromJson(jsonResult);
    }

    public CompanyApiCredential updateApiCredential(String companyId, String apiCredentialId, UpdateCompanyApiCredentialRequest updateCompanyApiCredentialRequest) throws ApiException, IOException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId'", 400);
        }
        if (apiCredentialId == null) {
            throw new ApiException("Missing the required parameter 'apiCredentialId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("companyId", companyId);
        pathParams.put("apiCredentialId", apiCredentialId);
        String requestBody = updateCompanyApiCredentialRequest.toJson();
        ManagementResource resource = new ManagementResource(this, "/companies/{companyId}/apiCredentials/{apiCredentialId}");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.PATCH, pathParams);
        return CompanyApiCredential.fromJson(jsonResult);
    }

    public CreateCompanyApiCredentialResponse createApiCredential(String companyId, CreateCompanyApiCredentialRequest createCompanyApiCredentialRequest) throws ApiException, IOException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("companyId", companyId);
        String requestBody = createCompanyApiCredentialRequest.toJson();
        ManagementResource resource = new ManagementResource(this, "/companies/{companyId}/apiCredentials");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.POST, pathParams);
        return CreateCompanyApiCredentialResponse.fromJson(jsonResult);
    }
}

