/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service;

import com.adyen.ApiKeyAuthenticatedService;
import com.adyen.Client;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.checkout.ApplePaySessionResponse;
import com.adyen.model.checkout.ApplicationInfo;
import com.adyen.model.checkout.CardDetailsRequest;
import com.adyen.model.checkout.CardDetailsResponse;
import com.adyen.model.checkout.CheckoutBalanceCheckRequest;
import com.adyen.model.checkout.CheckoutBalanceCheckResponse;
import com.adyen.model.checkout.CheckoutCancelOrderRequest;
import com.adyen.model.checkout.CheckoutCancelOrderResponse;
import com.adyen.model.checkout.CheckoutCreateOrderRequest;
import com.adyen.model.checkout.CheckoutCreateOrderResponse;
import com.adyen.model.checkout.CommonField;
import com.adyen.model.checkout.CreateApplePaySessionRequest;
import com.adyen.model.checkout.CreateCheckoutSessionRequest;
import com.adyen.model.checkout.CreateCheckoutSessionResponse;
import com.adyen.model.checkout.CreatePaymentAmountUpdateRequest;
import com.adyen.model.checkout.CreatePaymentCancelRequest;
import com.adyen.model.checkout.CreatePaymentCaptureRequest;
import com.adyen.model.checkout.CreatePaymentLinkRequest;
import com.adyen.model.checkout.CreatePaymentRefundRequest;
import com.adyen.model.checkout.CreatePaymentReversalRequest;
import com.adyen.model.checkout.CreateStandalonePaymentCancelRequest;
import com.adyen.model.checkout.DetailsRequest;
import com.adyen.model.checkout.DonationResponse;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.ListStoredPaymentMethodsResponse;
import com.adyen.model.checkout.PaymentAmountUpdateResource;
import com.adyen.model.checkout.PaymentCancelResource;
import com.adyen.model.checkout.PaymentCaptureResource;
import com.adyen.model.checkout.PaymentDetailsResponse;
import com.adyen.model.checkout.PaymentDonationRequest;
import com.adyen.model.checkout.PaymentLinkResponse;
import com.adyen.model.checkout.PaymentMethodsRequest;
import com.adyen.model.checkout.PaymentMethodsResponse;
import com.adyen.model.checkout.PaymentRefundResource;
import com.adyen.model.checkout.PaymentRequest;
import com.adyen.model.checkout.PaymentResponse;
import com.adyen.model.checkout.PaymentReversalResource;
import com.adyen.model.checkout.PaymentSetupRequest;
import com.adyen.model.checkout.PaymentSetupResponse;
import com.adyen.model.checkout.PaymentVerificationRequest;
import com.adyen.model.checkout.PaymentVerificationResponse;
import com.adyen.model.checkout.StandalonePaymentCancelResource;
import com.adyen.model.checkout.UpdatePaymentLinkRequest;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.CheckoutResource;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;

public class Checkout
extends ApiKeyAuthenticatedService {
    private final CheckoutResource cancels = new CheckoutResource(this, "/cancels");
    private final CheckoutResource payments = new CheckoutResource(this, "/payments");
    private final CheckoutResource paymentMethods = new CheckoutResource(this, "/paymentMethods");
    private final CheckoutResource paymentsDetails = new CheckoutResource(this, "/payments/details");
    private final CheckoutResource paymentSession = new CheckoutResource(this, "/paymentSession");
    private final CheckoutResource paymentsResult = new CheckoutResource(this, "/payments/result");
    private final CheckoutResource orders = new CheckoutResource(this, "/orders");
    private final CheckoutResource ordersCancel = new CheckoutResource(this, "/orders/cancel");
    private final CheckoutResource sessions = new CheckoutResource(this, "/sessions");
    private final CheckoutResource paymentMethodsBalance = new CheckoutResource(this, "/paymentMethods/balance");
    private final CheckoutResource applePaySessions = new CheckoutResource(this, "/applePay/sessions");
    private final CheckoutResource donations = new CheckoutResource(this, "/donations");
    private final CheckoutResource cardDetails = new CheckoutResource(this, "/cardDetails");
    private final CheckoutResource paymentLinks = new CheckoutResource(this, "/paymentLinks");
    private final CheckoutResource storedPaymentMethods = new CheckoutResource(this, "/storedPaymentMethods");

    public Checkout(Client client) {
        super(client);
        new JSON();
    }

    private ApplicationInfo setApplicationInfo(ApplicationInfo applicationInfo) {
        return Optional.ofNullable(applicationInfo).orElse(new ApplicationInfo()).adyenLibrary(new CommonField().name("adyen-java-api-library").version("19.0.0"));
    }

    public PaymentResponse payments(PaymentRequest paymentRequest) throws ApiException, IOException {
        return this.payments(paymentRequest, null);
    }

    public PaymentResponse payments(PaymentRequest paymentRequest, RequestOptions requestOptions) throws ApiException, IOException {
        paymentRequest.setApplicationInfo(this.setApplicationInfo(paymentRequest.getApplicationInfo()));
        String jsonRequest = paymentRequest.toJson();
        String jsonResult = this.payments.request(jsonRequest, requestOptions);
        return PaymentResponse.fromJson(jsonResult);
    }

    public PaymentMethodsResponse paymentMethods(PaymentMethodsRequest paymentMethodsRequest) throws ApiException, IOException {
        return this.paymentMethods(paymentMethodsRequest, null);
    }

    public PaymentMethodsResponse paymentMethods(PaymentMethodsRequest paymentMethodsRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String jsonRequest = paymentMethodsRequest.toJson();
        String jsonResult = this.paymentMethods.request(jsonRequest, requestOptions);
        return PaymentMethodsResponse.fromJson(jsonResult);
    }

    public PaymentDetailsResponse paymentsDetails(DetailsRequest paymentsDetailsRequest) throws ApiException, IOException {
        return this.paymentsDetails(paymentsDetailsRequest, null);
    }

    public PaymentDetailsResponse paymentsDetails(DetailsRequest paymentsDetailsRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String jsonRequest = paymentsDetailsRequest.toJson();
        String jsonResult = this.paymentsDetails.request(jsonRequest, requestOptions);
        return PaymentDetailsResponse.fromJson(jsonResult);
    }

    public PaymentSetupResponse paymentSession(PaymentSetupRequest paymentSessionRequest) throws ApiException, IOException {
        return this.paymentSession(paymentSessionRequest, null);
    }

    public PaymentSetupResponse paymentSession(PaymentSetupRequest paymentSessionRequest, RequestOptions requestOptions) throws ApiException, IOException {
        paymentSessionRequest.setApplicationInfo(this.setApplicationInfo(paymentSessionRequest.getApplicationInfo()));
        String jsonRequest = paymentSessionRequest.toJson();
        String jsonResult = this.paymentSession.request(jsonRequest, requestOptions);
        return PaymentSetupResponse.fromJson(jsonResult);
    }

    public PaymentVerificationResponse paymentResult(PaymentVerificationRequest paymentResultRequest) throws ApiException, IOException {
        return this.paymentResult(paymentResultRequest, null);
    }

    public PaymentVerificationResponse paymentResult(PaymentVerificationRequest paymentResultRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String jsonRequest = paymentResultRequest.toJson();
        String jsonResult = this.paymentsResult.request(jsonRequest, requestOptions);
        return PaymentVerificationResponse.fromJson(jsonResult);
    }

    public CheckoutCreateOrderResponse orders(CheckoutCreateOrderRequest checkoutCreateOrderRequest) throws ApiException, IOException {
        return this.orders(checkoutCreateOrderRequest, null);
    }

    public CheckoutCreateOrderResponse orders(CheckoutCreateOrderRequest checkoutCreateOrderRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String jsonRequest = checkoutCreateOrderRequest.toJson();
        String jsonResult = this.orders.request(jsonRequest, requestOptions);
        return CheckoutCreateOrderResponse.fromJson(jsonResult);
    }

    public CheckoutCancelOrderResponse ordersCancel(CheckoutCancelOrderRequest checkoutCancelOrderRequest) throws ApiException, IOException {
        return this.ordersCancel(checkoutCancelOrderRequest, null);
    }

    public CheckoutCancelOrderResponse ordersCancel(CheckoutCancelOrderRequest checkoutCancelOrderRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String jsonRequest = checkoutCancelOrderRequest.toJson();
        String jsonResult = this.ordersCancel.request(jsonRequest, requestOptions);
        return CheckoutCancelOrderResponse.fromJson(jsonResult);
    }

    public CreateCheckoutSessionResponse sessions(CreateCheckoutSessionRequest createCheckoutSessionRequest) throws ApiException, IOException {
        return this.sessions(createCheckoutSessionRequest, null);
    }

    public CreateCheckoutSessionResponse sessions(CreateCheckoutSessionRequest createCheckoutSessionRequest, RequestOptions requestOptions) throws ApiException, IOException {
        createCheckoutSessionRequest.setApplicationInfo(this.setApplicationInfo(createCheckoutSessionRequest.getApplicationInfo()));
        String jsonRequest = createCheckoutSessionRequest.toJson();
        String jsonResult = this.sessions.request(jsonRequest, requestOptions);
        return CreateCheckoutSessionResponse.fromJson(jsonResult);
    }

    public PaymentCaptureResource paymentsCaptures(String paymentPspReference, CreatePaymentCaptureRequest createPaymentCaptureRequest) throws ApiException, IOException {
        return this.paymentsCaptures(paymentPspReference, createPaymentCaptureRequest, null);
    }

    public PaymentCaptureResource paymentsCaptures(String paymentPspReference, CreatePaymentCaptureRequest createPaymentCaptureRequest, RequestOptions requestOptions) throws ApiException, IOException {
        CheckoutResource paymentsCaptures = new CheckoutResource(this, "/payments/" + paymentPspReference + "/captures");
        String jsonRequest = createPaymentCaptureRequest.toJson();
        String jsonResult = paymentsCaptures.request(jsonRequest, requestOptions);
        return PaymentCaptureResource.fromJson(jsonResult);
    }

    public PaymentCancelResource paymentsCancels(String paymentPspReference, CreatePaymentCancelRequest createPaymentCancelRequest) throws ApiException, IOException {
        return this.paymentsCancels(paymentPspReference, createPaymentCancelRequest, null);
    }

    public PaymentCancelResource paymentsCancels(String paymentPspReference, CreatePaymentCancelRequest createPaymentCancelRequest, RequestOptions requestOptions) throws ApiException, IOException {
        CheckoutResource paymentsCancels = new CheckoutResource(this, "/payments/" + paymentPspReference + "/cancels");
        String jsonRequest = createPaymentCancelRequest.toJson();
        String jsonResult = paymentsCancels.request(jsonRequest, requestOptions);
        return PaymentCancelResource.fromJson(jsonResult);
    }

    public StandalonePaymentCancelResource cancels(CreateStandalonePaymentCancelRequest createStandalonePaymentCancelRequest) throws ApiException, IOException {
        return this.cancels(createStandalonePaymentCancelRequest, null);
    }

    public StandalonePaymentCancelResource cancels(CreateStandalonePaymentCancelRequest createStandalonePaymentCancelRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String jsonRequest = createStandalonePaymentCancelRequest.toJson();
        String jsonResult = this.cancels.request(jsonRequest, requestOptions);
        return StandalonePaymentCancelResource.fromJson(jsonResult);
    }

    public PaymentReversalResource paymentsReversals(String paymentPspReference, CreatePaymentReversalRequest createPaymentReversalRequest) throws ApiException, IOException {
        return this.paymentsReversals(paymentPspReference, createPaymentReversalRequest, null);
    }

    public PaymentReversalResource paymentsReversals(String paymentPspReference, CreatePaymentReversalRequest createPaymentReversalRequest, RequestOptions requestOptions) throws ApiException, IOException {
        CheckoutResource paymentReversal = new CheckoutResource(this, "/payments/" + paymentPspReference + "/reversals");
        String jsonRequest = createPaymentReversalRequest.toJson();
        String jsonResult = paymentReversal.request(jsonRequest, requestOptions);
        return PaymentReversalResource.fromJson(jsonResult);
    }

    public PaymentRefundResource paymentsRefunds(String paymentPspReference, CreatePaymentRefundRequest createPaymentRefundRequest) throws ApiException, IOException {
        return this.paymentsRefunds(paymentPspReference, createPaymentRefundRequest, null);
    }

    public PaymentRefundResource paymentsRefunds(String paymentPspReference, CreatePaymentRefundRequest createPaymentRefundRequest, RequestOptions requestOptions) throws ApiException, IOException {
        CheckoutResource paymentsRefunds = new CheckoutResource(this, "/payments/" + paymentPspReference + "/refunds");
        String jsonRequest = createPaymentRefundRequest.toJson();
        String jsonResult = paymentsRefunds.request(jsonRequest, requestOptions);
        return PaymentRefundResource.fromJson(jsonResult);
    }

    public PaymentAmountUpdateResource paymentsAmountUpdates(String paymentPspReference, CreatePaymentAmountUpdateRequest createPaymentAmountUpdateRequest) throws ApiException, IOException {
        return this.paymentsAmountUpdates(paymentPspReference, createPaymentAmountUpdateRequest, null);
    }

    public PaymentAmountUpdateResource paymentsAmountUpdates(String paymentPspReference, CreatePaymentAmountUpdateRequest createPaymentAmountUpdateRequest, RequestOptions requestOptions) throws ApiException, IOException {
        CheckoutResource paymentsAmountUpdates = new CheckoutResource(this, "/payments/" + paymentPspReference + "/amountUpdates");
        String jsonRequest = createPaymentAmountUpdateRequest.toJson();
        String jsonResult = paymentsAmountUpdates.request(jsonRequest, requestOptions);
        return PaymentAmountUpdateResource.fromJson(jsonResult);
    }

    public CheckoutBalanceCheckResponse paymentsMethodsBalance(CheckoutBalanceCheckRequest checkoutBalanceCheckRequest) throws ApiException, IOException {
        String jsonRequest = checkoutBalanceCheckRequest.toJson();
        String jsonResult = this.paymentMethodsBalance.request(jsonRequest);
        return CheckoutBalanceCheckResponse.fromJson(jsonResult);
    }

    public PaymentLinkResponse paymentLinks(CreatePaymentLinkRequest createPaymentLinkRequest) throws ApiException, IOException {
        return this.paymentLinks(createPaymentLinkRequest, null);
    }

    public PaymentLinkResponse paymentLinks(CreatePaymentLinkRequest createPaymentLinkRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String jsonRequest = createPaymentLinkRequest.toJson();
        String jsonResult = this.paymentLinks.request(jsonRequest, requestOptions);
        return PaymentLinkResponse.fromJson(jsonResult);
    }

    public PaymentLinkResponse getPaymentLinks(String linkId) throws ApiException, IOException {
        CheckoutResource paymentLinks = new CheckoutResource(this, "/paymentLinks/" + linkId);
        String jsonResult = paymentLinks.request("{}", ApiConstants.HttpMethod.GET);
        return PaymentLinkResponse.fromJson(jsonResult);
    }

    public PaymentLinkResponse patchPaymentLinks(String linkId, UpdatePaymentLinkRequest updatePaymentLinkRequest) throws ApiException, IOException {
        CheckoutResource paymentLinks = new CheckoutResource(this, "/paymentLinks/" + linkId);
        String jsonRequest = updatePaymentLinkRequest.toJson();
        String jsonResult = paymentLinks.request(jsonRequest, ApiConstants.HttpMethod.PATCH);
        return PaymentLinkResponse.fromJson(jsonResult);
    }

    public ApplePaySessionResponse applePaySessions(CreateApplePaySessionRequest createApplePaySessionRequest) throws ApiException, IOException {
        return this.applePaySessions(createApplePaySessionRequest, null);
    }

    public ApplePaySessionResponse applePaySessions(CreateApplePaySessionRequest createApplePaySessionRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String jsonRequest = createApplePaySessionRequest.toJson();
        String jsonResult = this.applePaySessions.request(jsonRequest, requestOptions);
        return ApplePaySessionResponse.fromJson(jsonResult);
    }

    public DonationResponse donations(PaymentDonationRequest paymentDonationRequest) throws ApiException, IOException {
        return this.donations(paymentDonationRequest, null);
    }

    public DonationResponse donations(PaymentDonationRequest paymentDonationRequest, RequestOptions requestOptions) throws ApiException, IOException {
        paymentDonationRequest.setApplicationInfo(this.setApplicationInfo(paymentDonationRequest.getApplicationInfo()));
        String jsonRequest = paymentDonationRequest.toJson();
        String jsonResult = this.donations.request(jsonRequest, requestOptions);
        return DonationResponse.fromJson(jsonResult);
    }

    public CardDetailsResponse cardDetails(CardDetailsRequest cardDetailsRequest) throws ApiException, IOException {
        return this.cardDetails(cardDetailsRequest, null);
    }

    public CardDetailsResponse cardDetails(CardDetailsRequest cardDetailsRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String jsonRequest = cardDetailsRequest.toJson();
        String jsonResult = this.cardDetails.request(jsonRequest, requestOptions);
        return CardDetailsResponse.fromJson(jsonResult);
    }

    public ListStoredPaymentMethodsResponse getStoredPaymentDetails() throws ApiException, IOException {
        return this.getStoredPaymentDetails(null);
    }

    public ListStoredPaymentMethodsResponse getStoredPaymentDetails(Map<String, String> queryParams) throws ApiException, IOException {
        String jsonResult = this.storedPaymentMethods.request("{}", null, ApiConstants.HttpMethod.GET, null, queryParams);
        return ListStoredPaymentMethodsResponse.fromJson(jsonResult);
    }

    public void deleteStoredPaymentDetails(String recurringId) throws ApiException, IOException {
        this.deleteStoredPaymentDetails(recurringId, null);
    }

    public void deleteStoredPaymentDetails(String recurringId, Map<String, String> queryParams) throws ApiException, IOException {
        CheckoutResource checkoutResource = new CheckoutResource(this, "/storedPaymentMethods/" + recurringId);
        checkoutResource.request("{}", null, ApiConstants.HttpMethod.DELETE, null, queryParams);
    }
}

