/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.recurring;

import com.adyen.model.recurring.Amount;
import com.adyen.model.recurring.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class NotifyShopperRequest {
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Amount amount;
    public static final String SERIALIZED_NAME_BILLING_DATE = "billingDate";
    @SerializedName(value="billingDate")
    private String billingDate;
    public static final String SERIALIZED_NAME_BILLING_SEQUENCE_NUMBER = "billingSequenceNumber";
    @SerializedName(value="billingSequenceNumber")
    private String billingSequenceNumber;
    public static final String SERIALIZED_NAME_DISPLAYED_REFERENCE = "displayedReference";
    @SerializedName(value="displayedReference")
    private String displayedReference;
    public static final String SERIALIZED_NAME_MERCHANT_ACCOUNT = "merchantAccount";
    @SerializedName(value="merchantAccount")
    private String merchantAccount;
    public static final String SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE = "recurringDetailReference";
    @SerializedName(value="recurringDetailReference")
    private String recurringDetailReference;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_SHOPPER_REFERENCE = "shopperReference";
    @SerializedName(value="shopperReference")
    private String shopperReference;
    public static final String SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID = "storedPaymentMethodId";
    @SerializedName(value="storedPaymentMethodId")
    private String storedPaymentMethodId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public NotifyShopperRequest amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public NotifyShopperRequest billingDate(String billingDate) {
        this.billingDate = billingDate;
        return this;
    }

    @ApiModelProperty(value="Date on which the subscription amount will be debited from the shopper. In YYYY-MM-DD format")
    public String getBillingDate() {
        return this.billingDate;
    }

    public void setBillingDate(String billingDate) {
        this.billingDate = billingDate;
    }

    public NotifyShopperRequest billingSequenceNumber(String billingSequenceNumber) {
        this.billingSequenceNumber = billingSequenceNumber;
        return this;
    }

    @ApiModelProperty(value="Sequence of the debit. Depends on Frequency and Billing Attempts Rule.")
    public String getBillingSequenceNumber() {
        return this.billingSequenceNumber;
    }

    public void setBillingSequenceNumber(String billingSequenceNumber) {
        this.billingSequenceNumber = billingSequenceNumber;
    }

    public NotifyShopperRequest displayedReference(String displayedReference) {
        this.displayedReference = displayedReference;
        return this;
    }

    @ApiModelProperty(value="Reference of Pre-debit notification that is displayed to the shopper. Optional field. Maps to reference if missing")
    public String getDisplayedReference() {
        return this.displayedReference;
    }

    public void setDisplayedReference(String displayedReference) {
        this.displayedReference = displayedReference;
    }

    public NotifyShopperRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account identifier with which you want to process the transaction.")
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public NotifyShopperRequest recurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
        return this;
    }

    @ApiModelProperty(value="This is the `recurringDetailReference` returned in the response when you created the token.")
    public String getRecurringDetailReference() {
        return this.recurringDetailReference;
    }

    public void setRecurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
    }

    public NotifyShopperRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(required=true, value="Pre-debit notification reference sent by the merchant. This is a mandatory field")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public NotifyShopperRequest shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID that uniquely identifies the shopper.  This `shopperReference` must be the same as the `shopperReference` used in the initial payment.")
    public String getShopperReference() {
        return this.shopperReference;
    }

    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public NotifyShopperRequest storedPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
        return this;
    }

    @ApiModelProperty(value="This is the `recurringDetailReference` returned in the response when you created the token.")
    public String getStoredPaymentMethodId() {
        return this.storedPaymentMethodId;
    }

    public void setStoredPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotifyShopperRequest notifyShopperRequest = (NotifyShopperRequest)o;
        return Objects.equals(this.amount, notifyShopperRequest.amount) && Objects.equals(this.billingDate, notifyShopperRequest.billingDate) && Objects.equals(this.billingSequenceNumber, notifyShopperRequest.billingSequenceNumber) && Objects.equals(this.displayedReference, notifyShopperRequest.displayedReference) && Objects.equals(this.merchantAccount, notifyShopperRequest.merchantAccount) && Objects.equals(this.recurringDetailReference, notifyShopperRequest.recurringDetailReference) && Objects.equals(this.reference, notifyShopperRequest.reference) && Objects.equals(this.shopperReference, notifyShopperRequest.shopperReference) && Objects.equals(this.storedPaymentMethodId, notifyShopperRequest.storedPaymentMethodId);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.billingDate, this.billingSequenceNumber, this.displayedReference, this.merchantAccount, this.recurringDetailReference, this.reference, this.shopperReference, this.storedPaymentMethodId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotifyShopperRequest {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    billingDate: ").append(this.toIndentedString(this.billingDate)).append("\n");
        sb.append("    billingSequenceNumber: ").append(this.toIndentedString(this.billingSequenceNumber)).append("\n");
        sb.append("    displayedReference: ").append(this.toIndentedString(this.displayedReference)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    recurringDetailReference: ").append(this.toIndentedString(this.recurringDetailReference)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    storedPaymentMethodId: ").append(this.toIndentedString(this.storedPaymentMethodId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in NotifyShopperRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `NotifyShopperRequest` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT));
        }
        if (jsonObj.get(SERIALIZED_NAME_BILLING_DATE) != null && !jsonObj.get(SERIALIZED_NAME_BILLING_DATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `billingDate` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BILLING_DATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BILLING_SEQUENCE_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_BILLING_SEQUENCE_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `billingSequenceNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BILLING_SEQUENCE_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DISPLAYED_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_DISPLAYED_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `displayedReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DISPLAYED_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `merchantAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `recurringDetailReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shopperReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID) != null && !jsonObj.get(SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `storedPaymentMethodId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID).toString()));
        }
    }

    public static NotifyShopperRequest fromJson(String jsonString) throws IOException {
        return (NotifyShopperRequest)JSON.getGson().fromJson(jsonString, NotifyShopperRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_BILLING_DATE);
        openapiFields.add(SERIALIZED_NAME_BILLING_SEQUENCE_NUMBER);
        openapiFields.add(SERIALIZED_NAME_DISPLAYED_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_AMOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_REFERENCE);
        openapiRequiredFields.add(SERIALIZED_NAME_SHOPPER_REFERENCE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!NotifyShopperRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(NotifyShopperRequest.class));
            return new TypeAdapter<NotifyShopperRequest>(){

                public void write(JsonWriter out, NotifyShopperRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public NotifyShopperRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    NotifyShopperRequest.validateJsonObject(jsonObj);
                    return (NotifyShopperRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

