/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.AllowedOrigin;
import com.adyen.model.management.ApiCredentialLinks;
import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MeApiCredential {
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private ApiCredentialLinks links;
    public static final String SERIALIZED_NAME_ACTIVE = "active";
    @SerializedName(value="active")
    private Boolean active;
    public static final String SERIALIZED_NAME_ALLOWED_IP_ADDRESSES = "allowedIpAddresses";
    @SerializedName(value="allowedIpAddresses")
    private List<String> allowedIpAddresses = new ArrayList<String>();
    public static final String SERIALIZED_NAME_ALLOWED_ORIGINS = "allowedOrigins";
    @SerializedName(value="allowedOrigins")
    private List<AllowedOrigin> allowedOrigins = null;
    public static final String SERIALIZED_NAME_ASSOCIATED_MERCHANT_ACCOUNTS = "associatedMerchantAccounts";
    @SerializedName(value="associatedMerchantAccounts")
    private List<String> associatedMerchantAccounts = null;
    public static final String SERIALIZED_NAME_CLIENT_KEY = "clientKey";
    @SerializedName(value="clientKey")
    private String clientKey;
    public static final String SERIALIZED_NAME_COMPANY_NAME = "companyName";
    @SerializedName(value="companyName")
    private String companyName;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_ROLES = "roles";
    @SerializedName(value="roles")
    private List<String> roles = new ArrayList<String>();
    public static final String SERIALIZED_NAME_USERNAME = "username";
    @SerializedName(value="username")
    private String username;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public MeApiCredential links(ApiCredentialLinks links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    public ApiCredentialLinks getLinks() {
        return this.links;
    }

    public void setLinks(ApiCredentialLinks links) {
        this.links = links;
    }

    public MeApiCredential active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates if the API credential is enabled. Must be set to **true** to use the credential in your integration.")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public MeApiCredential allowedIpAddresses(List<String> allowedIpAddresses) {
        this.allowedIpAddresses = allowedIpAddresses;
        return this;
    }

    public MeApiCredential addAllowedIpAddressesItem(String allowedIpAddressesItem) {
        this.allowedIpAddresses.add(allowedIpAddressesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of IP addresses from which your client can make requests.  If the list is empty, we allow requests from any IP. If the list is not empty and we get a request from an IP which is not on the list, you get a security error.")
    public List<String> getAllowedIpAddresses() {
        return this.allowedIpAddresses;
    }

    public void setAllowedIpAddresses(List<String> allowedIpAddresses) {
        this.allowedIpAddresses = allowedIpAddresses;
    }

    public MeApiCredential allowedOrigins(List<AllowedOrigin> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
        return this;
    }

    public MeApiCredential addAllowedOriginsItem(AllowedOrigin allowedOriginsItem) {
        if (this.allowedOrigins == null) {
            this.allowedOrigins = new ArrayList<AllowedOrigin>();
        }
        this.allowedOrigins.add(allowedOriginsItem);
        return this;
    }

    @ApiModelProperty(value="List containing the [allowed origins](https://docs.adyen.com/development-resources/client-side-authentication#allowed-origins) linked to the API credential.")
    public List<AllowedOrigin> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public void setAllowedOrigins(List<AllowedOrigin> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public MeApiCredential associatedMerchantAccounts(List<String> associatedMerchantAccounts) {
        this.associatedMerchantAccounts = associatedMerchantAccounts;
        return this;
    }

    public MeApiCredential addAssociatedMerchantAccountsItem(String associatedMerchantAccountsItem) {
        if (this.associatedMerchantAccounts == null) {
            this.associatedMerchantAccounts = new ArrayList<String>();
        }
        this.associatedMerchantAccounts.add(associatedMerchantAccountsItem);
        return this;
    }

    @ApiModelProperty(value="List of merchant accounts that the API credential has explicit access to.   If the credential has access to a company, this implies access to all merchant accounts and no merchants for that company will be included.")
    public List<String> getAssociatedMerchantAccounts() {
        return this.associatedMerchantAccounts;
    }

    public void setAssociatedMerchantAccounts(List<String> associatedMerchantAccounts) {
        this.associatedMerchantAccounts = associatedMerchantAccounts;
    }

    public MeApiCredential clientKey(String clientKey) {
        this.clientKey = clientKey;
        return this;
    }

    @ApiModelProperty(required=true, value="Public key used for [client-side authentication](https://docs.adyen.com/development-resources/client-side-authentication). The client key is required for Drop-in and Components integrations.")
    public String getClientKey() {
        return this.clientKey;
    }

    public void setClientKey(String clientKey) {
        this.clientKey = clientKey;
    }

    public MeApiCredential companyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    @ApiModelProperty(value="Name of the company linked to the API credential.")
    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public MeApiCredential description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of the API credential.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public MeApiCredential id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identifier of the API credential.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MeApiCredential roles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public MeApiCredential addRolesItem(String rolesItem) {
        this.roles.add(rolesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of [roles](https://docs.adyen.com/development-resources/api-credentials#roles-1) for the API credential.")
    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public MeApiCredential username(String username) {
        this.username = username;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the [API credential](https://docs.adyen.com/development-resources/api-credentials), for example **ws@Company.TestCompany**.")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeApiCredential meApiCredential = (MeApiCredential)o;
        return Objects.equals(this.links, meApiCredential.links) && Objects.equals(this.active, meApiCredential.active) && Objects.equals(this.allowedIpAddresses, meApiCredential.allowedIpAddresses) && Objects.equals(this.allowedOrigins, meApiCredential.allowedOrigins) && Objects.equals(this.associatedMerchantAccounts, meApiCredential.associatedMerchantAccounts) && Objects.equals(this.clientKey, meApiCredential.clientKey) && Objects.equals(this.companyName, meApiCredential.companyName) && Objects.equals(this.description, meApiCredential.description) && Objects.equals(this.id, meApiCredential.id) && Objects.equals(this.roles, meApiCredential.roles) && Objects.equals(this.username, meApiCredential.username);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.active, this.allowedIpAddresses, this.allowedOrigins, this.associatedMerchantAccounts, this.clientKey, this.companyName, this.description, this.id, this.roles, this.username);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MeApiCredential {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    allowedIpAddresses: ").append(this.toIndentedString(this.allowedIpAddresses)).append("\n");
        sb.append("    allowedOrigins: ").append(this.toIndentedString(this.allowedOrigins)).append("\n");
        sb.append("    associatedMerchantAccounts: ").append(this.toIndentedString(this.associatedMerchantAccounts)).append("\n");
        sb.append("    clientKey: ").append(this.toIndentedString(this.clientKey)).append("\n");
        sb.append("    companyName: ").append(this.toIndentedString(this.companyName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in MeApiCredential is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `MeApiCredential` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_LINKS) != null) {
            ApiCredentialLinks.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_LINKS));
        }
        if (jsonObj.get(SERIALIZED_NAME_ALLOWED_IP_ADDRESSES) != null && !jsonObj.get(SERIALIZED_NAME_ALLOWED_IP_ADDRESSES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `allowedIpAddresses` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALLOWED_IP_ADDRESSES).toString()));
        }
        JsonArray jsonArrayallowedOrigins = jsonObj.getAsJsonArray(SERIALIZED_NAME_ALLOWED_ORIGINS);
        if (jsonArrayallowedOrigins != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ALLOWED_ORIGINS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `allowedOrigins` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALLOWED_ORIGINS).toString()));
            }
            for (int i = 0; i < jsonArrayallowedOrigins.size(); ++i) {
                AllowedOrigin.validateJsonObject(jsonArrayallowedOrigins.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_ASSOCIATED_MERCHANT_ACCOUNTS) != null && !jsonObj.get(SERIALIZED_NAME_ASSOCIATED_MERCHANT_ACCOUNTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `associatedMerchantAccounts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ASSOCIATED_MERCHANT_ACCOUNTS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CLIENT_KEY) != null && !jsonObj.get(SERIALIZED_NAME_CLIENT_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `clientKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLIENT_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMPANY_NAME) != null && !jsonObj.get(SERIALIZED_NAME_COMPANY_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `companyName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMPANY_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ROLES) != null && !jsonObj.get(SERIALIZED_NAME_ROLES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `roles` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROLES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USERNAME) != null && !jsonObj.get(SERIALIZED_NAME_USERNAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `username` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USERNAME).toString()));
        }
    }

    public static MeApiCredential fromJson(String jsonString) throws IOException {
        return (MeApiCredential)JSON.getGson().fromJson(jsonString, MeApiCredential.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_ACTIVE);
        openapiFields.add(SERIALIZED_NAME_ALLOWED_IP_ADDRESSES);
        openapiFields.add(SERIALIZED_NAME_ALLOWED_ORIGINS);
        openapiFields.add(SERIALIZED_NAME_ASSOCIATED_MERCHANT_ACCOUNTS);
        openapiFields.add(SERIALIZED_NAME_CLIENT_KEY);
        openapiFields.add(SERIALIZED_NAME_COMPANY_NAME);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_ROLES);
        openapiFields.add(SERIALIZED_NAME_USERNAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ACTIVE);
        openapiRequiredFields.add(SERIALIZED_NAME_ALLOWED_IP_ADDRESSES);
        openapiRequiredFields.add(SERIALIZED_NAME_CLIENT_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_ROLES);
        openapiRequiredFields.add(SERIALIZED_NAME_USERNAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!MeApiCredential.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(MeApiCredential.class));
            return new TypeAdapter<MeApiCredential>(){

                public void write(JsonWriter out, MeApiCredential value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public MeApiCredential read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    MeApiCredential.validateJsonObject(jsonObj);
                    return (MeApiCredential)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

