/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Gratuity {
    public static final String SERIALIZED_NAME_ALLOW_CUSTOM_AMOUNT = "allowCustomAmount";
    @SerializedName(value="allowCustomAmount")
    private Boolean allowCustomAmount;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_PREDEFINED_TIP_ENTRIES = "predefinedTipEntries";
    @SerializedName(value="predefinedTipEntries")
    private List<String> predefinedTipEntries = null;
    public static final String SERIALIZED_NAME_USE_PREDEFINED_TIP_ENTRIES = "usePredefinedTipEntries";
    @SerializedName(value="usePredefinedTipEntries")
    private Boolean usePredefinedTipEntries;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Gratuity allowCustomAmount(Boolean allowCustomAmount) {
        this.allowCustomAmount = allowCustomAmount;
        return this;
    }

    @ApiModelProperty(value="Indicates whether one of the predefined tipping options is to let the shopper enter a custom tip. If **true**, only three of the other options defined in `predefinedTipEntries` are shown.")
    public Boolean getAllowCustomAmount() {
        return this.allowCustomAmount;
    }

    public void setAllowCustomAmount(Boolean allowCustomAmount) {
        this.allowCustomAmount = allowCustomAmount;
    }

    public Gratuity currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(value="The currency that the tipping settings apply to.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Gratuity predefinedTipEntries(List<String> predefinedTipEntries) {
        this.predefinedTipEntries = predefinedTipEntries;
        return this;
    }

    public Gratuity addPredefinedTipEntriesItem(String predefinedTipEntriesItem) {
        if (this.predefinedTipEntries == null) {
            this.predefinedTipEntries = new ArrayList<String>();
        }
        this.predefinedTipEntries.add(predefinedTipEntriesItem);
        return this;
    }

    @ApiModelProperty(value="Tipping options the shopper can choose from if `usePredefinedTipEntries` is **true**. The maximum number of predefined options is four, or three plus the option to enter a custom tip. The options can be a mix of:  - A percentage of the transaction amount. Example: **5%** - A tip amount in [minor units](https://docs.adyen.com/development-resources/currency-codes). Example: **500** for a EUR 5 tip.")
    public List<String> getPredefinedTipEntries() {
        return this.predefinedTipEntries;
    }

    public void setPredefinedTipEntries(List<String> predefinedTipEntries) {
        this.predefinedTipEntries = predefinedTipEntries;
    }

    public Gratuity usePredefinedTipEntries(Boolean usePredefinedTipEntries) {
        this.usePredefinedTipEntries = usePredefinedTipEntries;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the terminal shows a prompt to enter a tip (**false**), or predefined tipping options to choose from (**true**).")
    public Boolean getUsePredefinedTipEntries() {
        return this.usePredefinedTipEntries;
    }

    public void setUsePredefinedTipEntries(Boolean usePredefinedTipEntries) {
        this.usePredefinedTipEntries = usePredefinedTipEntries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Gratuity gratuity = (Gratuity)o;
        return Objects.equals(this.allowCustomAmount, gratuity.allowCustomAmount) && Objects.equals(this.currency, gratuity.currency) && Objects.equals(this.predefinedTipEntries, gratuity.predefinedTipEntries) && Objects.equals(this.usePredefinedTipEntries, gratuity.usePredefinedTipEntries);
    }

    public int hashCode() {
        return Objects.hash(this.allowCustomAmount, this.currency, this.predefinedTipEntries, this.usePredefinedTipEntries);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Gratuity {\n");
        sb.append("    allowCustomAmount: ").append(this.toIndentedString(this.allowCustomAmount)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    predefinedTipEntries: ").append(this.toIndentedString(this.predefinedTipEntries)).append("\n");
        sb.append("    usePredefinedTipEntries: ").append(this.toIndentedString(this.usePredefinedTipEntries)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Gratuity is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Gratuity` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CURRENCY) != null && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PREDEFINED_TIP_ENTRIES) != null && !jsonObj.get(SERIALIZED_NAME_PREDEFINED_TIP_ENTRIES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `predefinedTipEntries` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PREDEFINED_TIP_ENTRIES).toString()));
        }
    }

    public static Gratuity fromJson(String jsonString) throws IOException {
        return (Gratuity)JSON.getGson().fromJson(jsonString, Gratuity.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ALLOW_CUSTOM_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_CURRENCY);
        openapiFields.add(SERIALIZED_NAME_PREDEFINED_TIP_ENTRIES);
        openapiFields.add(SERIALIZED_NAME_USE_PREDEFINED_TIP_ENTRIES);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Gratuity.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Gratuity.class));
            return new TypeAdapter<Gratuity>(){

                public void write(JsonWriter out, Gratuity value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Gratuity read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Gratuity.validateJsonObject(jsonObj);
                    return (Gratuity)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

